/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.FetchConnection;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.UrlConfig;
import org.eclipse.jgit.util.SystemReader;

public class LsRemoteCommand
extends TransportCommand<LsRemoteCommand, Collection<Ref>> {
    private String remote = "origin";
    private boolean heads;
    private boolean tags;
    private String uploadPack;

    public LsRemoteCommand(Repository repo) {
        super(repo);
    }

    public LsRemoteCommand setRemote(String remote) {
        this.checkCallable();
        this.remote = remote;
        return this;
    }

    public LsRemoteCommand setHeads(boolean heads) {
        this.heads = heads;
        return this;
    }

    public LsRemoteCommand setTags(boolean tags) {
        this.tags = tags;
        return this;
    }

    public LsRemoteCommand setUploadPack(String uploadPack) {
        this.uploadPack = uploadPack;
        return this;
    }

    @Override
    public Collection<Ref> call() throws GitAPIException, InvalidRemoteException, TransportException {
        return this.execute().values();
    }

    public Map<String, Ref> callAsMap() throws GitAPIException, InvalidRemoteException, TransportException {
        return Collections.unmodifiableMap(this.execute());
    }

    /*
     * Loose catch block
     */
    private Map<String, Ref> execute() throws GitAPIException, InvalidRemoteException, TransportException {
        this.checkCallable();
        try {
            Throwable throwable = null;
            Object var2_6 = null;
            try (Transport transport = this.repo != null ? Transport.open(this.repo, this.remote) : Transport.open(new URIish(this.translate(this.remote)));){
                HashMap<String, Ref> hashMap;
                FetchConnection fc;
                Throwable throwable2;
                block30: {
                    transport.setOptionUploadPack(this.uploadPack);
                    this.configure(transport);
                    ArrayList<RefSpec> refSpecs = new ArrayList<RefSpec>(1);
                    if (this.tags) {
                        refSpecs.add(new RefSpec("refs/tags/*:refs/remotes/origin/tags/*"));
                    }
                    if (this.heads) {
                        refSpecs.add(new RefSpec("refs/heads/*:refs/remotes/origin/*"));
                    }
                    HashMap<String, Ref> refmap = new HashMap<String, Ref>();
                    throwable2 = null;
                    Object var8_13 = null;
                    fc = transport.openFetch(refSpecs, new String[0]);
                    Collection<Ref> refs = fc.getRefs();
                    if (refSpecs.isEmpty()) {
                        for (Ref r : refs) {
                            refmap.put(r.getName(), r);
                        }
                    } else {
                        block16: for (Ref r : refs) {
                            for (RefSpec rs : refSpecs) {
                                if (!rs.matchSource(r)) continue;
                                refmap.put(r.getName(), r);
                                continue block16;
                            }
                        }
                    }
                    hashMap = refmap;
                    if (fc == null) break block30;
                    fc.close();
                }
                return hashMap;
                {
                    catch (Throwable throwable3) {
                        try {
                            if (fc != null) {
                                fc.close();
                            }
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (URISyntaxException e2) {
            throw new InvalidRemoteException(MessageFormat.format(JGitText.get().invalidRemote, this.remote), e2);
        }
        catch (NotSupportedException e3) {
            throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfLsRemoteCommand, e3);
        }
        catch (IOException | ConfigInvalidException e4) {
            throw new TransportException(e4.getMessage(), e4);
        }
    }

    private String translate(String uri2) throws IOException, ConfigInvalidException {
        UrlConfig urls2 = new UrlConfig(SystemReader.getInstance().getUserConfig());
        return urls2.replace(uri2);
    }
}

