/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;

public class PackRefsCommand
extends GitCommand<String> {
    private ProgressMonitor monitor = NullProgressMonitor.INSTANCE;
    private boolean all;

    public PackRefsCommand(Repository repo) {
        super(repo);
    }

    public PackRefsCommand setProgressMonitor(ProgressMonitor monitor) {
        this.monitor = monitor;
        return this;
    }

    public PackRefsCommand setAll(boolean all) {
        this.all = all;
        return this;
    }

    public boolean isAll() {
        return this.all;
    }

    @Override
    public String call() throws GitAPIException {
        this.checkCallable();
        try {
            this.repo.getRefDatabase().packRefs(this.monitor, this);
            return JGitText.get().packRefsSuccessful;
        }
        catch (IOException e2) {
            throw new JGitInternalException(JGitText.get().packRefsFailed, e2);
        }
    }
}

