/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.net.URISyntaxException;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;

public class RemoteAddCommand
extends GitCommand<RemoteConfig> {
    private String name;
    private URIish uri;

    protected RemoteAddCommand(Repository repo) {
        super(repo);
    }

    public RemoteAddCommand setName(String name) {
        this.name = name;
        return this;
    }

    public RemoteAddCommand setUri(URIish uri2) {
        this.uri = uri2;
        return this;
    }

    @Override
    public RemoteConfig call() throws GitAPIException {
        this.checkCallable();
        try {
            StoredConfig config2 = this.repo.getConfig();
            RemoteConfig remote = new RemoteConfig(config2, this.name);
            RefSpec refSpec = new RefSpec();
            refSpec = refSpec.setForceUpdate(true);
            refSpec = refSpec.setSourceDestination("refs/heads/*", "refs/remotes/" + this.name + "/*");
            remote.addFetchRefSpec(refSpec);
            remote.addURI(this.uri);
            remote.update(config2);
            config2.save();
            return remote;
        }
        catch (IOException | URISyntaxException e2) {
            throw new JGitInternalException(e2.getMessage(), e2);
        }
    }
}

