/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.net.URISyntaxException;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.RemoteConfig;

public class RemoteRemoveCommand
extends GitCommand<RemoteConfig> {
    private String remoteName;

    protected RemoteRemoveCommand(Repository repo) {
        super(repo);
    }

    public RemoteRemoveCommand setRemoteName(String remoteName) {
        this.remoteName = remoteName;
        return this;
    }

    @Override
    public RemoteConfig call() throws GitAPIException {
        this.checkCallable();
        try {
            StoredConfig config2 = this.repo.getConfig();
            RemoteConfig remote = new RemoteConfig(config2, this.remoteName);
            config2.unsetSection("remote", this.remoteName);
            config2.save();
            return remote;
        }
        catch (IOException | URISyntaxException e2) {
            throw new JGitInternalException(e2.getMessage(), e2);
        }
    }
}

