/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.SubmoduleDeinitResult;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidConfigurationException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.submodule.SubmoduleWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.util.FileUtils;

public class SubmoduleDeinitCommand
extends GitCommand<Collection<SubmoduleDeinitResult>> {
    private final Collection<String> paths = new ArrayList<String>();
    private boolean force;

    public SubmoduleDeinitCommand(Repository repo) {
        super(repo);
    }

    @Override
    public Collection<SubmoduleDeinitResult> call() throws GitAPIException {
        this.checkCallable();
        try {
            if (this.paths.isEmpty()) {
                return Collections.emptyList();
            }
            for (String path2 : this.paths) {
                if (this.submoduleExists(path2)) continue;
                throw new NoSuchSubmoduleException(path2);
            }
            ArrayList<SubmoduleDeinitResult> results2 = new ArrayList<SubmoduleDeinitResult>(this.paths.size());
            Object object = null;
            Object var3_6 = null;
            try {
                RevWalk revWalk = new RevWalk(this.repo);
                try {
                    try (SubmoduleWalk generator = SubmoduleWalk.forIndex(this.repo);){
                        generator.setFilter(PathFilterGroup.createFromStrings(this.paths));
                        StoredConfig config2 = this.repo.getConfig();
                        while (generator.next()) {
                            String path3 = generator.getPath();
                            String name = generator.getModuleName();
                            SubmoduleDeinitStatus status2 = this.checkDirty(revWalk, path3);
                            switch (status2) {
                                case SUCCESS: {
                                    this.deinit(path3);
                                    break;
                                }
                                case ALREADY_DEINITIALIZED: {
                                    break;
                                }
                                case DIRTY: {
                                    if (!this.force) break;
                                    this.deinit(path3);
                                    status2 = SubmoduleDeinitStatus.FORCED;
                                    break;
                                }
                                default: {
                                    throw new JGitInternalException(MessageFormat.format(JGitText.get().unexpectedSubmoduleStatus, new Object[]{status2}));
                                }
                            }
                            config2.unsetSection("submodule", name);
                            results2.add(new SubmoduleDeinitResult(path3, status2));
                        }
                    }
                    if (revWalk != null) {
                        revWalk.close();
                    }
                }
                catch (Throwable throwable) {
                    if (object == null) {
                        object = throwable;
                    } else if (object != throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    if (revWalk != null) {
                        revWalk.close();
                    }
                    throw object;
                }
            }
            catch (Throwable throwable) {
                if (object == null) {
                    object = throwable;
                } else if (object != throwable) {
                    ((Throwable)object).addSuppressed(throwable);
                }
                throw object;
            }
            return results2;
        }
        catch (ConfigInvalidException e2) {
            throw new InvalidConfigurationException(e2.getMessage(), e2);
        }
        catch (IOException e3) {
            throw new JGitInternalException(e3.getMessage(), e3);
        }
    }

    private void deinit(String path2) throws IOException {
        File dir = new File(this.repo.getWorkTree(), path2);
        if (!dir.isDirectory()) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().expectedDirectoryNotSubmodule, path2));
        }
        File[] ls = dir.listFiles();
        if (ls != null) {
            File[] fileArray = ls;
            int n = ls.length;
            int n2 = 0;
            while (n2 < n) {
                File f2 = fileArray[n2];
                FileUtils.delete(f2, 1);
                ++n2;
            }
        }
    }

    /*
     * Loose catch block
     */
    private SubmoduleDeinitStatus checkDirty(RevWalk revWalk, String path2) throws GitAPIException, IOException {
        ObjectId submoduleHead;
        SubmoduleWalk w;
        Ref head2 = this.repo.exactRef("HEAD");
        if (head2 == null) {
            throw new NoHeadException(JGitText.get().invalidRepositoryStateNoHead);
        }
        RevCommit headCommit = revWalk.parseCommit(head2.getObjectId());
        RevTree tree = headCommit.getTree();
        Throwable throwable = null;
        Object var8_9 = null;
        try {
            w = SubmoduleWalk.forPath(this.repo, tree, path2);
            try {
                submoduleHead = w.getHead();
                if (submoduleHead == null) {
                    return SubmoduleDeinitStatus.ALREADY_DEINITIALIZED;
                }
                if (!submoduleHead.equals(w.getObjectId())) {
                    return SubmoduleDeinitStatus.DIRTY;
                }
            }
            finally {
                if (w != null) {
                    w.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var8_9 = null;
        try {
            w = SubmoduleWalk.forIndex(this.repo);
            try {
                SubmoduleDeinitStatus submoduleDeinitStatus;
                Repository submoduleRepo;
                Throwable throwable3;
                block37: {
                    if (!w.next()) {
                        return SubmoduleDeinitStatus.DIRTY;
                    }
                    if (!submoduleHead.equals(w.getObjectId())) {
                        return SubmoduleDeinitStatus.DIRTY;
                    }
                    throwable3 = null;
                    Object var11_16 = null;
                    submoduleRepo = w.getRepository();
                    Status status2 = Git.wrap(submoduleRepo).status().call();
                    submoduleDeinitStatus = status2.isClean() ? SubmoduleDeinitStatus.SUCCESS : SubmoduleDeinitStatus.DIRTY;
                    if (submoduleRepo == null) break block37;
                    submoduleRepo.close();
                }
                return submoduleDeinitStatus;
                {
                    catch (Throwable throwable4) {
                        try {
                            if (submoduleRepo != null) {
                                submoduleRepo.close();
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (throwable3 == null) {
                                throwable3 = throwable5;
                            } else if (throwable3 != throwable5) {
                                throwable3.addSuppressed(throwable5);
                            }
                            throw throwable3;
                        }
                    }
                }
            }
            finally {
                if (w != null) {
                    w.close();
                }
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
    }

    private boolean submoduleExists(String path2) throws IOException {
        PathFilter filter2 = PathFilter.create(path2);
        Throwable throwable = null;
        Object var4_5 = null;
        try (SubmoduleWalk w = SubmoduleWalk.forIndex(this.repo);){
            return w.setFilter(filter2).next();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public SubmoduleDeinitCommand addPath(String path2) {
        this.paths.add(path2);
        return this;
    }

    public SubmoduleDeinitCommand setForce(boolean force) {
        this.force = force;
        return this;
    }

    public static class NoSuchSubmoduleException
    extends GitAPIException {
        private static final long serialVersionUID = 1L;

        public NoSuchSubmoduleException(String path2) {
            super(MessageFormat.format(JGitText.get().noSuchSubmodule, path2));
        }
    }

    public static enum SubmoduleDeinitStatus {
        ALREADY_DEINITIALIZED,
        SUCCESS,
        FORCED,
        DIRTY;

    }
}

