/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.submodule.SubmoduleStatus;
import org.eclipse.jgit.submodule.SubmoduleStatusType;
import org.eclipse.jgit.submodule.SubmoduleWalk;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;

public class SubmoduleStatusCommand
extends GitCommand<Map<String, SubmoduleStatus>> {
    private final Collection<String> paths = new ArrayList<String>();

    public SubmoduleStatusCommand(Repository repo) {
        super(repo);
    }

    public SubmoduleStatusCommand addPath(String path2) {
        this.paths.add(path2);
        return this;
    }

    @Override
    public Map<String, SubmoduleStatus> call() throws GitAPIException {
        this.checkCallable();
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (SubmoduleWalk generator = SubmoduleWalk.forIndex(this.repo);){
                if (!this.paths.isEmpty()) {
                    generator.setFilter(PathFilterGroup.createFromStrings(this.paths));
                }
                HashMap<String, SubmoduleStatus> statuses = new HashMap<String, SubmoduleStatus>();
                while (generator.next()) {
                    SubmoduleStatus status2 = this.getStatus(generator);
                    statuses.put(status2.getPath(), status2);
                }
                return statuses;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | ConfigInvalidException e2) {
            throw new JGitInternalException(e2.getMessage(), e2);
        }
    }

    private SubmoduleStatus getStatus(SubmoduleWalk generator) throws IOException, ConfigInvalidException {
        ObjectId id = generator.getObjectId();
        String path2 = generator.getPath();
        if (generator.getModulesPath() == null) {
            return new SubmoduleStatus(SubmoduleStatusType.MISSING, path2, id);
        }
        if (generator.getConfigUrl() == null) {
            return new SubmoduleStatus(SubmoduleStatusType.UNINITIALIZED, path2, id);
        }
        ObjectId headId = null;
        Throwable throwable = null;
        Object var6_7 = null;
        try (Repository subRepo = generator.getRepository();){
            if (subRepo == null) {
                return new SubmoduleStatus(SubmoduleStatusType.UNINITIALIZED, path2, id);
            }
            headId = subRepo.resolve("HEAD");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (headId == null) {
            return new SubmoduleStatus(SubmoduleStatusType.UNINITIALIZED, path2, id, headId);
        }
        if (!headId.equals(id)) {
            return new SubmoduleStatus(SubmoduleStatusType.REV_CHECKED_OUT, path2, id, headId);
        }
        return new SubmoduleStatus(SubmoduleStatusType.INITIALIZED, path2, id, headId);
    }
}

