/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.submodule.SubmoduleWalk;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;

public class SubmoduleSyncCommand
extends GitCommand<Map<String, String>> {
    private final Collection<String> paths = new ArrayList<String>();

    public SubmoduleSyncCommand(Repository repo) {
        super(repo);
    }

    public SubmoduleSyncCommand addPath(String path2) {
        this.paths.add(path2);
        return this;
    }

    protected String getHeadBranch(Repository subRepo) throws IOException {
        Ref head2 = subRepo.exactRef("HEAD");
        if (head2 != null && head2.isSymbolic()) {
            return Repository.shortenRefName(head2.getLeaf().getName());
        }
        return null;
    }

    @Override
    public Map<String, String> call() throws GitAPIException {
        this.checkCallable();
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (SubmoduleWalk generator = SubmoduleWalk.forIndex(this.repo);){
                if (!this.paths.isEmpty()) {
                    generator.setFilter(PathFilterGroup.createFromStrings(this.paths));
                }
                HashMap<String, String> synced = new HashMap<String, String>();
                StoredConfig config2 = this.repo.getConfig();
                while (generator.next()) {
                    String remoteUrl = generator.getRemoteUrl();
                    if (remoteUrl == null) continue;
                    String path2 = generator.getPath();
                    config2.setString("submodule", path2, "url", remoteUrl);
                    synced.put(path2, remoteUrl);
                    Throwable throwable2 = null;
                    Object var9_13 = null;
                    try (Repository subRepo = generator.getRepository();){
                        if (subRepo == null) continue;
                        StoredConfig subConfig = subRepo.getConfig();
                        String branch = this.getHeadBranch(subRepo);
                        String remote = null;
                        if (branch != null) {
                            remote = subConfig.getString("branch", branch, "remote");
                        }
                        if (remote == null) {
                            remote = "origin";
                        }
                        subConfig.setString("remote", remote, "url", remoteUrl);
                        subConfig.save();
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                if (!synced.isEmpty()) {
                    config2.save();
                }
                return synced;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException | ConfigInvalidException e2) {
            throw new JGitInternalException(e2.getMessage(), e2);
        }
    }
}

