/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.attributes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.attributes.Attribute;
import org.eclipse.jgit.errors.InvalidPatternException;
import org.eclipse.jgit.ignore.IMatcher;
import org.eclipse.jgit.ignore.internal.PathMatcher;

public class AttributesRule {
    private static final String ATTRIBUTES_SPLIT_REGEX = "[ \t\r]";
    private final String pattern;
    private final List<Attribute> attributes;
    private final boolean nameOnly;
    private final boolean dirOnly;
    private final IMatcher matcher;

    private static List<Attribute> parseAttributes(String attributesLine) {
        ArrayList<Attribute> result2 = new ArrayList<Attribute>();
        String[] stringArray = attributesLine.split(ATTRIBUTES_SPLIT_REGEX);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute = stringArray[n2];
            if ((attribute = attribute.trim()).length() != 0) {
                if (attribute.startsWith("-")) {
                    if (attribute.length() > 1) {
                        result2.add(new Attribute(attribute.substring(1), Attribute.State.UNSET));
                    }
                } else if (attribute.startsWith("!")) {
                    if (attribute.length() > 1) {
                        result2.add(new Attribute(attribute.substring(1), Attribute.State.UNSPECIFIED));
                    }
                } else {
                    int equalsIndex = attribute.indexOf(61);
                    if (equalsIndex == -1) {
                        result2.add(new Attribute(attribute, Attribute.State.SET));
                    } else {
                        String attributeKey = attribute.substring(0, equalsIndex);
                        if (attributeKey.length() > 0) {
                            String attributeValue = attribute.substring(equalsIndex + 1);
                            result2.add(new Attribute(attributeKey, attributeValue));
                        }
                    }
                }
            }
            ++n2;
        }
        return result2;
    }

    public AttributesRule(String pattern2, String attributes2) {
        this.attributes = AttributesRule.parseAttributes(attributes2);
        if (((String)pattern2).endsWith("/")) {
            pattern2 = ((String)pattern2).substring(0, ((String)pattern2).length() - 1);
            this.dirOnly = true;
        } else {
            this.dirOnly = false;
        }
        int slashIndex = ((String)pattern2).indexOf(47);
        if (slashIndex < 0) {
            this.nameOnly = true;
        } else if (slashIndex == 0) {
            this.nameOnly = false;
        } else {
            this.nameOnly = false;
            pattern2 = "/" + (String)pattern2;
        }
        IMatcher candidateMatcher = IMatcher.NO_MATCH;
        try {
            candidateMatcher = PathMatcher.createPathMatcher((String)pattern2, Character.valueOf('/'), this.dirOnly);
        }
        catch (InvalidPatternException invalidPatternException) {
            // empty catch block
        }
        this.matcher = candidateMatcher;
        this.pattern = pattern2;
    }

    public boolean isDirOnly() {
        return this.dirOnly;
    }

    public List<Attribute> getAttributes() {
        return Collections.unmodifiableList(this.attributes);
    }

    public boolean isNameOnly() {
        return this.nameOnly;
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean isMatch(String relativeTarget, boolean isDirectory) {
        if (relativeTarget == null) {
            return false;
        }
        if (relativeTarget.length() == 0) {
            return false;
        }
        boolean match2 = this.matcher.matches(relativeTarget, isDirectory, true);
        return match2;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.pattern);
        for (Attribute a2 : this.attributes) {
            sb.append(" ");
            sb.append(a2);
        }
        return sb.toString();
    }
}

