/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.blame;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.eclipse.jgit.blame.Region;
import org.eclipse.jgit.blame.ReverseWalk;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.util.LfsFactory;

class Candidate {
    Candidate queueNext;
    RevCommit sourceCommit;
    PathFilter sourcePath;
    ObjectId sourceBlob;
    RawText sourceText;
    Region regionList;
    int renameScore;
    private Repository sourceRepository;

    Candidate(Repository repo, RevCommit commit, PathFilter path2) {
        this.sourceRepository = repo;
        this.sourceCommit = commit;
        this.sourcePath = path2;
    }

    void beginResult(RevWalk rw) throws MissingObjectException, IOException {
        rw.parseBody(this.sourceCommit);
    }

    int getParentCount() {
        return this.sourceCommit.getParentCount();
    }

    RevCommit getParent(int idx) {
        return this.sourceCommit.getParent(idx);
    }

    Candidate getNextCandidate(int idx) {
        return null;
    }

    boolean has(RevFlag flag) {
        return this.sourceCommit.has(flag);
    }

    void add(RevFlag flag) {
        this.sourceCommit.add(flag);
    }

    void remove(RevFlag flag) {
        this.sourceCommit.remove(flag);
    }

    int getTime() {
        return this.sourceCommit.getCommitTime();
    }

    PersonIdent getAuthor() {
        return this.sourceCommit.getAuthorIdent();
    }

    Candidate create(Repository repo, RevCommit commit, PathFilter path2) {
        return new Candidate(repo, commit, path2);
    }

    Candidate copy(RevCommit commit) {
        Candidate r = this.create(this.sourceRepository, commit, this.sourcePath);
        r.sourceBlob = this.sourceBlob;
        r.sourceText = this.sourceText;
        r.regionList = this.regionList;
        r.renameScore = this.renameScore;
        return r;
    }

    void loadText(ObjectReader reader2) throws IOException {
        ObjectLoader ldr = LfsFactory.getInstance().applySmudgeFilter(this.sourceRepository, reader2.open(this.sourceBlob, 3), LfsFactory.getAttributesForPath(this.sourceRepository, this.sourcePath.getPath(), this.sourceCommit).get("diff"));
        this.sourceText = new RawText(ldr.getCachedBytes(Integer.MAX_VALUE));
    }

    void takeBlame(EditList editList, Candidate child) {
        Candidate.blame(editList, this, child);
    }

    private static void blame(EditList editList, Candidate a2, Candidate b2) {
        int d2;
        Region r = b2.clearRegionList();
        Region aTail = null;
        Region bTail = null;
        int eIdx = 0;
        while (eIdx < editList.size()) {
            if (r == null) {
                return;
            }
            Edit e2 = (Edit)editList.get(eIdx);
            if (e2.getEndB() <= r.sourceStart) {
                ++eIdx;
                continue;
            }
            if (r.sourceStart < e2.getBeginB()) {
                d2 = e2.getBeginB() - r.sourceStart;
                if (r.length <= d2) {
                    Region next2 = r.next;
                    r.sourceStart = e2.getBeginA() - d2;
                    aTail = Candidate.add(aTail, a2, r);
                    r = next2;
                    continue;
                }
                aTail = Candidate.add(aTail, a2, r.splitFirst(e2.getBeginA() - d2, d2));
                r.slideAndShrink(d2);
            }
            if (e2.getLengthB() == 0) {
                ++eIdx;
                continue;
            }
            int rEnd = r.sourceStart + r.length;
            if (rEnd <= e2.getEndB()) {
                Region next3 = r.next;
                bTail = Candidate.add(bTail, b2, r);
                r = next3;
                if (rEnd != e2.getEndB()) continue;
                ++eIdx;
                continue;
            }
            int len2 = e2.getEndB() - r.sourceStart;
            bTail = Candidate.add(bTail, b2, r.splitFirst(r.sourceStart, len2));
            r.slideAndShrink(len2);
            ++eIdx;
        }
        if (r == null) {
            return;
        }
        Edit e3 = (Edit)editList.get(editList.size() - 1);
        int endB = e3.getEndB();
        d2 = endB - e3.getEndA();
        if (aTail == null) {
            a2.regionList = r;
        } else {
            aTail.next = r;
        }
        do {
            if (endB > r.sourceStart) continue;
            r.sourceStart -= d2;
        } while ((r = r.next) != null);
    }

    private static Region add(Region aTail, Candidate a2, Region n) {
        if (aTail == null) {
            a2.regionList = n;
            n.next = null;
            return n;
        }
        if (aTail.resultStart + aTail.length == n.resultStart && aTail.sourceStart + aTail.length == n.sourceStart) {
            aTail.length += n.length;
            return aTail;
        }
        aTail.next = n;
        n.next = null;
        return n;
    }

    private Region clearRegionList() {
        Region r = this.regionList;
        this.regionList = null;
        return r;
    }

    boolean canMergeRegions(Candidate other) {
        return Objects.equals(this.sourceCommit, other.sourceCommit) && this.sourcePath.getPath().equals(other.sourcePath.getPath());
    }

    void mergeRegions(Candidate other) {
        Region n;
        Region a2 = this.clearRegionList();
        Region b2 = other.clearRegionList();
        Region t2 = null;
        while (a2 != null && b2 != null) {
            if (a2.resultStart < b2.resultStart) {
                n = a2.next;
                t2 = Candidate.add(t2, this, a2);
                a2 = n;
                continue;
            }
            n = b2.next;
            t2 = Candidate.add(t2, this, b2);
            b2 = n;
        }
        if (a2 != null) {
            n = a2.next;
            t2 = Candidate.add(t2, this, a2);
            t2.next = n;
        } else {
            n = b2.next;
            t2 = Candidate.add(t2, this, b2);
            t2.next = n;
        }
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        r.append("Candidate[");
        r.append(this.sourcePath.getPath());
        if (this.sourceCommit != null) {
            r.append(" @ ").append(this.sourceCommit.abbreviate(6).name());
        }
        if (this.regionList != null) {
            r.append(" regions:").append(this.regionList);
        }
        r.append("]");
        return r.toString();
    }

    static final class BlobCandidate
    extends Candidate {
        Candidate parent;
        String description;

        BlobCandidate(Repository repo, String name, PathFilter path2) {
            super(repo, null, path2);
            this.description = name;
        }

        @Override
        void beginResult(RevWalk rw) {
        }

        @Override
        int getParentCount() {
            return this.parent != null ? 1 : 0;
        }

        @Override
        RevCommit getParent(int idx) {
            return null;
        }

        @Override
        Candidate getNextCandidate(int idx) {
            return this.parent;
        }

        @Override
        boolean has(RevFlag flag) {
            return true;
        }

        @Override
        void add(RevFlag flag) {
        }

        @Override
        void remove(RevFlag flag) {
        }

        @Override
        int getTime() {
            return Integer.MAX_VALUE;
        }

        @Override
        PersonIdent getAuthor() {
            return new PersonIdent(this.description, "");
        }
    }

    static final class HeadCandidate
    extends Candidate {
        private List<RevCommit> parents;

        HeadCandidate(Repository repo, PathFilter path2, List<RevCommit> parents) {
            super(repo, null, path2);
            this.parents = parents;
        }

        @Override
        void beginResult(RevWalk rw) {
        }

        @Override
        int getParentCount() {
            return this.parents.size();
        }

        @Override
        RevCommit getParent(int idx) {
            return this.parents.get(idx);
        }

        @Override
        boolean has(RevFlag flag) {
            return true;
        }

        @Override
        void add(RevFlag flag) {
        }

        @Override
        void remove(RevFlag flag) {
        }

        @Override
        int getTime() {
            return Integer.MAX_VALUE;
        }

        @Override
        PersonIdent getAuthor() {
            return new PersonIdent(JGitText.get().blameNotCommittedYet, "");
        }
    }

    static final class ReverseCandidate
    extends Candidate {
        ReverseCandidate(Repository repo, ReverseWalk.ReverseCommit commit, PathFilter path2) {
            super(repo, commit, path2);
        }

        @Override
        int getParentCount() {
            return ((ReverseWalk.ReverseCommit)this.sourceCommit).getChildCount();
        }

        @Override
        RevCommit getParent(int idx) {
            return ((ReverseWalk.ReverseCommit)this.sourceCommit).getChild(idx);
        }

        @Override
        int getTime() {
            return -this.sourceCommit.getCommitTime();
        }

        @Override
        Candidate create(Repository repo, RevCommit commit, PathFilter path2) {
            return new ReverseCandidate(repo, (ReverseWalk.ReverseCommit)commit, path2);
        }

        @Override
        public String toString() {
            return "Reverse" + super.toString();
        }
    }
}

