/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.blame;

class Region {
    Region next;
    int resultStart;
    int sourceStart;
    int length;

    Region(int rs, int ss, int len2) {
        this.resultStart = rs;
        this.sourceStart = ss;
        this.length = len2;
    }

    Region copy(int newSource2) {
        return new Region(this.resultStart, newSource2, this.length);
    }

    Region splitFirst(int newSource2, int newLen) {
        return new Region(this.resultStart, newSource2, newLen);
    }

    void slideAndShrink(int d2) {
        this.resultStart += d2;
        this.sourceStart += d2;
        this.length -= d2;
    }

    Region deepCopy() {
        Region head2;
        Region tail = head2 = new Region(this.resultStart, this.sourceStart, this.length);
        Region n = this.next;
        while (n != null) {
            Region q;
            tail.next = q = new Region(n.resultStart, n.sourceStart, n.length);
            tail = q;
            n = n.next;
        }
        return head2;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        Region r = this;
        do {
            if (r != this) {
                buf.append(',');
            }
            buf.append(r.resultStart);
            buf.append('-');
            buf.append(r.resultStart + r.length);
        } while ((r = r.next) != null);
        return buf.toString();
    }
}

