/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.blame;

import java.io.IOException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

final class ReverseWalk
extends RevWalk {
    ReverseWalk(Repository repo) {
        super(repo);
    }

    @Override
    public ReverseCommit next() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        ReverseCommit c2 = (ReverseCommit)super.next();
        if (c2 == null) {
            return null;
        }
        int pIdx = 0;
        while (pIdx < c2.getParentCount()) {
            ((ReverseCommit)c2.getParent(pIdx)).addChild(c2);
            ++pIdx;
        }
        return c2;
    }

    @Override
    protected RevCommit createCommit(AnyObjectId id) {
        return new ReverseCommit(id);
    }

    static final class ReverseCommit
    extends RevCommit {
        private static final ReverseCommit[] NO_CHILDREN = new ReverseCommit[0];
        private ReverseCommit[] children = NO_CHILDREN;

        ReverseCommit(AnyObjectId id) {
            super(id);
        }

        void addChild(ReverseCommit c2) {
            int cnt = this.children.length;
            switch (cnt) {
                case 0: {
                    this.children = new ReverseCommit[]{c2};
                    break;
                }
                case 1: {
                    this.children = new ReverseCommit[]{c2, this.children[0]};
                    break;
                }
                default: {
                    ReverseCommit[] n = new ReverseCommit[1 + cnt];
                    n[0] = c2;
                    System.arraycopy(this.children, 0, n, 1, cnt);
                    this.children = n;
                }
            }
        }

        int getChildCount() {
            return this.children.length;
        }

        ReverseCommit getChild(int nth) {
            return this.children[nth];
        }
    }
}

