/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.blame.cache;

import java.text.MessageFormat;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ObjectId;

public class CacheRegion
implements Comparable<CacheRegion> {
    private final String sourcePath;
    private final ObjectId sourceCommit;
    private final int end;
    private final int start;

    public CacheRegion(String path2, ObjectId commit, int start2, int end2) {
        CacheRegion.allOrNoneNull(path2, commit);
        this.sourcePath = path2;
        this.sourceCommit = commit;
        this.start = start2;
        this.end = end2;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public ObjectId getSourceCommit() {
        return this.sourceCommit;
    }

    @Override
    public int compareTo(CacheRegion o) {
        return this.start - o.start;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.sourceCommit != null) {
            sb.append(this.sourceCommit.name(), 0, 7).append(' ').append(" (").append(this.sourcePath).append(')');
        } else {
            sb.append("<unblamed region>");
        }
        sb.append(' ').append("start=").append(this.start).append(", count=").append(this.end - this.start);
        return sb.toString();
    }

    private static void allOrNoneNull(String path2, ObjectId commit) {
        if (path2 != null && commit != null) {
            return;
        }
        if (path2 == null && commit == null) {
            return;
        }
        throw new IllegalArgumentException(MessageFormat.format(JGitText.get().cacheRegionAllOrNoneNull, path2, commit));
    }
}

