/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.diff;

import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.diff.HistogramDiff;
import org.eclipse.jgit.diff.MyersDiff;
import org.eclipse.jgit.diff.Sequence;
import org.eclipse.jgit.diff.SequenceComparator;
import org.eclipse.jgit.diff.Subsequence;
import org.eclipse.jgit.diff.SubsequenceComparator;

public abstract class DiffAlgorithm {
    public static DiffAlgorithm getAlgorithm(SupportedAlgorithm alg) {
        switch (alg) {
            case MYERS: {
                return MyersDiff.INSTANCE;
            }
            case HISTOGRAM: {
                return new HistogramDiff();
            }
        }
        throw new IllegalArgumentException();
    }

    public <S extends Sequence> EditList diff(SequenceComparator<? super S> cmp, S a2, S b2) {
        Edit region = cmp.reduceCommonStartEnd(a2, b2, DiffAlgorithm.coverEdit(a2, b2));
        switch (region.getType()) {
            case INSERT: 
            case DELETE: {
                return EditList.singleton(region);
            }
            case REPLACE: {
                if (region.getLengthA() == 1 && region.getLengthB() == 1) {
                    return EditList.singleton(region);
                }
                SubsequenceComparator<? super S> cs = new SubsequenceComparator<S>(cmp);
                Subsequence<S> as = Subsequence.a(a2, region);
                Subsequence<S> bs = Subsequence.b(b2, region);
                EditList e2 = Subsequence.toBase(this.diffNonCommon(cs, as, bs), as, bs);
                return DiffAlgorithm.normalize(cmp, e2, a2, b2);
            }
            case EMPTY: {
                return new EditList(0);
            }
        }
        throw new IllegalStateException();
    }

    private static <S extends Sequence> Edit coverEdit(S a2, S b2) {
        return new Edit(0, a2.size(), 0, b2.size());
    }

    private static <S extends Sequence> EditList normalize(SequenceComparator<? super S> cmp, EditList e2, S a2, S b2) {
        Edit prev = null;
        int i2 = e2.size() - 1;
        while (i2 >= 0) {
            int maxB;
            Edit cur = (Edit)e2.get(i2);
            Edit.Type curType = cur.getType();
            int maxA = prev == null ? a2.size() : prev.beginA;
            int n = maxB = prev == null ? b2.size() : prev.beginB;
            if (curType == Edit.Type.INSERT) {
                while (cur.endA < maxA && cur.endB < maxB && cmp.equals(b2, cur.beginB, b2, cur.endB)) {
                    cur.shift(1);
                }
            } else if (curType == Edit.Type.DELETE) {
                while (cur.endA < maxA && cur.endB < maxB && cmp.equals(a2, cur.beginA, a2, cur.endA)) {
                    cur.shift(1);
                }
            }
            prev = cur;
            --i2;
        }
        return e2;
    }

    public abstract <S extends Sequence> EditList diffNonCommon(SequenceComparator<? super S> var1, S var2, S var3);

    public static enum SupportedAlgorithm {
        MYERS,
        HISTOGRAM;

    }
}

