/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.diff;

import org.eclipse.jgit.diff.HashedSequence;
import org.eclipse.jgit.diff.HashedSequenceComparator;
import org.eclipse.jgit.diff.Sequence;
import org.eclipse.jgit.diff.SequenceComparator;

public class HashedSequencePair<S extends Sequence> {
    private final SequenceComparator<? super S> cmp;
    private final S baseA;
    private final S baseB;
    private HashedSequence<S> cachedA;
    private HashedSequence<S> cachedB;

    public HashedSequencePair(SequenceComparator<? super S> cmp, S a2, S b2) {
        this.cmp = cmp;
        this.baseA = a2;
        this.baseB = b2;
    }

    public HashedSequenceComparator<S> getComparator() {
        return new HashedSequenceComparator<S>(this.cmp);
    }

    public HashedSequence<S> getA() {
        if (this.cachedA == null) {
            this.cachedA = this.wrap(this.baseA);
        }
        return this.cachedA;
    }

    public HashedSequence<S> getB() {
        if (this.cachedB == null) {
            this.cachedB = this.wrap(this.baseB);
        }
        return this.cachedB;
    }

    private HashedSequence<S> wrap(S base) {
        int end2 = ((Sequence)base).size();
        int[] hashes = new int[end2];
        int ptr = 0;
        while (ptr < end2) {
            hashes[ptr] = this.cmp.hash(base, ptr);
            ++ptr;
        }
        return new HashedSequence<S>(base, hashes);
    }
}

