/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.diff;

import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import org.eclipse.jgit.diff.DiffAlgorithm;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.diff.HashedSequence;
import org.eclipse.jgit.diff.HashedSequenceComparator;
import org.eclipse.jgit.diff.LowLevelDiffAlgorithm;
import org.eclipse.jgit.diff.MyersDiff;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.diff.Sequence;
import org.eclipse.jgit.errors.DiffInterruptedException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.util.IntList;
import org.eclipse.jgit.util.LongList;

public class MyersDiff<S extends Sequence> {
    public static final DiffAlgorithm INSTANCE = new LowLevelDiffAlgorithm(){

        @Override
        public <S extends Sequence> void diffNonCommon(EditList edits, HashedSequenceComparator<S> cmp, HashedSequence<S> a2, HashedSequence<S> b2, Edit region) {
            new MyersDiff<S>(edits, cmp, a2, b2, region);
        }
    };
    protected EditList edits;
    protected HashedSequenceComparator<S> cmp;
    protected HashedSequence<S> a;
    protected HashedSequence<S> b;
    MiddleEdit middle = new MiddleEdit();

    private MyersDiff(EditList edits, HashedSequenceComparator<S> cmp, HashedSequence<S> a2, HashedSequence<S> b2, Edit region) {
        this.edits = edits;
        this.cmp = cmp;
        this.a = a2;
        this.b = b2;
        this.calculateEdits(region);
    }

    private void calculateEdits(Edit r) {
        this.middle.initialize(r.beginA, r.endA, r.beginB, r.endB);
        if (this.middle.beginA >= this.middle.endA && this.middle.beginB >= this.middle.endB) {
            return;
        }
        this.calculateEdits(this.middle.beginA, this.middle.endA, this.middle.beginB, this.middle.endB);
    }

    protected void calculateEdits(int beginA, int endA, int beginB, int endB) {
        int x;
        int k2;
        Edit edit = this.middle.calculate(beginA, endA, beginB, endB);
        if (beginA < edit.beginA || beginB < edit.beginB) {
            k2 = edit.beginB - edit.beginA;
            x = this.middle.backward.snake(k2, edit.beginA);
            this.calculateEdits(beginA, x, beginB, k2 + x);
        }
        if (edit.getType() != Edit.Type.EMPTY) {
            this.edits.add(this.edits.size(), edit);
        }
        if (endA > edit.endA || endB > edit.endB) {
            k2 = edit.endB - edit.endA;
            x = this.middle.forward.snake(k2, edit.endA);
            this.calculateEdits(x, endA, k2 + x, endB);
        }
    }

    public static void main(String[] args2) {
        if (args2.length != 2) {
            MyersDiff.err().println(JGitText.get().need2Arguments);
            System.exit(1);
        }
        try {
            RawText a2 = new RawText(new File(args2[0]));
            RawText b2 = new RawText(new File(args2[1]));
            EditList r = INSTANCE.diff(RawTextComparator.DEFAULT, a2, b2);
            System.out.println(r.toString());
        }
        catch (Exception e2) {
            PrintWriter err = MyersDiff.err();
            err.println(e2.getMessage());
            e2.printStackTrace(err);
        }
    }

    private static PrintWriter err() {
        return new PrintWriter(new OutputStreamWriter((OutputStream)System.err, StandardCharsets.UTF_8));
    }

    class MiddleEdit {
        org.eclipse.jgit.diff.MyersDiff$MiddleEdit.EditPaths forward = new ForwardEditPaths();
        org.eclipse.jgit.diff.MyersDiff$MiddleEdit.EditPaths backward = new BackwardEditPaths();
        protected int beginA;
        protected int endA;
        protected int beginB;
        protected int endB;
        protected Edit edit;

        MiddleEdit() {
        }

        void initialize(int beginA, int endA, int beginB, int endB) {
            this.beginA = beginA;
            this.endA = endA;
            this.beginB = beginB;
            this.endB = endB;
            int k2 = beginB - beginA;
            this.beginA = this.forward.snake(k2, beginA);
            this.beginB = k2 + this.beginA;
            k2 = endB - endA;
            this.endA = this.backward.snake(k2, endA);
            this.endB = k2 + this.endA;
        }

        Edit calculate(int beginA, int endA, int beginB, int endB) {
            if (beginA == endA || beginB == endB) {
                return new Edit(beginA, endA, beginB, endB);
            }
            this.beginA = beginA;
            this.endA = endA;
            this.beginB = beginB;
            this.endB = endB;
            int minK = beginB - endA;
            int maxK = endB - beginA;
            this.forward.initialize(beginB - beginA, beginA, minK, maxK);
            this.backward.initialize(endB - endA, endA, minK, maxK);
            int d2 = 1;
            while (!this.forward.calculate(d2) && !this.backward.calculate(d2)) {
                ++d2;
            }
            return this.edit;
        }

        /*
         * Signature claims super is org.eclipse.jgit.diff.MyersDiff$MiddleEdit.EditPaths, not org.eclipse.jgit.diff.MyersDiff$MiddleEdit$EditPaths - discarding signature.
         */
        class BackwardEditPaths
        extends EditPaths {
            BackwardEditPaths() {
            }

            @Override
            final int snake(int k2, int x) {
                while (x > MiddleEdit.this.beginA && k2 + x > MiddleEdit.this.beginB) {
                    if (!((MiddleEdit)MiddleEdit.this).MyersDiff.this.cmp.equals(((MiddleEdit)MiddleEdit.this).MyersDiff.this.a, x - 1, ((MiddleEdit)MiddleEdit.this).MyersDiff.this.b, k2 + x - 1)) break;
                    --x;
                }
                return x;
            }

            @Override
            final int getLeft(int x) {
                return x - 1;
            }

            @Override
            final int getRight(int x) {
                return x;
            }

            @Override
            final boolean isBetter(int left, int right) {
                return left < right;
            }

            @Override
            final void adjustMinMaxK(int k2, int x) {
                if (x <= MiddleEdit.this.beginA || k2 + x <= MiddleEdit.this.beginB) {
                    if (k2 > MiddleEdit.this.forward.middleK) {
                        this.maxK = k2;
                    } else {
                        this.minK = k2;
                    }
                }
            }

            @Override
            final boolean meets(int d2, int k2, int x, long snake) {
                if (k2 < MiddleEdit.this.forward.beginK || k2 > MiddleEdit.this.forward.endK) {
                    return false;
                }
                if ((d2 + k2 - MiddleEdit.this.forward.middleK) % 2 != 0) {
                    return false;
                }
                if (x > MiddleEdit.this.forward.getX(d2, k2)) {
                    return false;
                }
                this.makeEdit(MiddleEdit.this.forward.getSnake(d2, k2), snake);
                return true;
            }
        }

        abstract class EditPaths {
            private IntList x = new IntList();
            private LongList snake = new LongList();
            int beginK;
            int endK;
            int middleK;
            int prevBeginK;
            int prevEndK;
            int minK;
            int maxK;

            EditPaths() {
            }

            final int getIndex(int d2, int k2) {
                if ((d2 + k2 - this.middleK) % 2 != 0) {
                    throw new RuntimeException(MessageFormat.format(JGitText.get().unexpectedOddResult, d2, k2, this.middleK));
                }
                return (d2 + k2 - this.middleK) / 2;
            }

            final int getX(int d2, int k2) {
                if (k2 < this.beginK || k2 > this.endK) {
                    throw new RuntimeException(MessageFormat.format(JGitText.get().kNotInRange, k2, this.beginK, this.endK));
                }
                return this.x.get(this.getIndex(d2, k2));
            }

            final long getSnake(int d2, int k2) {
                if (k2 < this.beginK || k2 > this.endK) {
                    throw new RuntimeException(MessageFormat.format(JGitText.get().kNotInRange, k2, this.beginK, this.endK));
                }
                return this.snake.get(this.getIndex(d2, k2));
            }

            private int forceKIntoRange(int k2) {
                if (k2 < this.minK) {
                    return this.minK + ((k2 ^ this.minK) & 1);
                }
                if (k2 > this.maxK) {
                    return this.maxK - ((k2 ^ this.maxK) & 1);
                }
                return k2;
            }

            void initialize(int k2, int x, int minK, int maxK) {
                this.minK = minK;
                this.maxK = maxK;
                this.endK = this.middleK = k2;
                this.beginK = this.middleK;
                this.x.clear();
                this.x.add(x);
                this.snake.clear();
                this.snake.add(this.newSnake(k2, x));
            }

            abstract int snake(int var1, int var2);

            abstract int getLeft(int var1);

            abstract int getRight(int var1);

            abstract boolean isBetter(int var1, int var2);

            abstract void adjustMinMaxK(int var1, int var2);

            abstract boolean meets(int var1, int var2, int var3, long var4);

            final long newSnake(int k2, int x) {
                long y = (long)k2 + (long)x;
                long ret = (long)x << 32;
                return ret | y;
            }

            final int snake2x(long snake) {
                return (int)(snake >>> 32);
            }

            final int snake2y(long snake) {
                return (int)snake;
            }

            final boolean makeEdit(long snake1, long snake2) {
                int x1 = this.snake2x(snake1);
                int x2 = this.snake2x(snake2);
                int y1 = this.snake2y(snake1);
                int y2 = this.snake2y(snake2);
                if (x1 > x2 || y1 > y2) {
                    x1 = x2;
                    y1 = y2;
                }
                MiddleEdit.this.edit = new Edit(x1, x2, y1, y2);
                return true;
            }

            boolean calculate(int d2) {
                this.prevBeginK = this.beginK;
                this.prevEndK = this.endK;
                this.beginK = this.forceKIntoRange(this.middleK - d2);
                int k2 = this.endK = this.forceKIntoRange(this.middleK + d2);
                while (k2 >= this.beginK) {
                    long newSnake;
                    int newX;
                    int end2;
                    int i2;
                    if (Thread.interrupted()) {
                        throw new DiffInterruptedException();
                    }
                    int left = -1;
                    int right = -1;
                    long leftSnake = -1L;
                    long rightSnake = -1L;
                    if (k2 > this.prevBeginK) {
                        i2 = this.getIndex(d2 - 1, k2 - 1);
                        left = this.x.get(i2);
                        long l = leftSnake = left != (end2 = this.snake(k2 - 1, left)) ? this.newSnake(k2 - 1, end2) : this.snake.get(i2);
                        if (this.meets(d2, k2 - 1, end2, leftSnake)) {
                            return true;
                        }
                        left = this.getLeft(end2);
                    }
                    if (k2 < this.prevEndK) {
                        i2 = this.getIndex(d2 - 1, k2 + 1);
                        right = this.x.get(i2);
                        long l = rightSnake = right != (end2 = this.snake(k2 + 1, right)) ? this.newSnake(k2 + 1, end2) : this.snake.get(i2);
                        if (this.meets(d2, k2 + 1, end2, rightSnake)) {
                            return true;
                        }
                        right = this.getRight(end2);
                    }
                    if (k2 >= this.prevEndK || k2 > this.prevBeginK && this.isBetter(left, right)) {
                        newX = left;
                        newSnake = leftSnake;
                    } else {
                        newX = right;
                        newSnake = rightSnake;
                    }
                    if (this.meets(d2, k2, newX, newSnake)) {
                        return true;
                    }
                    this.adjustMinMaxK(k2, newX);
                    int i3 = this.getIndex(d2, k2);
                    this.x.set(i3, newX);
                    this.snake.set(i3, newSnake);
                    k2 -= 2;
                }
                return false;
            }
        }

        /*
         * Signature claims super is org.eclipse.jgit.diff.MyersDiff$MiddleEdit.EditPaths, not org.eclipse.jgit.diff.MyersDiff$MiddleEdit$EditPaths - discarding signature.
         */
        class ForwardEditPaths
        extends EditPaths {
            ForwardEditPaths() {
            }

            @Override
            final int snake(int k2, int x) {
                while (x < MiddleEdit.this.endA && k2 + x < MiddleEdit.this.endB) {
                    if (!((MiddleEdit)MiddleEdit.this).MyersDiff.this.cmp.equals(((MiddleEdit)MiddleEdit.this).MyersDiff.this.a, x, ((MiddleEdit)MiddleEdit.this).MyersDiff.this.b, k2 + x)) break;
                    ++x;
                }
                return x;
            }

            @Override
            final int getLeft(int x) {
                return x;
            }

            @Override
            final int getRight(int x) {
                return x + 1;
            }

            @Override
            final boolean isBetter(int left, int right) {
                return left > right;
            }

            @Override
            final void adjustMinMaxK(int k2, int x) {
                if (x >= MiddleEdit.this.endA || k2 + x >= MiddleEdit.this.endB) {
                    if (k2 > MiddleEdit.this.backward.middleK) {
                        this.maxK = k2;
                    } else {
                        this.minK = k2;
                    }
                }
            }

            @Override
            final boolean meets(int d2, int k2, int x, long snake) {
                if (k2 < MiddleEdit.this.backward.beginK || k2 > MiddleEdit.this.backward.endK) {
                    return false;
                }
                if ((d2 - 1 + k2 - MiddleEdit.this.backward.middleK) % 2 != 0) {
                    return false;
                }
                if (x < MiddleEdit.this.backward.getX(d2 - 1, k2)) {
                    return false;
                }
                this.makeEdit(snake, MiddleEdit.this.backward.getSnake(d2 - 1, k2));
                return true;
            }
        }
    }
}

