/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.diff;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jgit.diff.Sequence;
import org.eclipse.jgit.errors.BinaryBlobException;
import org.eclipse.jgit.errors.LargeObjectException;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.IntList;
import org.eclipse.jgit.util.RawParseUtils;

public class RawText
extends Sequence {
    public static final RawText EMPTY_TEXT = new RawText(new byte[0]);
    private static final int FIRST_FEW_BYTES = 8192;
    private static final AtomicInteger BUFFER_SIZE = new AtomicInteger(8192);
    protected final byte[] content;
    protected final IntList lines;

    public RawText(byte[] input) {
        this(input, RawParseUtils.lineMap(input, 0, input.length));
    }

    public RawText(byte[] input, IntList lineMap) {
        this.content = input;
        this.lines = lineMap;
    }

    public RawText(File file2) throws IOException {
        this(IO.readFully(file2));
    }

    public byte[] getRawContent() {
        return this.content;
    }

    @Override
    public int size() {
        return this.lines.size() - 2;
    }

    public void writeLine(OutputStream out2, int i2) throws IOException {
        int start2 = this.getStart(i2);
        int end2 = this.getEnd(i2);
        if (this.content[end2 - 1] == 10) {
            --end2;
        }
        out2.write(this.content, start2, end2 - start2);
    }

    public boolean isMissingNewlineAtEnd() {
        int end2 = this.lines.get(this.lines.size() - 1);
        if (end2 == 0) {
            return true;
        }
        return this.content[end2 - 1] != 10;
    }

    public String getString(int i2) {
        return this.getString(i2, i2 + 1, true);
    }

    public ByteBuffer getRawString(int i2) {
        int s2 = this.getStart(i2);
        int e2 = this.getEnd(i2);
        if (e2 > 0 && this.content[e2 - 1] == 10) {
            --e2;
        }
        return ByteBuffer.wrap(this.content, s2, e2 - s2);
    }

    public String getString(int begin, int end2, boolean dropLF) {
        if (begin == end2) {
            return "";
        }
        int s2 = this.getStart(begin);
        int e2 = this.getEnd(end2 - 1);
        if (dropLF && this.content[e2 - 1] == 10) {
            --e2;
        }
        return this.decode(s2, e2);
    }

    protected String decode(int start2, int end2) {
        return RawParseUtils.decode(this.content, start2, end2);
    }

    private int getStart(int i2) {
        return this.lines.get(i2 + 1);
    }

    private int getEnd(int i2) {
        return this.lines.get(i2 + 2);
    }

    public static int getBufferSize() {
        return BUFFER_SIZE.get();
    }

    public static int setBufferSize(int bufferSize) {
        int newSize = Math.max(8192, bufferSize);
        return BUFFER_SIZE.updateAndGet(curr -> newSize);
    }

    public static boolean isBinary(InputStream raw) throws IOException {
        byte[] buffer = new byte[RawText.getBufferSize() + 1];
        int cnt = 0;
        while (cnt < buffer.length) {
            int n = raw.read(buffer, cnt, buffer.length - cnt);
            if (n == -1) break;
            cnt += n;
        }
        return RawText.isBinary(buffer, cnt, cnt < buffer.length);
    }

    public static boolean isBinary(byte[] raw) {
        return RawText.isBinary(raw, raw.length);
    }

    public static boolean isBinary(byte[] raw, int length) {
        return RawText.isBinary(raw, length, false);
    }

    public static boolean isBinary(byte[] raw, int length, boolean complete) {
        byte current;
        int maxLength = RawText.getBufferSize();
        boolean isComplete = complete;
        if (length > maxLength) {
            length = maxLength;
            isComplete = false;
        }
        int ptr = -1;
        while (ptr < length - 2) {
            if ((current = raw[++ptr]) != 0 && (current != 13 || raw[++ptr] == 10)) continue;
            return true;
        }
        if (ptr == length - 2) {
            return (current = raw[++ptr]) == 0 || current == 13 && isComplete;
        }
        return false;
    }

    public static boolean isBinary(byte curr, byte prev) {
        return curr == 0 || curr != 10 && prev == 13 || prev == 0;
    }

    public static boolean isCrLfText(byte[] raw) {
        return RawText.isCrLfText(raw, raw.length);
    }

    public static boolean isCrLfText(InputStream raw) throws IOException {
        byte[] buffer = new byte[RawText.getBufferSize()];
        int cnt = 0;
        while (cnt < buffer.length) {
            int n = raw.read(buffer, cnt, buffer.length - cnt);
            if (n == -1) break;
            cnt += n;
        }
        return RawText.isCrLfText(buffer, cnt);
    }

    public static boolean isCrLfText(byte[] raw, int length) {
        return RawText.isCrLfText(raw, length, false);
    }

    public static boolean isCrLfText(byte[] raw, int length, boolean complete) {
        byte current;
        boolean has_crlf = false;
        int ptr = -1;
        while (ptr < length - 2) {
            if ((current = raw[++ptr]) == 0) {
                return false;
            }
            if (current != 13) continue;
            if (raw[++ptr] != 10) {
                return false;
            }
            has_crlf = true;
        }
        if (ptr == length - 2 && ((current = raw[++ptr]) == 0 || current == 13 && complete)) {
            return false;
        }
        return has_crlf;
    }

    public String getLineDelimiter() {
        if (this.size() == 0) {
            return null;
        }
        int e2 = this.getEnd(0);
        if (this.content[e2 - 1] != 10) {
            return null;
        }
        if (this.content.length > 1 && e2 > 1 && this.content[e2 - 2] == 13) {
            return "\r\n";
        }
        return "\n";
    }

    public static RawText load(ObjectLoader ldr, int threshold) throws IOException, BinaryBlobException {
        long sz = ldr.getSize();
        if (sz > (long)threshold) {
            throw new BinaryBlobException();
        }
        int bufferSize = RawText.getBufferSize();
        if (sz <= (long)bufferSize) {
            byte[] data2 = ldr.getCachedBytes(bufferSize);
            if (RawText.isBinary(data2, data2.length, true)) {
                throw new BinaryBlobException();
            }
            return new RawText(data2);
        }
        byte[] head2 = new byte[bufferSize];
        Throwable throwable = null;
        Object var7_8 = null;
        try (ObjectStream stream = ldr.openStream();){
            byte[] data3;
            int off = 0;
            int left = head2.length;
            byte last2 = 120;
            while (left > 0) {
                int n = stream.read(head2, off, left);
                if (n < 0) {
                    throw new EOFException();
                }
                left -= n;
                while (n > 0) {
                    byte curr = head2[off];
                    if (RawText.isBinary(curr, last2)) {
                        throw new BinaryBlobException();
                    }
                    last2 = curr;
                    ++off;
                    --n;
                }
            }
            try {
                data3 = new byte[(int)sz];
            }
            catch (OutOfMemoryError e2) {
                throw new LargeObjectException.OutOfMemory(e2);
            }
            System.arraycopy(head2, 0, data3, 0, head2.length);
            IO.readFully(stream, data3, off, (int)(sz - (long)off));
            return new RawText(data3, RawParseUtils.lineMapOrBinary(data3, 0, (int)sz));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

