/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.diff;

import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.SequenceComparator;
import org.eclipse.jgit.util.IntList;
import org.eclipse.jgit.util.RawCharUtil;

public abstract class RawTextComparator
extends SequenceComparator<RawText> {
    public static final RawTextComparator DEFAULT = new RawTextComparator(){

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean equals(RawText a, int ai, RawText b, int bi) {
            as = a.lines.get(++ai);
            bs = b.lines.get(++bi);
            ae = a.lines.get(ai + 1);
            if (ae - as == (be = b.lines.get(bi + 1)) - bs) ** GOTO lbl8
            return false;
lbl-1000:
            // 1 sources

            {
                if (a.content[as++] == b.content[bs++]) continue;
                return false;
lbl8:
                // 2 sources

                ** while (as < ae)
            }
lbl9:
            // 1 sources

            return true;
        }

        @Override
        protected int hashRegion(byte[] raw, int ptr, int end2) {
            int hash = 5381;
            while (ptr < end2) {
                hash = (hash << 5) + hash + (raw[ptr] & 0xFF);
                ++ptr;
            }
            return hash;
        }
    };
    public static final RawTextComparator WS_IGNORE_ALL = new RawTextComparator(){

        @Override
        public boolean equals(RawText a2, int ai, RawText b2, int bi) {
            int as = a2.lines.get(++ai);
            int bs = b2.lines.get(++bi);
            int ae = a2.lines.get(ai + 1);
            int be = b2.lines.get(bi + 1);
            ae = RawCharUtil.trimTrailingWhitespace(a2.content, as, ae);
            be = RawCharUtil.trimTrailingWhitespace(b2.content, bs, be);
            while (as < ae && bs < be) {
                byte ac = a2.content[as];
                byte bc = b2.content[bs];
                while (as < ae - 1 && RawCharUtil.isWhitespace(ac)) {
                    ac = a2.content[++as];
                }
                while (bs < be - 1 && RawCharUtil.isWhitespace(bc)) {
                    bc = b2.content[++bs];
                }
                if (ac != bc) {
                    return false;
                }
                ++as;
                ++bs;
            }
            return as == ae && bs == be;
        }

        @Override
        protected int hashRegion(byte[] raw, int ptr, int end2) {
            int hash = 5381;
            while (ptr < end2) {
                byte c2 = raw[ptr];
                if (!RawCharUtil.isWhitespace(c2)) {
                    hash = (hash << 5) + hash + (c2 & 0xFF);
                }
                ++ptr;
            }
            return hash;
        }
    };
    public static final RawTextComparator WS_IGNORE_LEADING = new RawTextComparator(){

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean equals(RawText a, int ai, RawText b, int bi) {
            as = a.lines.get(++ai);
            bs = b.lines.get(++bi);
            ae = a.lines.get(ai + 1);
            be = b.lines.get(bi + 1);
            if (ae - (as = RawCharUtil.trimLeadingWhitespace(a.content, as, ae)) == be - (bs = RawCharUtil.trimLeadingWhitespace(b.content, bs, be))) ** GOTO lbl9
            return false;
lbl-1000:
            // 1 sources

            {
                if (a.content[as++] == b.content[bs++]) continue;
                return false;
lbl9:
                // 2 sources

                ** while (as < ae)
            }
lbl10:
            // 1 sources

            return true;
        }

        @Override
        protected int hashRegion(byte[] raw, int ptr, int end2) {
            int hash = 5381;
            ptr = RawCharUtil.trimLeadingWhitespace(raw, ptr, end2);
            while (ptr < end2) {
                hash = (hash << 5) + hash + (raw[ptr] & 0xFF);
                ++ptr;
            }
            return hash;
        }
    };
    public static final RawTextComparator WS_IGNORE_TRAILING = new RawTextComparator(){

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean equals(RawText a, int ai, RawText b, int bi) {
            as = a.lines.get(++ai);
            bs = b.lines.get(++bi);
            ae = a.lines.get(ai + 1);
            be = b.lines.get(bi + 1);
            if ((ae = RawCharUtil.trimTrailingWhitespace(a.content, as, ae)) - as == (be = RawCharUtil.trimTrailingWhitespace(b.content, bs, be)) - bs) ** GOTO lbl9
            return false;
lbl-1000:
            // 1 sources

            {
                if (a.content[as++] == b.content[bs++]) continue;
                return false;
lbl9:
                // 2 sources

                ** while (as < ae)
            }
lbl10:
            // 1 sources

            return true;
        }

        @Override
        protected int hashRegion(byte[] raw, int ptr, int end2) {
            int hash = 5381;
            end2 = RawCharUtil.trimTrailingWhitespace(raw, ptr, end2);
            while (ptr < end2) {
                hash = (hash << 5) + hash + (raw[ptr] & 0xFF);
                ++ptr;
            }
            return hash;
        }
    };
    public static final RawTextComparator WS_IGNORE_CHANGE = new RawTextComparator(){

        @Override
        public boolean equals(RawText a2, int ai, RawText b2, int bi) {
            int as = a2.lines.get(++ai);
            int bs = b2.lines.get(++bi);
            int ae = a2.lines.get(ai + 1);
            int be = b2.lines.get(bi + 1);
            ae = RawCharUtil.trimTrailingWhitespace(a2.content, as, ae);
            be = RawCharUtil.trimTrailingWhitespace(b2.content, bs, be);
            while (as < ae && bs < be) {
                byte ac = a2.content[as++];
                byte bc = b2.content[bs++];
                if (RawCharUtil.isWhitespace(ac) && RawCharUtil.isWhitespace(bc)) {
                    as = RawCharUtil.trimLeadingWhitespace(a2.content, as, ae);
                    bs = RawCharUtil.trimLeadingWhitespace(b2.content, bs, be);
                    continue;
                }
                if (ac == bc) continue;
                return false;
            }
            return as == ae && bs == be;
        }

        @Override
        protected int hashRegion(byte[] raw, int ptr, int end2) {
            int hash = 5381;
            end2 = RawCharUtil.trimTrailingWhitespace(raw, ptr, end2);
            while (ptr < end2) {
                int c2;
                if (RawCharUtil.isWhitespace((byte)(c2 = raw[ptr++]))) {
                    ptr = RawCharUtil.trimLeadingWhitespace(raw, ptr, end2);
                    c2 = 32;
                }
                hash = (hash << 5) + hash + (c2 & 0xFF);
            }
            return hash;
        }
    };

    @Override
    public int hash(RawText seq, int lno) {
        int begin = seq.lines.get(lno + 1);
        int end2 = seq.lines.get(lno + 2);
        return this.hashRegion(seq.content, begin, end2);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Edit reduceCommonStartEnd(RawText a, RawText b, Edit e) {
        if (e.beginA == e.endA || e.beginB == e.endB) {
            return e;
        }
        aRaw = a.content;
        bRaw = b.content;
        aPtr = a.lines.get(e.beginA + 1);
        bPtr = a.lines.get(e.beginB + 1);
        aEnd = a.lines.get(e.endA + 1);
        bEnd = b.lines.get(e.endB + 1);
        if (aPtr >= 0 && bPtr >= 0 && aEnd <= aRaw.length && bEnd <= bRaw.length) ** GOTO lbl13
        throw new ArrayIndexOutOfBoundsException();
lbl-1000:
        // 1 sources

        {
            ++aPtr;
            ++bPtr;
lbl13:
            // 2 sources

            ** while (aPtr < aEnd && bPtr < bEnd && aRaw[aPtr] == bRaw[bPtr])
        }
lbl14:
        // 2 sources

        while (aPtr < aEnd && bPtr < bEnd && aRaw[aEnd - 1] == bRaw[bEnd - 1]) {
            --aEnd;
            --bEnd;
        }
        e.beginA = RawTextComparator.findForwardLine(a.lines, e.beginA, aPtr);
        e.beginB = RawTextComparator.findForwardLine(b.lines, e.beginB, bPtr);
        e.endA = RawTextComparator.findReverseLine(a.lines, e.endA, aEnd);
        v0 = partialA = aEnd < a.lines.get(e.endA + 1);
        if (partialA) {
            bEnd += a.lines.get(e.endA + 1) - aEnd;
        }
        e.endB = RawTextComparator.findReverseLine(b.lines, e.endB, bEnd);
        if (!partialA && bEnd < b.lines.get(e.endB + 1)) {
            ++e.endA;
        }
        return super.reduceCommonStartEnd(a, b, e);
    }

    private static int findForwardLine(IntList lines, int idx, int ptr) {
        int end2 = lines.size() - 2;
        while (idx < end2 && lines.get(idx + 2) < ptr) {
            ++idx;
        }
        return idx;
    }

    private static int findReverseLine(IntList lines, int idx, int ptr) {
        while (idx > 0 && ptr <= lines.get(idx)) {
            --idx;
        }
        return idx;
    }

    protected abstract int hashRegion(byte[] var1, int var2, int var3);
}

