/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.dircache;

import java.io.IOException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.errors.DirCacheNameConflictException;
import org.eclipse.jgit.util.Paths;

abstract class BaseDirCacheEditor {
    protected DirCache cache;
    protected DirCacheEntry[] entries;
    protected int entryCnt;

    protected BaseDirCacheEditor(DirCache dc, int ecnt) {
        this.cache = dc;
        this.entries = new DirCacheEntry[ecnt];
    }

    public DirCache getDirCache() {
        return this.cache;
    }

    protected void fastAdd(DirCacheEntry newEntry) {
        if (this.entries.length == this.entryCnt) {
            DirCacheEntry[] n = new DirCacheEntry[(this.entryCnt + 16) * 3 / 2];
            System.arraycopy(this.entries, 0, n, 0, this.entryCnt);
            this.entries = n;
        }
        this.entries[this.entryCnt++] = newEntry;
    }

    protected void fastKeep(int pos, int cnt) {
        if (this.entryCnt + cnt > this.entries.length) {
            int m1 = (this.entryCnt + 16) * 3 / 2;
            int m22 = this.entryCnt + cnt;
            DirCacheEntry[] n = new DirCacheEntry[Math.max(m1, m22)];
            System.arraycopy(this.entries, 0, n, 0, this.entryCnt);
            this.entries = n;
        }
        this.cache.toArray(pos, this.entries, this.entryCnt, cnt);
        this.entryCnt += cnt;
    }

    public abstract void finish();

    protected void replace() {
        this.checkNameConflicts();
        if (this.entryCnt < this.entries.length / 2) {
            DirCacheEntry[] n = new DirCacheEntry[this.entryCnt];
            System.arraycopy(this.entries, 0, n, 0, this.entryCnt);
            this.entries = n;
        }
        this.cache.replace(this.entries, this.entryCnt);
    }

    private void checkNameConflicts() {
        int end2 = this.entryCnt - 1;
        int eIdx = 0;
        while (eIdx < end2) {
            DirCacheEntry e2 = this.entries[eIdx];
            if (e2.getStage() == 0) {
                byte[] ePath = e2.path;
                int prefixLen = BaseDirCacheEditor.lastSlash(ePath) + 1;
                int nIdx = eIdx + 1;
                while (nIdx < this.entryCnt) {
                    DirCacheEntry n = this.entries[nIdx];
                    if (n.getStage() == 0) {
                        int m4;
                        int s2;
                        int cmp;
                        byte[] nPath = n.path;
                        if (!BaseDirCacheEditor.startsWith(ePath, nPath, prefixLen) || (cmp = Paths.compareSameName(ePath, prefixLen, ePath.length, nPath, prefixLen, s2, m4 = (s2 = BaseDirCacheEditor.nextSlash(nPath, prefixLen)) < nPath.length ? 16384 : n.getRawMode())) < 0) break;
                        if (cmp == 0) {
                            throw new DirCacheNameConflictException(e2.getPathString(), n.getPathString());
                        }
                    }
                    ++nIdx;
                }
            }
            ++eIdx;
        }
    }

    private static int lastSlash(byte[] path2) {
        int i2 = path2.length - 1;
        while (i2 >= 0) {
            if (path2[i2] == 47) {
                return i2;
            }
            --i2;
        }
        return -1;
    }

    private static int nextSlash(byte[] b2, int p) {
        int n = b2.length;
        while (p < n) {
            if (b2[p] == 47) {
                return p;
            }
            ++p;
        }
        return n;
    }

    private static boolean startsWith(byte[] a2, byte[] b2, int n) {
        if (b2.length < n) {
            return false;
        }
        --n;
        while (n >= 0) {
            if (a2[n] != b2[n]) {
                return false;
            }
            --n;
        }
        return true;
    }

    public boolean commit() throws IOException {
        this.finish();
        this.cache.write();
        return this.cache.commit();
    }
}

