/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.dircache;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.StandardCopyOption;
import java.text.MessageFormat;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.FileModeCache;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.WorkingTreeOptions;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.RawParseUtils;

public class Checkout {
    private final FileModeCache cache;
    private final WorkingTreeOptions options;
    private boolean recursiveDelete;

    public Checkout(@NonNull Repository repo) {
        this(repo, null);
    }

    public Checkout(@NonNull Repository repo, WorkingTreeOptions options2) {
        this.cache = new FileModeCache(repo);
        this.options = options2 != null ? options2 : repo.getConfig().get(WorkingTreeOptions.KEY);
    }

    public WorkingTreeOptions getWorkingTreeOptions() {
        return this.options;
    }

    public Checkout setRecursiveDeletion(boolean recursive) {
        this.recursiveDelete = recursive;
        return this;
    }

    public void safeCreateParentDirectory(String gitPath, File parentDir, boolean makeSpace) throws IOException {
        this.cache.safeCreateParentDirectory(gitPath, parentDir, makeSpace);
    }

    public void checkoutGitlink(DirCacheEntry entry, String gitPath) throws IOException {
        FS fs = this.cache.getRepository().getFS();
        File workingTree = this.cache.getRepository().getWorkTree();
        String path2 = gitPath != null ? gitPath : entry.getPathString();
        File gitlinkDir = new File(workingTree, path2);
        File parentDir = gitlinkDir.getParentFile();
        FileModeCache.CacheItem cachedParent = this.cache.safeCreateDirectory(path2, parentDir, false);
        FileUtils.mkdirs(gitlinkDir, true);
        cachedParent.insert(path2.substring(path2.lastIndexOf(47) + 1), FileMode.GITLINK);
        entry.setLastModified(fs.lastModifiedInstant(gitlinkDir));
    }

    public void checkout(DirCacheEntry entry, DirCacheCheckout.CheckoutMetadata metadata, ObjectReader reader2, String gitPath) throws IOException {
        if (metadata == null) {
            metadata = DirCacheCheckout.CheckoutMetadata.EMPTY;
        }
        FS fs = this.cache.getRepository().getFS();
        ObjectLoader ol = reader2.open(entry.getObjectId());
        String path2 = gitPath != null ? gitPath : entry.getPathString();
        File f2 = new File(this.cache.getRepository().getWorkTree(), path2);
        File parentDir = f2.getParentFile();
        FileModeCache.CacheItem cachedParent = this.cache.safeCreateDirectory(path2, parentDir, true);
        if (entry.getFileMode() == FileMode.SYMLINK && this.options.getSymLinks() == CoreConfig.SymLinks.TRUE) {
            byte[] bytes = ol.getBytes();
            String target = RawParseUtils.decode(bytes);
            if (this.recursiveDelete && Files.isDirectory(f2.toPath(), LinkOption.NOFOLLOW_LINKS)) {
                FileUtils.delete(f2, 1);
            }
            fs.createSymLink(f2, target);
            cachedParent.insert(f2.getName(), FileMode.SYMLINK);
            entry.setLength(bytes.length);
            entry.setLastModified(fs.lastModifiedInstant(f2));
            return;
        }
        String name = f2.getName();
        if (name.length() > 200) {
            name = name.substring(0, 200);
        }
        File tmpFile = File.createTempFile("._" + name, null, parentDir);
        DirCacheCheckout.getContent(this.cache.getRepository(), path2, metadata, ol, this.options, (OutputStream)new FileOutputStream(tmpFile));
        if (metadata.eolStreamType == CoreConfig.EolStreamType.DIRECT && metadata.smudgeFilterCommand == null) {
            entry.setLength(ol.getSize());
        } else {
            entry.setLength(tmpFile.length());
        }
        if (this.options.isFileMode() && fs.supportsExecute()) {
            if (FileMode.EXECUTABLE_FILE.equals(entry.getRawMode())) {
                if (!fs.canExecute(tmpFile)) {
                    fs.setExecute(tmpFile, true);
                }
            } else if (fs.canExecute(tmpFile)) {
                fs.setExecute(tmpFile, false);
            }
        }
        try {
            try {
                boolean isDir = Files.isDirectory(f2.toPath(), LinkOption.NOFOLLOW_LINKS);
                if (this.recursiveDelete && isDir) {
                    FileUtils.delete(f2, 1);
                }
                if (this.cache.getRepository().isWorkTreeCaseInsensitive() && !isDir) {
                    FileUtils.delete(f2, 4);
                }
                FileUtils.rename(tmpFile, f2, StandardCopyOption.ATOMIC_MOVE);
                cachedParent.remove(f2.getName());
            }
            catch (IOException e2) {
                throw new IOException(MessageFormat.format(JGitText.get().renameFileFailed, tmpFile.getPath(), f2.getPath()), e2);
            }
        }
        finally {
            if (tmpFile.exists()) {
                FileUtils.delete(tmpFile);
            }
        }
        entry.setLastModified(fs.lastModifiedInstant(f2));
    }
}

