/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.dircache;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jgit.dircache.BaseDirCacheEditor;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheTree;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.util.Paths;

public class DirCacheEditor
extends BaseDirCacheEditor {
    private static final Comparator<PathEdit> EDIT_CMP = (o1, o2) -> {
        byte[] a2 = o1.path;
        byte[] b2 = o2.path;
        return DirCache.cmp(a2, a2.length, b2, b2.length);
    };
    private final List<PathEdit> edits = new ArrayList<PathEdit>();
    private int editIdx;

    protected DirCacheEditor(DirCache dc, int ecnt) {
        super(dc, ecnt);
    }

    public void add(PathEdit edit) {
        this.edits.add(edit);
    }

    @Override
    public boolean commit() throws IOException {
        if (this.edits.isEmpty()) {
            this.cache.unlock();
            return true;
        }
        return super.commit();
    }

    @Override
    public void finish() {
        if (!this.edits.isEmpty()) {
            this.applyEdits();
            this.replace();
        }
    }

    private void applyEdits() {
        Collections.sort(this.edits, EDIT_CMP);
        this.editIdx = 0;
        int maxIdx = this.cache.getEntryCount();
        int lastIdx = 0;
        while (this.editIdx < this.edits.size()) {
            DirCacheEntry ent;
            int cnt;
            boolean missing;
            PathEdit e2 = this.edits.get(this.editIdx++);
            int eIdx = this.cache.findEntry(lastIdx, e2.path, e2.path.length);
            boolean bl = missing = eIdx < 0;
            if (eIdx < 0) {
                eIdx = -(eIdx + 1);
            }
            if ((cnt = Math.min(eIdx, maxIdx) - lastIdx) > 0) {
                this.fastKeep(lastIdx, cnt);
            }
            if (e2 instanceof DeletePath) {
                lastIdx = missing ? eIdx : this.cache.nextEntry(eIdx);
                continue;
            }
            if (e2 instanceof DeleteTree) {
                lastIdx = this.cache.nextEntry(e2.path, e2.path.length, eIdx);
                continue;
            }
            if (missing) {
                ent = new DirCacheEntry(e2.path);
                e2.apply(ent);
                if (ent.getRawMode() == 0) {
                    throw new IllegalArgumentException(MessageFormat.format(JGitText.get().fileModeNotSetForPath, ent.getPathString()));
                }
                lastIdx = e2.replace ? this.deleteOverlappingSubtree(ent, eIdx) : eIdx;
                this.fastAdd(ent);
                continue;
            }
            lastIdx = this.cache.nextEntry(eIdx);
            if (lastIdx > eIdx + 1) {
                DirCacheEntry[] tmp = new DirCacheEntry[lastIdx - eIdx];
                int n = 0;
                int i2 = eIdx;
                while (i2 < lastIdx) {
                    DirCacheEntry ent2 = this.cache.getEntry(i2);
                    e2.apply(ent2);
                    if (ent2.getStage() == 0) {
                        this.fastAdd(ent2);
                        n = 0;
                        break;
                    }
                    tmp[n++] = ent2;
                    ++i2;
                }
                i2 = 0;
                while (i2 < n) {
                    this.fastAdd(tmp[i2]);
                    ++i2;
                }
                continue;
            }
            ent = this.cache.getEntry(eIdx);
            e2.apply(ent);
            this.fastAdd(ent);
        }
        int cnt = maxIdx - lastIdx;
        if (cnt > 0) {
            this.fastKeep(lastIdx, cnt);
        }
    }

    /*
     * Unable to fully structure code
     */
    private int deleteOverlappingSubtree(DirCacheEntry ent, int eIdx) {
        entPath = ent.path;
        entLen = entPath.length;
        p = DirCacheEditor.pdir(entPath, entLen);
        while (p > 0) {
            i = this.findEntry(entPath, p);
            if (i >= 0) {
                n = --this.entryCnt - i;
                System.arraycopy(this.entries, i + 1, this.entries, i, n);
                break;
            }
            if ((i = -(i + 1)) < this.entryCnt && DirCacheEditor.inDir(this.entries[i], entPath, p)) break;
            p = DirCacheEditor.pdir(entPath, p);
        }
        maxEnt = this.cache.getEntryCount();
        if (eIdx >= maxEnt) {
            return maxEnt;
        }
        next = this.cache.getEntry(eIdx);
        if (Paths.compare(next.path, 0, next.path.length, 0, entPath, 0, entLen, 16384) >= 0) ** GOTO lbl21
        this.insertEdit(new DeleteTree(entPath));
        return eIdx;
lbl-1000:
        // 1 sources

        {
            ++eIdx;
lbl21:
            // 2 sources

            ** while (eIdx < maxEnt && DirCacheEditor.inDir((DirCacheEntry)this.cache.getEntry((int)eIdx), (byte[])entPath, (int)entLen))
        }
lbl22:
        // 1 sources

        return eIdx;
    }

    private int findEntry(byte[] p, int pLen) {
        int low = 0;
        int high = this.entryCnt;
        while (low < high) {
            int mid = low + high >>> 1;
            int cmp = DirCache.cmp(p, pLen, this.entries[mid]);
            if (cmp < 0) {
                high = mid;
                continue;
            }
            if (cmp == 0) {
                while (mid > 0 && DirCache.cmp(p, pLen, this.entries[mid - 1]) == 0) {
                    --mid;
                }
                return mid;
            }
            low = mid + 1;
        }
        return -(low + 1);
    }

    private void insertEdit(DeleteTree d2) {
        int i2 = this.editIdx;
        while (i2 < this.edits.size()) {
            int cmp = EDIT_CMP.compare(d2, this.edits.get(i2));
            if (cmp < 0) {
                this.edits.add(i2, d2);
                return;
            }
            if (cmp == 0) {
                return;
            }
            ++i2;
        }
        this.edits.add(d2);
    }

    private static boolean inDir(DirCacheEntry e2, byte[] path2, int pLen) {
        return e2.path.length > pLen && e2.path[pLen] == 47 && DirCacheTree.peq(path2, e2.path, pLen);
    }

    private static int pdir(byte[] path2, int e2) {
        --e2;
        while (e2 > 0) {
            if (path2[e2] == 47) {
                return e2;
            }
            --e2;
        }
        return 0;
    }

    public static final class DeletePath
    extends PathEdit {
        public DeletePath(String entryPath) {
            super(entryPath);
        }

        public DeletePath(DirCacheEntry ent) {
            super(ent);
        }

        @Override
        public void apply(DirCacheEntry ent) {
            throw new UnsupportedOperationException(JGitText.get().noApplyInDelete);
        }
    }

    public static final class DeleteTree
    extends PathEdit {
        public DeleteTree(String entryPath) {
            super((String)(entryPath.isEmpty() || entryPath.charAt(entryPath.length() - 1) == '/' ? entryPath : entryPath + "/"));
        }

        DeleteTree(byte[] path2) {
            super(DeleteTree.appendSlash(path2));
        }

        private static byte[] appendSlash(byte[] path2) {
            int n = path2.length;
            if (n > 0 && path2[n - 1] != 47) {
                byte[] r = new byte[n + 1];
                System.arraycopy(path2, 0, r, 0, n);
                r[n] = 47;
                return r;
            }
            return path2;
        }

        @Override
        public void apply(DirCacheEntry ent) {
            throw new UnsupportedOperationException(JGitText.get().noApplyInDelete);
        }
    }

    public static abstract class PathEdit {
        final byte[] path;
        boolean replace = true;

        public PathEdit(String entryPath) {
            this.path = Constants.encode(entryPath);
        }

        PathEdit(byte[] path2) {
            this.path = path2;
        }

        public PathEdit(DirCacheEntry ent) {
            this.path = ent.path;
        }

        public PathEdit setReplace(boolean ok) {
            this.replace = ok;
            return this;
        }

        public abstract void apply(DirCacheEntry var1);

        public String toString() {
            String p = DirCacheEntry.toString(this.path);
            return this.getClass().getSimpleName() + "[" + p + "]";
        }
    }
}

