/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.dircache;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.errors.UnmergedPathException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.TreeFormatter;
import org.eclipse.jgit.util.MutableInteger;
import org.eclipse.jgit.util.RawParseUtils;

public class DirCacheTree {
    private static final byte[] NO_NAME = new byte[0];
    private static final DirCacheTree[] NO_CHILDREN = new DirCacheTree[0];
    private static final Comparator<DirCacheTree> TREE_CMP = (o1, o2) -> {
        byte[] a2 = o1.encodedName;
        byte[] b2 = o2.encodedName;
        int aLen = a2.length;
        int bLen = b2.length;
        int cPos = 0;
        while (cPos < aLen && cPos < bLen) {
            int cmp = (a2[cPos] & 0xFF) - (b2[cPos] & 0xFF);
            if (cmp != 0) {
                return cmp;
            }
            ++cPos;
        }
        if (aLen == bLen) {
            return 0;
        }
        if (aLen < bLen) {
            return 47 - (b2[cPos] & 0xFF);
        }
        return (a2[cPos] & 0xFF) - 47;
    };
    private DirCacheTree parent;
    byte[] encodedName;
    private int entrySpan;
    private ObjectId id;
    private DirCacheTree[] children;
    private int childCnt;

    DirCacheTree() {
        this.encodedName = NO_NAME;
        this.children = NO_CHILDREN;
        this.childCnt = 0;
        this.entrySpan = -1;
    }

    private DirCacheTree(DirCacheTree myParent, byte[] path2, int pathOff, int pathLen) {
        this.parent = myParent;
        this.encodedName = new byte[pathLen];
        System.arraycopy(path2, pathOff, this.encodedName, 0, pathLen);
        this.children = NO_CHILDREN;
        this.childCnt = 0;
        this.entrySpan = -1;
    }

    DirCacheTree(byte[] in, MutableInteger off, DirCacheTree myParent) {
        this.parent = myParent;
        int ptr = RawParseUtils.next(in, off.value, '\u0000');
        int nameLen = ptr - off.value - 1;
        if (nameLen > 0) {
            this.encodedName = new byte[nameLen];
            System.arraycopy(in, off.value, this.encodedName, 0, nameLen);
        } else {
            this.encodedName = NO_NAME;
        }
        this.entrySpan = RawParseUtils.parseBase10(in, ptr, off);
        int subcnt = RawParseUtils.parseBase10(in, off.value, off);
        off.value = RawParseUtils.next(in, off.value, '\n');
        if (this.entrySpan >= 0) {
            this.id = ObjectId.fromRaw(in, off.value);
            off.value += 20;
        }
        if (subcnt > 0) {
            boolean alreadySorted = true;
            this.children = new DirCacheTree[subcnt];
            int i2 = 0;
            while (i2 < subcnt) {
                this.children[i2] = new DirCacheTree(in, off, this);
                if (alreadySorted && i2 > 0 && TREE_CMP.compare(this.children[i2 - 1], this.children[i2]) > 0) {
                    alreadySorted = false;
                }
                ++i2;
            }
            if (!alreadySorted) {
                Arrays.sort(this.children, 0, subcnt, TREE_CMP);
            }
        } else {
            this.children = NO_CHILDREN;
        }
        this.childCnt = subcnt;
    }

    void write(byte[] tmp, OutputStream os) throws IOException {
        int ptr = tmp.length;
        tmp[--ptr] = 10;
        ptr = RawParseUtils.formatBase10(tmp, ptr, this.childCnt);
        tmp[--ptr] = 32;
        ptr = RawParseUtils.formatBase10(tmp, ptr, this.isValid() ? this.entrySpan : -1);
        tmp[--ptr] = 0;
        os.write(this.encodedName);
        os.write(tmp, ptr, tmp.length - ptr);
        if (this.isValid()) {
            this.id.copyRawTo(tmp, 0);
            os.write(tmp, 0, 20);
        }
        int i2 = 0;
        while (i2 < this.childCnt) {
            this.children[i2].write(tmp, os);
            ++i2;
        }
    }

    public boolean isValid() {
        return this.id != null;
    }

    public int getEntrySpan() {
        return this.entrySpan;
    }

    public int getChildCount() {
        return this.childCnt;
    }

    public DirCacheTree getChild(int i2) {
        return this.children[i2];
    }

    public ObjectId getObjectId() {
        return this.id;
    }

    public String getNameString() {
        ByteBuffer bb = ByteBuffer.wrap(this.encodedName);
        return StandardCharsets.UTF_8.decode(bb).toString();
    }

    public String getPathString() {
        StringBuilder r = new StringBuilder();
        this.appendName(r);
        return r.toString();
    }

    ObjectId writeTree(DirCacheEntry[] cache2, int cIdx, int pathOffset, ObjectInserter ow) throws UnmergedPathException, IOException {
        if (this.id == null) {
            int endIdx = cIdx + this.entrySpan;
            TreeFormatter fmt = new TreeFormatter(this.computeSize(cache2, cIdx, pathOffset, ow));
            int childIdx = 0;
            int entryIdx = cIdx;
            while (entryIdx < endIdx) {
                DirCacheTree st;
                DirCacheEntry e2 = cache2[entryIdx];
                byte[] ep = e2.path;
                if (childIdx < this.childCnt && (st = this.children[childIdx]).contains(ep, pathOffset, ep.length)) {
                    fmt.append(st.encodedName, FileMode.TREE, (AnyObjectId)st.id);
                    entryIdx += st.entrySpan;
                    ++childIdx;
                    continue;
                }
                fmt.append(ep, pathOffset, ep.length - pathOffset, e2.getFileMode(), e2.idBuffer(), e2.idOffset());
                ++entryIdx;
            }
            this.id = ow.insert(fmt);
        }
        return this.id;
    }

    private int computeSize(DirCacheEntry[] cache2, int cIdx, int pathOffset, ObjectInserter ow) throws UnmergedPathException, IOException {
        int endIdx = cIdx + this.entrySpan;
        int childIdx = 0;
        int entryIdx = cIdx;
        int size2 = 0;
        while (entryIdx < endIdx) {
            DirCacheTree st;
            DirCacheEntry e2 = cache2[entryIdx];
            if (e2.getStage() != 0) {
                throw new UnmergedPathException(e2);
            }
            byte[] ep = e2.path;
            if (childIdx < this.childCnt && (st = this.children[childIdx]).contains(ep, pathOffset, ep.length)) {
                int stOffset = pathOffset + st.nameLength() + 1;
                st.writeTree(cache2, entryIdx, stOffset, ow);
                size2 += TreeFormatter.entrySize(FileMode.TREE, st.nameLength());
                entryIdx += st.entrySpan;
                ++childIdx;
                continue;
            }
            size2 += TreeFormatter.entrySize(e2.getFileMode(), ep.length - pathOffset);
            ++entryIdx;
        }
        return size2;
    }

    private void appendName(StringBuilder r) {
        if (this.parent != null) {
            this.parent.appendName(r);
            r.append(this.getNameString());
            r.append('/');
        } else if (this.nameLength() > 0) {
            r.append(this.getNameString());
            r.append('/');
        }
    }

    final int nameLength() {
        return this.encodedName.length;
    }

    final boolean contains(byte[] a2, int aOff, int aLen) {
        byte[] e2 = this.encodedName;
        int eLen = e2.length;
        int eOff = 0;
        while (eOff < eLen && aOff < aLen) {
            if (e2[eOff] != a2[aOff]) {
                return false;
            }
            ++eOff;
            ++aOff;
        }
        if (aOff >= aLen) {
            return false;
        }
        return a2[aOff] == 47;
    }

    void validate(DirCacheEntry[] cache2, int cCnt, int cIdx, int pathOff) {
        if (this.entrySpan >= 0 && cIdx + this.entrySpan <= cCnt) {
            return;
        }
        this.entrySpan = 0;
        if (cCnt == 0) {
            return;
        }
        byte[] firstPath = cache2[cIdx].path;
        int stIdx = 0;
        while (cIdx < cCnt) {
            byte[] currPath = cache2[cIdx].path;
            if (pathOff > 0 && !DirCacheTree.peq(firstPath, currPath, pathOff)) break;
            DirCacheTree st = stIdx < this.childCnt ? this.children[stIdx] : null;
            int cc = DirCacheTree.namecmp(currPath, pathOff, st);
            if (cc > 0) {
                this.removeChild(stIdx);
                continue;
            }
            if (cc < 0) {
                int p = DirCacheTree.slash(currPath, pathOff);
                if (p < 0) {
                    ++cIdx;
                    ++this.entrySpan;
                    continue;
                }
                st = new DirCacheTree(this, currPath, pathOff, p - pathOff);
                this.insertChild(stIdx, st);
            }
            assert (st != null);
            st.validate(cache2, cCnt, cIdx, pathOff + st.nameLength() + 1);
            cIdx += st.entrySpan;
            this.entrySpan += st.entrySpan;
            ++stIdx;
        }
        while (stIdx < this.childCnt) {
            this.removeChild(this.childCnt - 1);
        }
    }

    private void insertChild(int stIdx, DirCacheTree st) {
        DirCacheTree[] c2 = this.children;
        if (this.childCnt + 1 <= c2.length) {
            if (stIdx < this.childCnt) {
                System.arraycopy(c2, stIdx, c2, stIdx + 1, this.childCnt - stIdx);
            }
            c2[stIdx] = st;
            ++this.childCnt;
            return;
        }
        int n = c2.length;
        DirCacheTree[] a2 = new DirCacheTree[n + 1];
        if (stIdx > 0) {
            System.arraycopy(c2, 0, a2, 0, stIdx);
        }
        a2[stIdx] = st;
        if (stIdx < n) {
            System.arraycopy(c2, stIdx, a2, stIdx + 1, n - stIdx);
        }
        this.children = a2;
        ++this.childCnt;
    }

    private void removeChild(int stIdx) {
        int n;
        if (stIdx < (n = --this.childCnt)) {
            System.arraycopy(this.children, stIdx + 1, this.children, stIdx, n - stIdx);
        }
        this.children[n] = null;
    }

    static boolean peq(byte[] a2, byte[] b2, int aLen) {
        if (b2.length < aLen) {
            return false;
        }
        --aLen;
        while (aLen >= 0) {
            if (a2[aLen] != b2[aLen]) {
                return false;
            }
            --aLen;
        }
        return true;
    }

    private static int namecmp(byte[] a2, int aPos, DirCacheTree ct) {
        if (ct == null) {
            return -1;
        }
        byte[] b2 = ct.encodedName;
        int aLen = a2.length;
        int bLen = b2.length;
        int bPos = 0;
        while (aPos < aLen && bPos < bLen) {
            int cmp = (a2[aPos] & 0xFF) - (b2[bPos] & 0xFF);
            if (cmp != 0) {
                return cmp;
            }
            ++aPos;
            ++bPos;
        }
        if (bPos == bLen) {
            return a2[aPos] == 47 ? 0 : -1;
        }
        return aLen - bLen;
    }

    private static int slash(byte[] a2, int aPos) {
        int aLen = a2.length;
        while (aPos < aLen) {
            if (a2[aPos] == 47) {
                return aPos;
            }
            ++aPos;
        }
        return -1;
    }

    public String toString() {
        return this.getNameString();
    }
}

