/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.errors;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jgit.internal.JGitText;

public class CheckoutConflictException
extends IOException {
    private static final long serialVersionUID = 1L;
    private final String[] conflicting;

    public CheckoutConflictException(String file2) {
        super(MessageFormat.format(JGitText.get().checkoutConflictWithFile, file2));
        this.conflicting = new String[]{file2};
    }

    public CheckoutConflictException(String[] files2) {
        super(MessageFormat.format(JGitText.get().checkoutConflictWithFiles, CheckoutConflictException.buildList(files2)));
        this.conflicting = files2;
    }

    public String[] getConflictingFiles() {
        return this.conflicting;
    }

    private static String buildList(String[] files2) {
        StringBuilder builder = new StringBuilder();
        String[] stringArray = files2;
        int n = files2.length;
        int n2 = 0;
        while (n2 < n) {
            String f2 = stringArray[n2];
            builder.append("\n");
            builder.append(f2);
            ++n2;
        }
        return builder.toString();
    }
}

