/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.fnmatch;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.errors.InvalidPatternException;
import org.eclipse.jgit.fnmatch.AbstractHead;
import org.eclipse.jgit.internal.JGitText;

final class GroupHead
extends AbstractHead {
    private final List<CharacterPattern> characterClasses = new ArrayList<CharacterPattern>();
    private static final Pattern REGEX_PATTERN = Pattern.compile("([^-][-][^-]|\\[[.:=].*?[.:=]\\])");
    private final boolean inverse;

    GroupHead(String pattern2, String wholePattern) throws InvalidPatternException {
        super(false);
        this.inverse = pattern2.startsWith("!");
        if (this.inverse) {
            pattern2 = pattern2.substring(1);
        }
        Matcher matcher = REGEX_PATTERN.matcher(pattern2);
        while (matcher.find()) {
            String characterClass = matcher.group(0);
            if (characterClass.length() == 3 && characterClass.charAt(1) == '-') {
                char start2 = characterClass.charAt(0);
                char end2 = characterClass.charAt(2);
                this.characterClasses.add(new CharacterRange(start2, end2));
            } else if (characterClass.equals("[:alnum:]")) {
                this.characterClasses.add(LetterPattern.INSTANCE);
                this.characterClasses.add(DigitPattern.INSTANCE);
            } else if (characterClass.equals("[:alpha:]")) {
                this.characterClasses.add(LetterPattern.INSTANCE);
            } else if (characterClass.equals("[:blank:]")) {
                this.characterClasses.add(new OneCharacterPattern(' '));
                this.characterClasses.add(new OneCharacterPattern('\t'));
            } else if (characterClass.equals("[:cntrl:]")) {
                this.characterClasses.add(new CharacterRange('\u0000', '\u001f'));
                this.characterClasses.add(new OneCharacterPattern('\u007f'));
            } else if (characterClass.equals("[:digit:]")) {
                this.characterClasses.add(DigitPattern.INSTANCE);
            } else if (characterClass.equals("[:graph:]")) {
                this.characterClasses.add(new CharacterRange('!', '~'));
                this.characterClasses.add(LetterPattern.INSTANCE);
                this.characterClasses.add(DigitPattern.INSTANCE);
            } else if (characterClass.equals("[:lower:]")) {
                this.characterClasses.add(LowerPattern.INSTANCE);
            } else if (characterClass.equals("[:print:]")) {
                this.characterClasses.add(new CharacterRange(' ', '~'));
                this.characterClasses.add(LetterPattern.INSTANCE);
                this.characterClasses.add(DigitPattern.INSTANCE);
            } else if (characterClass.equals("[:punct:]")) {
                this.characterClasses.add(PunctPattern.INSTANCE);
            } else if (characterClass.equals("[:space:]")) {
                this.characterClasses.add(WhitespacePattern.INSTANCE);
            } else if (characterClass.equals("[:upper:]")) {
                this.characterClasses.add(UpperPattern.INSTANCE);
            } else if (characterClass.equals("[:xdigit:]")) {
                this.characterClasses.add(new CharacterRange('0', '9'));
                this.characterClasses.add(new CharacterRange('a', 'f'));
                this.characterClasses.add(new CharacterRange('A', 'F'));
            } else if (characterClass.equals("[:word:]")) {
                this.characterClasses.add(new OneCharacterPattern('_'));
                this.characterClasses.add(LetterPattern.INSTANCE);
                this.characterClasses.add(DigitPattern.INSTANCE);
            } else {
                String message = MessageFormat.format(JGitText.get().characterClassIsNotSupported, characterClass);
                throw new InvalidPatternException(message, wholePattern);
            }
            pattern2 = matcher.replaceFirst("");
            matcher.reset(pattern2);
        }
        int i2 = 0;
        while (i2 < pattern2.length()) {
            char c2 = pattern2.charAt(i2);
            this.characterClasses.add(new OneCharacterPattern(c2));
            ++i2;
        }
    }

    @Override
    protected final boolean matches(char c2) {
        for (CharacterPattern pattern2 : this.characterClasses) {
            if (!pattern2.matches(c2)) continue;
            return !this.inverse;
        }
        return this.inverse;
    }

    private static interface CharacterPattern {
        public boolean matches(char var1);
    }

    private static final class CharacterRange
    implements CharacterPattern {
        private final char start;
        private final char end;

        CharacterRange(char start2, char end2) {
            this.start = start2;
            this.end = end2;
        }

        @Override
        public final boolean matches(char c2) {
            return this.start <= c2 && c2 <= this.end;
        }
    }

    private static final class DigitPattern
    implements CharacterPattern {
        static final DigitPattern INSTANCE = new DigitPattern();

        private DigitPattern() {
        }

        @Override
        public final boolean matches(char c2) {
            return Character.isDigit(c2);
        }
    }

    private static final class LetterPattern
    implements CharacterPattern {
        static final LetterPattern INSTANCE = new LetterPattern();

        private LetterPattern() {
        }

        @Override
        public final boolean matches(char c2) {
            return Character.isLetter(c2);
        }
    }

    private static final class LowerPattern
    implements CharacterPattern {
        static final LowerPattern INSTANCE = new LowerPattern();

        private LowerPattern() {
        }

        @Override
        public final boolean matches(char c2) {
            return Character.isLowerCase(c2);
        }
    }

    private static final class OneCharacterPattern
    implements CharacterPattern {
        private char expectedCharacter;

        OneCharacterPattern(char c2) {
            this.expectedCharacter = c2;
        }

        @Override
        public final boolean matches(char c2) {
            return this.expectedCharacter == c2;
        }
    }

    private static final class PunctPattern
    implements CharacterPattern {
        static final PunctPattern INSTANCE = new PunctPattern();
        private static String punctCharacters = "-!\"#$%&'()*+,./:;<=>?@[\\]_`{|}~";

        private PunctPattern() {
        }

        @Override
        public boolean matches(char c2) {
            return punctCharacters.indexOf(c2) != -1;
        }
    }

    private static final class UpperPattern
    implements CharacterPattern {
        static final UpperPattern INSTANCE = new UpperPattern();

        private UpperPattern() {
        }

        @Override
        public final boolean matches(char c2) {
            return Character.isUpperCase(c2);
        }
    }

    private static final class WhitespacePattern
    implements CharacterPattern {
        static final WhitespacePattern INSTANCE = new WhitespacePattern();

        private WhitespacePattern() {
        }

        @Override
        public final boolean matches(char c2) {
            return Character.isWhitespace(c2);
        }
    }
}

