/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.ignore;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.InvalidPatternException;
import org.eclipse.jgit.ignore.FastIgnoreRule;
import org.eclipse.jgit.internal.JGitText;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IgnoreNode {
    private static final Logger LOG = LoggerFactory.getLogger(IgnoreNode.class);
    private final List<FastIgnoreRule> rules;

    public IgnoreNode() {
        this(new ArrayList<FastIgnoreRule>());
    }

    public IgnoreNode(List<FastIgnoreRule> rules) {
        this.rules = rules;
    }

    public void parse(InputStream in) throws IOException {
        this.parse(null, in);
    }

    public void parse(String sourceName, InputStream in) throws IOException {
        String txt;
        BufferedReader br = IgnoreNode.asReader(in);
        int lineNumber = 1;
        while ((txt = br.readLine()) != null) {
            if (txt.length() > 0 && !txt.startsWith("#") && !txt.equals("/")) {
                FastIgnoreRule rule = new FastIgnoreRule();
                try {
                    rule.parse(txt);
                }
                catch (InvalidPatternException e2) {
                    if (sourceName != null) {
                        LOG.error(MessageFormat.format(JGitText.get().badIgnorePatternFull, sourceName, Integer.toString(lineNumber), e2.getPattern(), e2.getLocalizedMessage()), e2);
                    }
                    LOG.error(MessageFormat.format(JGitText.get().badIgnorePattern, e2.getPattern()), e2);
                }
                if (!rule.isEmpty()) {
                    this.rules.add(rule);
                }
            }
            ++lineNumber;
        }
    }

    private static BufferedReader asReader(InputStream in) {
        return new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
    }

    public List<FastIgnoreRule> getRules() {
        return Collections.unmodifiableList(this.rules);
    }

    public MatchResult isIgnored(String entryPath, boolean isDirectory) {
        Boolean result2 = this.checkIgnored(entryPath, isDirectory);
        if (result2 == null) {
            return MatchResult.CHECK_PARENT;
        }
        return result2 != false ? MatchResult.IGNORED : MatchResult.NOT_IGNORED;
    }

    @Nullable
    public Boolean checkIgnored(String entryPath, boolean isDirectory) {
        int i2 = this.rules.size() - 1;
        while (i2 > -1) {
            FastIgnoreRule rule = this.rules.get(i2);
            if (rule.isMatch(entryPath, isDirectory, true)) {
                return rule.getResult();
            }
            --i2;
        }
        return null;
    }

    public String toString() {
        return this.rules.toString();
    }

    public static enum MatchResult {
        NOT_IGNORED,
        IGNORED,
        CHECK_PARENT,
        CHECK_PARENT_NEGATE_FIRST_MATCH;

    }
}

