/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.ignore.internal;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jgit.errors.InvalidPatternException;
import org.eclipse.jgit.internal.JGitText;

public class Strings {
    static final List<String> POSIX_CHAR_CLASSES = Arrays.asList("alnum", "alpha", "blank", "cntrl", "digit", "graph", "lower", "print", "punct", "space", "upper", "xdigit", "word");
    private static final String DL = "\\p{javaDigit}\\p{javaLetter}";
    static final List<String> JAVA_CHAR_CLASSES = Arrays.asList("\\p{Alnum}", "\\p{javaLetter}", "\\p{Blank}", "\\p{Cntrl}", "\\p{javaDigit}", "[\\p{Graph}\\p{javaDigit}\\p{javaLetter}]", "\\p{Ll}", "[\\p{Print}\\p{javaDigit}\\p{javaLetter}]", "\\p{Punct}", "\\p{Space}", "\\p{Lu}", "\\p{XDigit}", "[\\p{javaDigit}\\p{javaLetter}_]");
    static final Pattern UNSUPPORTED = Pattern.compile("\\[\\[[.=]\\w+[.=]\\]\\]");

    static char getPathSeparator(Character pathSeparator) {
        return pathSeparator == null ? (char)'/' : (char)pathSeparator.charValue();
    }

    public static String stripTrailing(String pattern2, char c2) {
        int i2 = pattern2.length() - 1;
        while (i2 >= 0) {
            char charAt = pattern2.charAt(i2);
            if (charAt != c2) {
                if (i2 == pattern2.length() - 1) {
                    return pattern2;
                }
                return pattern2.substring(0, i2 + 1);
            }
            --i2;
        }
        return "";
    }

    public static String stripTrailingWhitespace(String pattern2) {
        int i2 = pattern2.length() - 1;
        while (i2 >= 0) {
            char charAt = pattern2.charAt(i2);
            if (!Character.isWhitespace(charAt)) {
                if (i2 == pattern2.length() - 1) {
                    return pattern2;
                }
                return pattern2.substring(0, i2 + 1);
            }
            --i2;
        }
        return "";
    }

    public static boolean isDirectoryPattern(String pattern2) {
        int i2 = pattern2.length() - 1;
        while (i2 >= 0) {
            char charAt = pattern2.charAt(i2);
            if (!Character.isWhitespace(charAt)) {
                return charAt == '/';
            }
            --i2;
        }
        return false;
    }

    static int count(String s2, char c2, boolean ignoreFirstLast) {
        int start2 = 0;
        int count2 = 0;
        int length = s2.length();
        while (start2 < length) {
            if ((start2 = s2.indexOf(c2, start2)) == -1) break;
            if (!ignoreFirstLast || start2 != 0 && start2 != length - 1) {
                ++count2;
            }
            ++start2;
        }
        return count2;
    }

    public static List<String> split(String pattern2, char slash) {
        int count2 = Strings.count(pattern2, slash, true);
        if (count2 < 1) {
            throw new IllegalStateException("Pattern must have at least two segments: " + pattern2);
        }
        ArrayList<String> segments2 = new ArrayList<String>(count2);
        int right = 0;
        while (true) {
            int left = ++right;
            if ((right = pattern2.indexOf(slash, right)) == -1) {
                if (left >= pattern2.length()) break;
                segments2.add(pattern2.substring(left));
                break;
            }
            if (right - left <= 0) continue;
            if (left == 1) {
                segments2.add(pattern2.substring(left - 1, right));
                continue;
            }
            if (right == pattern2.length() - 1) {
                segments2.add(pattern2.substring(left, right + 1));
                continue;
            }
            segments2.add(pattern2.substring(left, right));
        }
        return segments2;
    }

    static boolean isWildCard(String pattern2) {
        return pattern2.indexOf(42) != -1 || Strings.isComplexWildcard(pattern2);
    }

    private static boolean isComplexWildcard(String pattern2) {
        int idx1 = pattern2.indexOf(91);
        if (idx1 != -1) {
            return true;
        }
        if (pattern2.indexOf(63) != -1) {
            return true;
        }
        int backSlash = pattern2.indexOf(92);
        if (backSlash >= 0) {
            int nextIdx = backSlash + 1;
            if (pattern2.length() == nextIdx) {
                return false;
            }
            char nextChar = pattern2.charAt(nextIdx);
            return Strings.escapedByBackslash(nextChar);
        }
        return false;
    }

    private static boolean escapedByBackslash(char nextChar) {
        return nextChar == '?' || nextChar == '*' || nextChar == '[';
    }

    static PatternState checkWildCards(String pattern2) {
        if (Strings.isComplexWildcard(pattern2)) {
            return PatternState.COMPLEX;
        }
        int startIdx = pattern2.indexOf(42);
        if (startIdx < 0) {
            return PatternState.NONE;
        }
        if (startIdx == pattern2.length() - 1) {
            return PatternState.TRAILING_ASTERISK_ONLY;
        }
        if (pattern2.lastIndexOf(42) == 0) {
            return PatternState.LEADING_ASTERISK_ONLY;
        }
        return PatternState.COMPLEX;
    }

    static Pattern convertGlob(String pattern2) throws InvalidPatternException {
        if (UNSUPPORTED.matcher(pattern2).find()) {
            throw new InvalidPatternException("Collating symbols [[.a.]] or equivalence class expressions [[=a=]] are not supported", pattern2);
        }
        StringBuilder sb = new StringBuilder(pattern2.length());
        int in_brackets = 0;
        boolean seenEscape = false;
        boolean ignoreLastBracket = false;
        boolean in_char_class = false;
        char[] charClass = new char[6];
        int i2 = 0;
        while (i2 < pattern2.length()) {
            char c2 = pattern2.charAt(i2);
            switch (c2) {
                case '*': {
                    if (seenEscape || in_brackets > 0) {
                        sb.append(c2);
                        break;
                    }
                    sb.append('.').append(c2);
                    break;
                }
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    if (seenEscape || in_brackets > 0) {
                        sb.append(c2);
                        break;
                    }
                    sb.append('\\').append(c2);
                    break;
                }
                case '.': {
                    if (seenEscape) {
                        sb.append(c2);
                        break;
                    }
                    sb.append('\\').append('.');
                    break;
                }
                case '?': {
                    if (seenEscape || in_brackets > 0) {
                        sb.append(c2);
                        break;
                    }
                    sb.append('.');
                    break;
                }
                case ':': {
                    if (in_brackets > 0 && Strings.lookBehind(sb) == '[' && Character.isLetter(Strings.lookAhead(pattern2, i2))) {
                        in_char_class = true;
                    }
                    sb.append(':');
                    break;
                }
                case '-': {
                    if (in_brackets > 0) {
                        if (Strings.lookAhead(pattern2, i2) == ']') {
                            sb.append('\\').append(c2);
                            break;
                        }
                        sb.append(c2);
                        break;
                    }
                    sb.append('-');
                    break;
                }
                case '\\': {
                    if (in_brackets > 0) {
                        lookAhead = Strings.lookAhead(pattern2, i2);
                        if (lookAhead == ']' || lookAhead == '[') {
                            ignoreLastBracket = true;
                        }
                    } else {
                        lookAhead = Strings.lookAhead(pattern2, i2);
                        if (lookAhead != '\\' && lookAhead != '[' && lookAhead != '?' && lookAhead != '*' && lookAhead != ' ' && Strings.lookBehind(sb) != '\\') break;
                    }
                    sb.append(c2);
                    break;
                }
                case '[': {
                    if (in_brackets > 0) {
                        if (!seenEscape) {
                            sb.append('\\');
                        }
                        sb.append('[');
                        ignoreLastBracket = true;
                        break;
                    }
                    if (!seenEscape) {
                        ++in_brackets;
                        ignoreLastBracket = false;
                    }
                    sb.append('[');
                    break;
                }
                case ']': {
                    if (seenEscape) {
                        sb.append(']');
                        ignoreLastBracket = true;
                        break;
                    }
                    if (in_brackets <= 0) {
                        sb.append('\\').append(']');
                        ignoreLastBracket = true;
                        break;
                    }
                    char lookBehind = Strings.lookBehind(sb);
                    if (lookBehind == '[' && !ignoreLastBracket || lookBehind == '^') {
                        sb.append('\\');
                        sb.append(']');
                        ignoreLastBracket = true;
                        break;
                    }
                    ignoreLastBracket = false;
                    if (!in_char_class) {
                        --in_brackets;
                        sb.append(']');
                        break;
                    }
                    in_char_class = false;
                    String charCl = Strings.checkPosixCharClass(charClass);
                    if (charCl != null) {
                        sb.setLength(sb.length() - 4);
                        sb.append(charCl);
                    }
                    Strings.reset(charClass);
                    break;
                }
                case '!': {
                    if (in_brackets > 0) {
                        if (Strings.lookBehind(sb) == '[') {
                            sb.append('^');
                            break;
                        }
                        sb.append(c2);
                        break;
                    }
                    sb.append(c2);
                    break;
                }
                default: {
                    if (in_char_class) {
                        Strings.setNext(charClass, c2);
                        break;
                    }
                    sb.append(c2);
                }
            }
            seenEscape = c2 == '\\';
            ++i2;
        }
        if (in_brackets > 0) {
            throw new InvalidPatternException("Not closed bracket?", pattern2);
        }
        try {
            return Pattern.compile(sb.toString(), 32);
        }
        catch (PatternSyntaxException e2) {
            throw new InvalidPatternException(MessageFormat.format(JGitText.get().invalidIgnoreRule, pattern2), pattern2, e2);
        }
    }

    private static char lookBehind(StringBuilder buffer) {
        return buffer.length() > 0 ? buffer.charAt(buffer.length() - 1) : (char)'\u0000';
    }

    private static char lookAhead(String pattern2, int i2) {
        int idx = i2 + 1;
        return idx >= pattern2.length() ? (char)'\u0000' : pattern2.charAt(idx);
    }

    private static void setNext(char[] buffer, char c2) {
        int i2 = 0;
        while (i2 < buffer.length) {
            if (buffer[i2] == '\u0000') {
                buffer[i2] = c2;
                break;
            }
            ++i2;
        }
    }

    private static void reset(char[] buffer) {
        int i2 = 0;
        while (i2 < buffer.length) {
            buffer[i2] = '\u0000';
            ++i2;
        }
    }

    private static String checkPosixCharClass(char[] buffer) {
        int i2 = 0;
        while (i2 < POSIX_CHAR_CLASSES.size()) {
            String clazz = POSIX_CHAR_CLASSES.get(i2);
            boolean match2 = true;
            int j2 = 0;
            while (j2 < clazz.length()) {
                if (buffer[j2] != clazz.charAt(j2)) {
                    match2 = false;
                    break;
                }
                ++j2;
            }
            if (match2) {
                return JAVA_CHAR_CLASSES.get(i2);
            }
            ++i2;
        }
        return null;
    }

    static String deleteBackslash(String s2) {
        if (s2.indexOf(92) < 0) {
            return s2;
        }
        StringBuilder sb = new StringBuilder(s2.length());
        int i2 = 0;
        while (i2 < s2.length()) {
            block6: {
                char ch;
                block5: {
                    char next2;
                    block7: {
                        ch = s2.charAt(i2);
                        if (ch != '\\') break block5;
                        if (i2 + 1 == s2.length()) break block6;
                        next2 = s2.charAt(i2 + 1);
                        if (next2 != '\\') break block7;
                        sb.append(ch);
                        ++i2;
                        break block6;
                    }
                    if (!Strings.escapedByBackslash(next2)) break block6;
                }
                sb.append(ch);
            }
            ++i2;
        }
        return sb.toString();
    }

    static enum PatternState {
        LEADING_ASTERISK_ONLY,
        TRAILING_ASTERISK_ONLY,
        COMPLEX,
        NONE;

    }
}

