/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.diffmergetool;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.internal.diffmergetool.ExternalDiffTool;
import org.eclipse.jgit.internal.diffmergetool.UserDefinedDiffTool;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.internal.BooleanTriState;

public class DiffToolConfig {
    public static final Config.SectionParser<DiffToolConfig> KEY = DiffToolConfig::new;
    private final String toolName;
    private final String guiToolName;
    private final boolean prompt;
    private final BooleanTriState trustExitCode;
    private final Map<String, ExternalDiffTool> tools;

    private DiffToolConfig(Config rc2) {
        this.toolName = rc2.getString("diff", null, "tool");
        this.guiToolName = rc2.getString("diff", null, "guitool");
        this.prompt = rc2.getBoolean("difftool", this.toolName, "prompt", true);
        String trustStr = rc2.getString("difftool", this.toolName, "trustExitCode");
        this.trustExitCode = trustStr != null ? (Boolean.parseBoolean(trustStr) ? BooleanTriState.TRUE : BooleanTriState.FALSE) : BooleanTriState.UNSET;
        this.tools = new HashMap<String, ExternalDiffTool>();
        Set<String> subsections = rc2.getSubsections("difftool");
        for (String name : subsections) {
            String cmd = rc2.getString("difftool", name, "cmd");
            String path2 = rc2.getString("difftool", name, "path");
            if (cmd == null && path2 == null) continue;
            this.tools.put(name, new UserDefinedDiffTool(name, path2, cmd));
        }
    }

    public String getDefaultToolName() {
        return this.toolName;
    }

    public String getDefaultGuiToolName() {
        return this.guiToolName;
    }

    public boolean isPrompt() {
        return this.prompt;
    }

    public boolean isTrustExitCode() {
        return this.trustExitCode == BooleanTriState.TRUE;
    }

    public Map<String, ExternalDiffTool> getTools() {
        return this.tools;
    }

    public Set<String> getToolNames() {
        return this.tools.keySet();
    }
}

