/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.diffmergetool;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.internal.diffmergetool.ExternalMergeTool;
import org.eclipse.jgit.internal.diffmergetool.UserDefinedMergeTool;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.internal.BooleanTriState;

public class MergeToolConfig {
    public static final Config.SectionParser<MergeToolConfig> KEY = MergeToolConfig::new;
    private final String toolName;
    private final String guiToolName;
    private final boolean prompt;
    private final boolean keepBackup;
    private final boolean keepTemporaries;
    private final boolean writeToTemp;
    private final Map<String, ExternalMergeTool> tools;

    private MergeToolConfig(Config rc2) {
        this.toolName = rc2.getString("merge", null, "tool");
        this.guiToolName = rc2.getString("merge", null, "guitool");
        this.prompt = rc2.getBoolean("mergetool", this.toolName, "prompt", true);
        this.keepBackup = rc2.getBoolean("mergetool", "keepBackup", true);
        this.keepTemporaries = rc2.getBoolean("mergetool", "keepTemporaries", false);
        this.writeToTemp = rc2.getBoolean("mergetool", "writeToTemp", false);
        this.tools = new HashMap<String, ExternalMergeTool>();
        Set<String> subsections = rc2.getSubsections("mergetool");
        for (String name : subsections) {
            String cmd = rc2.getString("mergetool", name, "cmd");
            String path2 = rc2.getString("mergetool", name, "path");
            BooleanTriState trustExitCode = BooleanTriState.FALSE;
            String trustStr = rc2.getString("mergetool", name, "trustExitCode");
            trustExitCode = trustStr != null ? (Boolean.valueOf(trustStr) != false ? BooleanTriState.TRUE : BooleanTriState.FALSE) : BooleanTriState.UNSET;
            if (cmd == null && path2 == null) continue;
            this.tools.put(name, new UserDefinedMergeTool(name, path2, cmd, trustExitCode));
        }
    }

    public String getDefaultToolName() {
        return this.toolName;
    }

    public String getDefaultGuiToolName() {
        return this.guiToolName;
    }

    public boolean isPrompt() {
        return this.prompt;
    }

    public boolean isKeepBackup() {
        return this.keepBackup;
    }

    public boolean isKeepTemporaries() {
        return this.keepTemporaries;
    }

    public boolean isWriteToTemp() {
        return this.writeToTemp;
    }

    public Map<String, ExternalMergeTool> getTools() {
        return this.tools;
    }

    public Set<String> getToolNames() {
        return this.tools.keySet();
    }
}

