/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.signing.ssh;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.security.PublicKey;
import java.text.MessageFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.OpenSshCertificate;
import org.apache.sshd.common.config.keys.PublicKeyEntry;
import org.apache.sshd.common.util.io.ModifiableFileWatcher;
import org.eclipse.jgit.internal.transport.ssh.OpenSshConfigFile;
import org.eclipse.jgit.internal.transport.sshd.SshdText;
import org.eclipse.jgit.signing.ssh.VerificationException;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.SystemReader;

final class AllowedSigners
extends ModifiableFileWatcher {
    private static final String CERT_AUTHORITY = "cert-authority";
    private static final String NAMESPACES = "namespaces=";
    private static final String VALID_AFTER = "valid-after=";
    private static final String VALID_BEFORE = "valid-before=";
    private static final DateTimeFormatter SSH_DATE_FORMAT = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4).appendValue(ChronoField.MONTH_OF_YEAR, 2).appendValue(ChronoField.DAY_OF_MONTH, 2).optionalStart().appendValue(ChronoField.HOUR_OF_DAY, 2).appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter(Locale.ROOT);
    private static final Predicate<AllowedEntry> CERTIFICATES = AllowedEntry::isCA;
    private static final Predicate<AllowedEntry> PLAIN_KEYS = Predicate.not(CERTIFICATES);
    private State state = new State(new HashMap<String, List<AllowedEntry>>());

    public AllowedSigners(Path path2) {
        super(path2);
    }

    public String isAllowed(PublicKey key2, String namespace, String name, Instant time) throws IOException, VerificationException {
        State currentState = this.refresh();
        PublicKey keyToCheck = key2;
        if (key2 instanceof OpenSshCertificate) {
            OpenSshCertificate certificate = (OpenSshCertificate)key2;
            AllowedEntry entry = this.find(currentState, certificate.getCaPubKey(), namespace, name, time, CERTIFICATES);
            if (entry != null) {
                Collection<String> principals = certificate.getPrincipals();
                if (principals.isEmpty()) {
                    String identities = !StringUtils.isEmptyOrNull(name) ? name : Arrays.stream(entry.identities()).collect(Collectors.joining(","));
                    throw new VerificationException(false, MessageFormat.format(SshdText.get().signCertificateWithoutPrincipals, KeyUtils.getFingerPrint(certificate.getCaPubKey()), identities));
                }
                if (!StringUtils.isEmptyOrNull(name)) {
                    if (!principals.contains(name)) {
                        throw new VerificationException(false, MessageFormat.format(SshdText.get().signCertificateNotForName, KeyUtils.getFingerPrint(certificate.getCaPubKey()), name));
                    }
                    return name;
                }
                LinkedHashSet<String> filtered2 = new LinkedHashSet<String>();
                List<String> patterns2 = Arrays.asList(entry.identities());
                for (String principal : principals) {
                    if (!OpenSshConfigFile.patternMatch(patterns2, principal)) continue;
                    filtered2.add(principal);
                }
                return filtered2.stream().collect(Collectors.joining(","));
            }
            return null;
        }
        AllowedEntry entry = this.find(currentState, keyToCheck, namespace, name, time, PLAIN_KEYS);
        if (entry != null) {
            if (!StringUtils.isEmptyOrNull(name)) {
                return name;
            }
            return Arrays.stream(entry.identities()).collect(Collectors.joining(","));
        }
        return null;
    }

    private AllowedEntry find(State current, PublicKey key2, String namespace, String name, Instant time, Predicate<AllowedEntry> filter2) throws VerificationException {
        String k2 = PublicKeyEntry.toString(key2);
        VerificationException v = null;
        List<AllowedEntry> candidates = current.entries().get(k2);
        if (candidates == null) {
            return null;
        }
        for (AllowedEntry entry : candidates) {
            if (!filter2.test(entry) || name != null && !OpenSshConfigFile.patternMatch(Arrays.asList(entry.identities()), name)) continue;
            if (entry.namespaces() != null && !OpenSshConfigFile.patternMatch(Arrays.asList(entry.namespaces()), namespace)) {
                if (v != null) continue;
                v = new VerificationException(false, MessageFormat.format(SshdText.get().signWrongNamespace, KeyUtils.getFingerPrint(key2), namespace));
                continue;
            }
            if (time != null) {
                if (entry.validAfter() != null && time.isBefore(entry.validAfter())) {
                    if (v != null) continue;
                    v = new VerificationException(true, MessageFormat.format(SshdText.get().signKeyTooEarly, KeyUtils.getFingerPrint(key2)));
                    continue;
                }
                if (entry.validBefore() != null && time.isAfter(entry.validBefore())) {
                    if (v != null) continue;
                    v = new VerificationException(true, MessageFormat.format(SshdText.get().signKeyTooEarly, KeyUtils.getFingerPrint(key2)));
                    continue;
                }
            }
            return entry;
        }
        if (v != null) {
            throw v;
        }
        return null;
    }

    private synchronized State refresh() throws IOException {
        if (this.checkReloadRequired()) {
            this.updateReloadAttributes();
            try {
                this.state = AllowedSigners.reload(this.getPath());
            }
            catch (NoSuchFileException e2) {
                this.resetReloadAttributes();
                this.state = new State(new HashMap<String, List<AllowedEntry>>());
            }
        }
        return this.state;
    }

    private static State reload(Path path2) throws IOException {
        HashMap<String, List<AllowedEntry>> entries2 = new HashMap<String, List<AllowedEntry>>();
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader r = Files.newBufferedReader(path2, StandardCharsets.UTF_8);){
            String line;
            int lineNumber = 1;
            while ((line = r.readLine()) != null) {
                line = line.strip();
                try {
                    AllowedEntry entry = AllowedSigners.parseLine(line);
                    if (entry != null) {
                        entries2.computeIfAbsent(entry.key(), k2 -> new ArrayList()).add(entry);
                    }
                }
                catch (IOException | RuntimeException e2) {
                    throw new IOException(MessageFormat.format(SshdText.get().signAllowedSignersFormatError, path2, Integer.toString(lineNumber), line), e2);
                }
                ++lineNumber;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return new State(entries2);
    }

    private static boolean matches(String src, String other, int offset) {
        return src.regionMatches(true, offset, other, 0, other.length());
    }

    static AllowedEntry parseLine(String line) throws IOException {
        if (StringUtils.isEmptyOrNull(line) || line.charAt(0) == '#') {
            return null;
        }
        int length = line.length();
        if (AllowedSigners.matches(line, CERT_AUTHORITY, 0) && CERT_AUTHORITY.length() < length && Character.isWhitespace(line.charAt(CERT_AUTHORITY.length())) || AllowedSigners.matches(line, NAMESPACES, 0) || AllowedSigners.matches(line, VALID_AFTER, 0) || AllowedSigners.matches(line, VALID_BEFORE, 0)) {
            throw new StreamCorruptedException(SshdText.get().signAllowedSignersNoIdentities);
        }
        int i2 = 0;
        while (i2 < length && !Character.isWhitespace(line.charAt(i2))) {
            ++i2;
        }
        if (i2 >= length) {
            throw new StreamCorruptedException(SshdText.get().signAllowedSignersLineFormat);
        }
        String[] identities = line.substring(0, i2).split(",");
        if (Arrays.stream(identities).anyMatch(String::isEmpty)) {
            throw new StreamCorruptedException(MessageFormat.format(SshdText.get().signAllowedSignersEmptyIdentity, line.substring(0, i2)));
        }
        ++i2;
        boolean isCA = false;
        ArrayList<String> namespaces = null;
        Instant validAfter = null;
        Instant validBefore = null;
        while (i2 < length) {
            Dequoted parsed;
            if (Character.isSpaceChar(line.charAt(i2))) {
                ++i2;
                continue;
            }
            if (AllowedSigners.matches(line, CERT_AUTHORITY, i2)) {
                isCA = true;
                if (!Character.isWhitespace(line.charAt(i2 += CERT_AUTHORITY.length()))) {
                    throw new StreamCorruptedException(SshdText.get().signAllowedSignersCertAuthorityError);
                }
                ++i2;
                continue;
            }
            if (AllowedSigners.matches(line, NAMESPACES, i2)) {
                if (namespaces != null) {
                    throw new StreamCorruptedException(MessageFormat.format(SshdText.get().signAllowedSignersMultiple, NAMESPACES));
                }
                parsed = AllowedSigners.dequote(line, i2 += NAMESPACES.length());
                i2 = parsed.after();
                String ns = parsed.value();
                String[] items2 = ns.split(",");
                namespaces = new ArrayList<String>(items2.length);
                int j2 = 0;
                while (j2 < items2.length) {
                    String n = items2[j2].strip();
                    if (!n.isEmpty()) {
                        namespaces.add(n);
                    }
                    ++j2;
                }
                if (!namespaces.isEmpty()) continue;
                throw new StreamCorruptedException(SshdText.get().signAllowedSignersEmptyNamespaces);
            }
            if (AllowedSigners.matches(line, VALID_AFTER, i2)) {
                if (validAfter != null) {
                    throw new StreamCorruptedException(MessageFormat.format(SshdText.get().signAllowedSignersMultiple, VALID_AFTER));
                }
                parsed = AllowedSigners.dequote(line, i2 += VALID_AFTER.length());
                i2 = parsed.after();
                validAfter = AllowedSigners.parseDate(parsed.value());
                continue;
            }
            if (!AllowedSigners.matches(line, VALID_BEFORE, i2)) break;
            if (validBefore != null) {
                throw new StreamCorruptedException(MessageFormat.format(SshdText.get().signAllowedSignersMultiple, VALID_BEFORE));
            }
            parsed = AllowedSigners.dequote(line, i2 += VALID_BEFORE.length());
            i2 = parsed.after();
            validBefore = AllowedSigners.parseDate(parsed.value());
        }
        String key2 = AllowedSigners.parsePublicKey(line, i2);
        return new AllowedEntry(identities, isCA, namespaces == null ? null : namespaces.toArray(new String[0]), validAfter, validBefore, key2);
    }

    static String parsePublicKey(String s2, int from2) throws StreamCorruptedException {
        int i2 = from2;
        int length = s2.length();
        while (i2 < length && Character.isWhitespace(s2.charAt(i2))) {
            ++i2;
        }
        if (i2 >= length) {
            throw new StreamCorruptedException(MessageFormat.format(SshdText.get().signAllowedSignersPublicKeyParsing, s2.substring(from2)));
        }
        int start2 = i2;
        while (i2 < length && !Character.isWhitespace(s2.charAt(i2))) {
            ++i2;
        }
        if (i2 >= length) {
            throw new StreamCorruptedException(MessageFormat.format(SshdText.get().signAllowedSignersPublicKeyParsing, s2.substring(start2)));
        }
        int endOfKeyType = i2;
        i2 = endOfKeyType + 1;
        while (i2 < length && Character.isWhitespace(s2.charAt(i2))) {
            ++i2;
        }
        int startOfKey = i2;
        while (i2 < length && !Character.isWhitespace(s2.charAt(i2))) {
            ++i2;
        }
        if (i2 == startOfKey) {
            throw new StreamCorruptedException(MessageFormat.format(SshdText.get().signAllowedSignersPublicKeyParsing, s2.substring(start2)));
        }
        String keyType = s2.substring(start2, endOfKeyType);
        String key2 = s2.substring(startOfKey, i2);
        if (!key2.startsWith("AAAA")) {
            throw new StreamCorruptedException(MessageFormat.format(SshdText.get().signAllowedSignersPublicKeyParsing, s2.substring(start2)));
        }
        return keyType + " " + s2.substring(startOfKey, i2);
    }

    static Instant parseDate(String input) {
        TemporalAccessor temporalAccessor;
        String timeSpec = input;
        int length = input.length();
        if (length < 8) {
            throw new IllegalArgumentException(MessageFormat.format(SshdText.get().signAllowedSignersInvalidDate, input));
        }
        boolean isUTC = false;
        if (timeSpec.charAt(length - 1) == 'Z') {
            isUTC = true;
            timeSpec = timeSpec.substring(0, length - 1);
        }
        LocalDateTime time = (temporalAccessor = SSH_DATE_FORMAT.parseBest(timeSpec, LocalDateTime::from, LocalDate::from)) instanceof LocalDateTime ? (LocalDateTime)temporalAccessor : ((LocalDate)temporalAccessor).atStartOfDay();
        if (isUTC) {
            return time.atOffset(ZoneOffset.UTC).toInstant();
        }
        ZoneId tz = SystemReader.getInstance().getTimeZoneId();
        return time.atZone(tz).toInstant();
    }

    /*
     * Unable to fully structure code
     */
    static Dequoted dequote(String line, int from) {
        length = line.length();
        i = from;
        if (line.charAt(i) != '\"') ** GOTO lbl30
        quoted = false;
        ++i;
        b = new StringBuilder();
        while (i < length) {
            ch = line.charAt(i);
            if (ch == '\"') {
                if (!quoted) break;
                b.append(ch);
                quoted = false;
            } else if (ch == '\\') {
                quoted = true;
            } else {
                if (quoted) {
                    b.append('\\');
                }
                b.append(ch);
                quoted = false;
            }
            ++i;
        }
        if (i >= length) {
            throw new IllegalArgumentException(SshdText.get().signAllowedSignersUnterminatedQuote);
        }
        return new Dequoted(b.toString(), i + 1);
lbl-1000:
        // 1 sources

        {
            ++i;
lbl30:
            // 2 sources

            ** while (i < length && !Character.isWhitespace((char)line.charAt((int)i)))
        }
lbl31:
        // 1 sources

        return new Dequoted(line.substring(from, i), i);
    }

    record AllowedEntry(String[] identities, boolean isCA, String[] namespaces, Instant validAfter, Instant validBefore, String key) {
        @Override
        public final boolean equals(Object any2) {
            if (this == any2) {
                return true;
            }
            if (any2 == null || !(any2 instanceof AllowedEntry)) {
                return false;
            }
            AllowedEntry other = (AllowedEntry)any2;
            return this.isCA == other.isCA && Arrays.equals(this.identities, other.identities) && Arrays.equals(this.namespaces, other.namespaces) && Objects.equals(this.validAfter, other.validAfter) && Objects.equals(this.validBefore, other.validBefore) && Objects.equals(this.key, other.key);
        }

        @Override
        public final int hashCode() {
            int hash = Boolean.hashCode(this.isCA);
            hash = hash * 31 + Arrays.hashCode(this.identities);
            hash = hash * 31 + Arrays.hashCode(this.namespaces);
            return hash * 31 + Objects.hash(this.validAfter, this.validBefore, this.key);
        }
    }

    record Dequoted(String value, int after) {
    }

    private record State(Map<String, List<AllowedEntry>> entries) {
    }
}

