/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.signing.ssh;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.sshd.common.config.keys.OpenSshCertificate;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.internal.signing.ssh.SerialRangeSet;
import org.eclipse.jgit.internal.transport.sshd.SshdText;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.StringUtils;

class OpenSshBinaryKrl {
    static final byte[] MAGIC;
    private static final int FORMAT_VERSION = 1;
    private static final int SECTION_CERTIFICATES = 1;
    private static final int SECTION_KEY = 2;
    private static final int SECTION_SHA1 = 3;
    private static final int SECTION_SIGNATURE = 4;
    private static final int SECTION_SHA256 = 5;
    private static final int SECTION_EXTENSION = 255;
    private static final int CERT_SERIAL_LIST = 32;
    private static final int CERT_SERIAL_RANGES = 33;
    private static final int CERT_SERIAL_BITS = 34;
    private static final int CERT_KEY_IDS = 35;
    private static final int CERT_EXTENSIONS = 57;
    private final Map<Blob, CertificateRevocation> certificates = new HashMap<Blob, CertificateRevocation>();
    private final Set<Blob> blobs = new HashSet<Blob>();
    private final Set<Blob> sha1 = new HashSet<Blob>();
    private final Set<Blob> sha256 = new HashSet<Blob>();

    static {
        byte[] byArray = new byte[8];
        byArray[0] = 83;
        byArray[1] = 83;
        byArray[2] = 72;
        byArray[3] = 75;
        byArray[4] = 82;
        byArray[5] = 76;
        byArray[6] = 10;
        MAGIC = byArray;
    }

    private OpenSshBinaryKrl() {
    }

    boolean isRevoked(PublicKey key2) {
        if (key2 instanceof OpenSshCertificate) {
            OpenSshCertificate certificate = (OpenSshCertificate)key2;
            if (this.certificates.isEmpty()) {
                return false;
            }
            if (this.isRevoked(certificate, this.certificates.get(null))) {
                return true;
            }
            return this.isRevoked(certificate, this.certificates.get(this.blob(certificate.getCaPubKey())));
        }
        if (!this.blobs.isEmpty() && this.blobs.contains(this.blob(key2))) {
            return true;
        }
        if (!this.sha256.isEmpty() && this.sha256.contains(this.hash("SHA256", key2))) {
            return true;
        }
        return !this.sha1.isEmpty() && this.sha1.contains(this.hash("SHA1", key2));
    }

    private boolean isRevoked(OpenSshCertificate certificate, CertificateRevocation revocations) {
        if (revocations == null) {
            return false;
        }
        String id = certificate.getId();
        if (!StringUtils.isEmptyOrNull(id) && revocations.keyIds.contains(id)) {
            return true;
        }
        long serial = certificate.getSerial();
        return serial != 0L && revocations.ranges.contains(serial);
    }

    private Blob blob(PublicKey key2) {
        ByteArrayBuffer buf = new ByteArrayBuffer();
        buf.putRawPublicKey(key2);
        return new Blob(buf.getCompactData());
    }

    private Blob hash(String algorithm, PublicKey key2) {
        ByteArrayBuffer buf = new ByteArrayBuffer();
        buf.putRawPublicKey(key2);
        try {
            return new Blob(MessageDigest.getInstance(algorithm).digest(buf.getCompactData()));
        }
        catch (NoSuchAlgorithmException e2) {
            throw new JGitInternalException(e2.getMessage(), e2);
        }
    }

    @NonNull
    static OpenSshBinaryKrl load(InputStream in, boolean magicSkipped) throws IOException {
        if (!magicSkipped) {
            byte[] magic = new byte[MAGIC.length];
            IO.readFully(in, magic);
            if (!Arrays.equals(magic, MAGIC)) {
                throw new StreamCorruptedException(SshdText.get().signKrlInvalidMagic);
            }
        }
        OpenSshBinaryKrl.skipHeader(in);
        return OpenSshBinaryKrl.load(in);
    }

    private static long getUInt(InputStream in) throws IOException {
        byte[] buf = new byte[4];
        IO.readFully(in, buf);
        return BufferUtils.getUInt(buf);
    }

    private static long getLong(InputStream in) throws IOException {
        byte[] buf = new byte[8];
        IO.readFully(in, buf);
        return BufferUtils.getLong(buf, 0, 8);
    }

    private static void skipHeader(InputStream in) throws IOException {
        long version2 = OpenSshBinaryKrl.getUInt(in);
        if (version2 != 1L) {
            throw new StreamCorruptedException(MessageFormat.format(SshdText.get().signKrlInvalidVersion, version2));
        }
        in.skip(24L);
        in.skip(OpenSshBinaryKrl.getUInt(in));
        in.skip(OpenSshBinaryKrl.getUInt(in));
    }

    private static OpenSshBinaryKrl load(InputStream in) throws IOException {
        int sectionType;
        OpenSshBinaryKrl krl = new OpenSshBinaryKrl();
        block8: while ((sectionType = in.read()) >= 0) {
            switch (sectionType) {
                case 1: {
                    OpenSshBinaryKrl.readCertificates(krl.certificates, in, OpenSshBinaryKrl.getUInt(in));
                    continue block8;
                }
                case 2: {
                    OpenSshBinaryKrl.readBlobs("explicit_keys", krl.blobs, in, OpenSshBinaryKrl.getUInt(in), 0L);
                    continue block8;
                }
                case 3: {
                    OpenSshBinaryKrl.readBlobs("fingerprint_sha1", krl.sha1, in, OpenSshBinaryKrl.getUInt(in), 20L);
                    continue block8;
                }
                case 4: {
                    in.skip(OpenSshBinaryKrl.getUInt(in));
                    continue block8;
                }
                case 5: {
                    OpenSshBinaryKrl.readBlobs("fingerprint_sha256", krl.sha256, in, OpenSshBinaryKrl.getUInt(in), 32L);
                    continue block8;
                }
                case 255: {
                    in.skip(OpenSshBinaryKrl.getUInt(in));
                    continue block8;
                }
            }
            throw new StreamCorruptedException(MessageFormat.format(SshdText.get().signKrlUnknownSection, sectionType));
        }
        return krl;
    }

    private static void readBlobs(String sectionName, Set<Blob> blobs, InputStream in, long sectionLength, long expectedBlobLength) throws IOException {
        while (sectionLength >= 4L) {
            long blobLength = OpenSshBinaryKrl.getUInt(in);
            if (blobLength > (sectionLength -= 4L)) {
                throw new StreamCorruptedException(MessageFormat.format(SshdText.get().signKrlBlobLengthInvalid, sectionName, blobLength));
            }
            if (expectedBlobLength != 0L && blobLength != expectedBlobLength) {
                throw new StreamCorruptedException(MessageFormat.format(SshdText.get().signKrlBlobLengthInvalidExpected, sectionName, blobLength, expectedBlobLength));
            }
            byte[] blob = new byte[(int)blobLength];
            IO.readFully(in, blob);
            sectionLength -= blobLength;
            blobs.add(new Blob(blob));
        }
        if (sectionLength != 0L) {
            throw new StreamCorruptedException(MessageFormat.format(SshdText.get().signKrlBlobLeftover, sectionName, sectionLength));
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void readCertificates(Map<Blob, CertificateRevocation> certs, InputStream in, long sectionLength) throws IOException {
        keyLength = OpenSshBinaryKrl.getUInt(in);
        if (keyLength > (sectionLength -= 4L)) {
            throw new StreamCorruptedException(MessageFormat.format(SshdText.get().signKrlCaKeyLengthInvalid, new Object[]{keyLength}));
        }
        key = null;
        if (keyLength > 0L) {
            blob = new byte[(int)keyLength];
            IO.readFully(in, blob);
            key = new Blob(blob);
            sectionLength -= keyLength;
        }
        rev = certs.computeIfAbsent(key, (Function<Blob, CertificateRevocation>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$0(org.eclipse.jgit.internal.signing.ssh.OpenSshBinaryKrl$Blob ), (Lorg/eclipse/jgit/internal/signing/ssh/OpenSshBinaryKrl$Blob;)Lorg/eclipse/jgit/internal/signing/ssh/OpenSshBinaryKrl$CertificateRevocation;)());
        reservedLength = OpenSshBinaryKrl.getUInt(in);
        if (reservedLength > (sectionLength -= 4L)) {
            throw new StreamCorruptedException(MessageFormat.format(SshdText.get().signKrlCaKeyLengthInvalid, new Object[]{reservedLength}));
        }
        in.skip(reservedLength);
        if ((sectionLength -= reservedLength) != 0L) ** GOTO lbl47
        throw new StreamCorruptedException(SshdText.get().signKrlNoCertificateSubsection);
lbl-1000:
        // 1 sources

        {
            subSection = in.read();
            if (subSection < 0) {
                throw new EOFException();
            }
            if (--sectionLength < 4L) {
                throw new StreamCorruptedException(MessageFormat.format(SshdText.get().signKrlCertificateLeftover, new Object[]{sectionLength}));
            }
            subLength = OpenSshBinaryKrl.getUInt(in);
            if (subLength > (sectionLength -= 4L)) {
                throw new StreamCorruptedException(MessageFormat.format(SshdText.get().signKrlCertificateSubsectionLength, new Object[]{subLength}));
            }
            if (subLength > 0L) {
                switch (subSection) {
                    case 32: {
                        OpenSshBinaryKrl.readSerials(rev.ranges, in, subLength, false);
                        break;
                    }
                    case 33: {
                        OpenSshBinaryKrl.readSerials(rev.ranges, in, subLength, true);
                        break;
                    }
                    case 34: {
                        OpenSshBinaryKrl.readSerialBitSet(rev.ranges, in, subLength);
                        break;
                    }
                    case 35: {
                        OpenSshBinaryKrl.readIds(rev.keyIds, in, subLength);
                        break;
                    }
                    case 57: {
                        in.skip(subLength);
                        break;
                    }
                    default: {
                        throw new StreamCorruptedException(MessageFormat.format(SshdText.get().signKrlUnknownSubsection, new Object[]{(long)subSection}));
                    }
                }
            }
            sectionLength -= subLength;
lbl47:
            // 2 sources

            ** while (sectionLength > 0L)
        }
lbl48:
        // 1 sources

    }

    private static void readSerials(SerialRangeSet set2, InputStream in, long length, boolean ranges) throws IOException {
        while (length >= 8L) {
            long a2 = OpenSshBinaryKrl.getLong(in);
            length -= 8L;
            if (a2 == 0L) {
                throw new StreamCorruptedException(SshdText.get().signKrlSerialZero);
            }
            if (!ranges) {
                set2.add(a2);
                continue;
            }
            if (length < 8L) {
                throw new StreamCorruptedException(MessageFormat.format(SshdText.get().signKrlShortRange, length));
            }
            long b2 = OpenSshBinaryKrl.getLong(in);
            length -= 8L;
            if (Long.compareUnsigned(a2, b2) > 0) {
                throw new StreamCorruptedException(SshdText.get().signKrlEmptyRange);
            }
            set2.add(a2, b2);
        }
        if (length != 0L) {
            throw new StreamCorruptedException(MessageFormat.format(SshdText.get().signKrlCertificateSubsectionLeftover, length));
        }
    }

    private static void readSerialBitSet(SerialRangeSet set2, InputStream in, long subLength) throws IOException {
        while (subLength > 0L) {
            if (subLength < 8L) {
                throw new StreamCorruptedException(MessageFormat.format(SshdText.get().signKrlCertificateSubsectionLeftover, subLength));
            }
            long base = OpenSshBinaryKrl.getLong(in);
            if ((subLength -= 8L) < 4L) {
                throw new StreamCorruptedException(MessageFormat.format(SshdText.get().signKrlCertificateSubsectionLeftover, subLength));
            }
            long setLength = OpenSshBinaryKrl.getUInt(in);
            if (setLength == 0L || setLength > (subLength -= 4L)) {
                throw new StreamCorruptedException(MessageFormat.format(SshdText.get().signKrlInvalidBitSetLength, setLength));
            }
            int n = (int)setLength;
            int i2 = n - 1;
            while (i2 >= 0) {
                int b2 = in.read();
                if (b2 < 0) {
                    throw new EOFException();
                }
                if (b2 != 0) {
                    int bit = 0;
                    int mask = 1;
                    while (bit < 8) {
                        if ((b2 & mask) != 0) {
                            set2.add(base + (long)(i2 * 8) + (long)bit);
                        }
                        ++bit;
                        mask <<= 1;
                    }
                }
                --i2;
            }
            subLength -= setLength;
        }
    }

    private static void readIds(Set<String> ids, InputStream in, long subLength) throws IOException {
        while (subLength >= 4L) {
            long length = OpenSshBinaryKrl.getUInt(in);
            if (length > (subLength -= 4L)) {
                throw new StreamCorruptedException(MessageFormat.format(SshdText.get().signKrlInvalidKeyIdLength, length));
            }
            byte[] bytes = new byte[(int)length];
            IO.readFully(in, bytes);
            ids.add(new String(bytes, StandardCharsets.UTF_8));
            subLength -= length;
        }
        if (subLength != 0L) {
            throw new StreamCorruptedException(MessageFormat.format(SshdText.get().signKrlCertificateSubsectionLeftover, subLength));
        }
    }

    private static /* synthetic */ CertificateRevocation lambda$0(Blob k2) {
        return new CertificateRevocation();
    }

    private record Blob(byte[] blob) {
        @Override
        public final boolean equals(Object any2) {
            if (this == any2) {
                return true;
            }
            if (any2 == null || !(any2 instanceof Blob)) {
                return false;
            }
            Blob other = (Blob)any2;
            return Arrays.equals(this.blob, other.blob);
        }

        @Override
        public final int hashCode() {
            return Arrays.hashCode(this.blob);
        }
    }

    private static class CertificateRevocation {
        final SerialRangeSet ranges = new SerialRangeSet();
        final Set<String> keyIds = new HashSet<String>();

        private CertificateRevocation() {
        }
    }
}

