/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.signing.ssh;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.sshd.common.config.keys.OpenSshCertificate;
import org.apache.sshd.common.config.keys.PublicKeyEntry;
import org.apache.sshd.common.util.io.ModifiableFileWatcher;
import org.eclipse.jgit.internal.signing.ssh.AllowedSigners;
import org.eclipse.jgit.internal.signing.ssh.OpenSshBinaryKrl;
import org.eclipse.jgit.util.IO;

class OpenSshKrl
extends ModifiableFileWatcher {
    private State state = new State(Set.of(), null);

    public OpenSshKrl(Path path2) {
        super(path2);
    }

    public boolean isRevoked(PublicKey key2) throws IOException {
        State current = this.refresh();
        return this.isRevoked(current, key2);
    }

    private boolean isRevoked(State current, PublicKey key2) {
        if (key2 instanceof OpenSshCertificate) {
            OpenSshCertificate cert = (OpenSshCertificate)key2;
            OpenSshBinaryKrl krl = current.krl();
            if (krl != null && krl.isRevoked(cert)) {
                return true;
            }
            return this.isRevoked(current, cert.getCaPubKey()) || this.isRevoked(current, cert.getCertPubKey());
        }
        OpenSshBinaryKrl krl = current.krl();
        if (krl != null) {
            return krl.isRevoked(key2);
        }
        return current.keys().contains(PublicKeyEntry.toString(key2));
    }

    private synchronized State refresh() throws IOException {
        if (this.checkReloadRequired()) {
            this.updateReloadAttributes();
            try {
                this.state = OpenSshKrl.reload(this.getPath());
            }
            catch (NoSuchFileException e2) {
                this.resetReloadAttributes();
                this.state = new State(Set.of(), null);
            }
        }
        return this.state;
    }

    private static State reload(Path path2) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(path2, new OpenOption[0]));){
            byte[] magic = new byte[OpenSshBinaryKrl.MAGIC.length];
            in.mark(magic.length);
            IO.readFully(in, magic);
            if (Arrays.equals(magic, OpenSshBinaryKrl.MAGIC)) {
                return new State(null, OpenSshBinaryKrl.load(in, true));
            }
            in.reset();
            return OpenSshKrl.loadTextKrl(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static State loadTextKrl(InputStream in) throws IOException {
        HashSet<String> keys2 = new HashSet<String>();
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader r = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
            String line;
            while ((line = r.readLine()) != null) {
                if ((line = line.strip()).isEmpty() || line.charAt(0) == '#') continue;
                keys2.add(AllowedSigners.parsePublicKey(line, 0));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return new State(keys2, null);
    }

    private record State(Set<String> keys, OpenSshBinaryKrl krl) {
    }
}

