/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.signing.ssh;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.security.PublicKey;
import java.time.Instant;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.sshd.common.util.io.ModifiableFileWatcher;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.internal.signing.ssh.AllowedSigners;
import org.eclipse.jgit.internal.signing.ssh.OpenSshKrl;
import org.eclipse.jgit.lib.GpgConfig;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.signing.ssh.CachingSigningKeyDatabase;
import org.eclipse.jgit.signing.ssh.VerificationException;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.StringUtils;

public class OpenSshSigningKeyDatabase
implements CachingSigningKeyDatabase {
    private static final int DEFAULT_CACHE_SIZE = 5;
    private AtomicInteger cacheSize = new AtomicInteger(5);
    private final HashMap<Path, AllowedSigners> allowedSigners = new LRU<Path, AllowedSigners>();
    private final HashMap<Path, OpenSshKrl> revocations = new LRU<Path, OpenSshKrl>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRevoked(Repository repository, GpgConfig config2, PublicKey key2) throws IOException {
        OpenSshKrl revocationList;
        String fileName = config2.getSshRevocationFile();
        if (StringUtils.isEmptyOrNull(fileName)) {
            return false;
        }
        File file2 = this.getFile(repository, fileName);
        HashMap<Path, OpenSshKrl> hashMap = this.revocations;
        synchronized (hashMap) {
            revocationList = this.revocations.computeIfAbsent(file2.toPath(), OpenSshKrl::new);
        }
        return revocationList.isRevoked(key2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String isAllowed(Repository repository, GpgConfig config2, PublicKey key2, String namespace, PersonIdent ident) throws IOException, VerificationException {
        AllowedSigners allowed;
        String fileName = config2.getSshAllowedSignersFile();
        if (StringUtils.isEmptyOrNull(fileName)) {
            return null;
        }
        File file2 = this.getFile(repository, fileName);
        HashMap<Path, AllowedSigners> hashMap = this.allowedSigners;
        synchronized (hashMap) {
            allowed = this.allowedSigners.computeIfAbsent(file2.toPath(), AllowedSigners::new);
        }
        Instant gitTime = null;
        if (ident != null) {
            gitTime = ident.getWhenAsInstant();
        }
        return allowed.isAllowed(key2, namespace, null, gitTime);
    }

    private File getFile(@NonNull Repository repository, String fileName) throws IOException {
        File file2;
        if (fileName.startsWith("~/") || fileName.startsWith("~" + File.separator)) {
            file2 = FS.DETECTED.resolve(FS.DETECTED.userHome(), fileName.substring(2));
        } else {
            file2 = new File(fileName);
            if (!file2.isAbsolute()) {
                file2 = new File(repository.getWorkTree(), fileName);
            }
        }
        return file2.getCanonicalFile();
    }

    @Override
    public int getCacheSize() {
        return this.cacheSize.get();
    }

    @Override
    public void setCacheSize(int size2) {
        if (size2 > 0) {
            this.cacheSize.set(size2);
            this.pruneCache(size2);
        }
    }

    private void pruneCache(int size2) {
        this.prune(this.allowedSigners, size2);
        this.prune(this.revocations, size2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prune(HashMap<?, ?> map2, int size2) {
        HashMap<?, ?> hashMap = map2;
        synchronized (hashMap) {
            if (map2.size() <= size2) {
                return;
            }
            Iterator<Map.Entry<?, ?>> iter = map2.entrySet().iterator();
            int i2 = 0;
            while (iter.hasNext() && i2 < size2) {
                iter.next();
                ++i2;
            }
            while (iter.hasNext()) {
                iter.next();
                iter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache() {
        HashMap<Path, ModifiableFileWatcher> hashMap = this.allowedSigners;
        synchronized (hashMap) {
            this.allowedSigners.clear();
        }
        hashMap = this.revocations;
        synchronized (hashMap) {
            this.revocations.clear();
        }
    }

    private class LRU<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 1L;

        LRU() {
            super(5, 0.75f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > OpenSshSigningKeyDatabase.this.cacheSize.get();
        }
    }
}

