/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.signing.ssh;

import java.util.TreeMap;
import org.eclipse.jgit.internal.transport.sshd.SshdText;

class SerialRangeSet {
    private final TreeMap<SerialRange, SerialRange> ranges = new TreeMap(SerialRangeSet::compare);

    SerialRangeSet() {
    }

    private static int compare(SerialRange a2, SerialRange b2) {
        if (Long.compareUnsigned(a2.to(), b2.from()) >= 0 && Long.compareUnsigned(a2.from(), b2.to()) <= 0) {
            return 0;
        }
        return Long.compareUnsigned(a2.from(), b2.from());
    }

    void add(long serial) {
        SerialRangeSet.add(this.ranges, new Singleton(serial));
    }

    void add(long from2, long to) {
        SerialRangeSet.add(this.ranges, new Range(from2, to));
    }

    boolean contains(long serial) {
        return this.ranges.containsKey(new Singleton(serial));
    }

    int size() {
        return this.ranges.size();
    }

    boolean isEmpty() {
        return this.ranges.isEmpty();
    }

    private static void add(TreeMap<SerialRange, SerialRange> ranges, SerialRange newRange) {
        SerialRange next2;
        SerialRange existing;
        while ((existing = ranges.get(newRange)) != null) {
            if (Long.compareUnsigned(existing.from(), newRange.from()) <= 0 && Long.compareUnsigned(existing.to(), newRange.to()) >= 0) {
                return;
            }
            ranges.remove(existing);
            long newFrom = newRange.from();
            if (Long.compareUnsigned(existing.from(), newFrom) < 0) {
                newFrom = existing.from();
            }
            long newTo = newRange.to();
            if (Long.compareUnsigned(existing.to(), newTo) > 0) {
                newTo = existing.to();
            }
            newRange = new Range(newFrom, newTo);
        }
        SerialRange prev = ranges.floorKey(newRange);
        if (prev != null && newRange.from() - prev.to() == 1L) {
            ranges.remove(prev);
            newRange = new Range(prev.from(), newRange.to());
        }
        if ((next2 = ranges.ceilingKey(newRange)) != null && next2.from() - newRange.to() == 1L) {
            ranges.remove(next2);
            newRange = new Range(newRange.from(), next2.to());
        }
        ranges.put(newRange, newRange);
    }

    private record Range(long from, long to) implements SerialRange
    {
        public Range {
            if (Long.compareUnsigned(from2, to) > 0) {
                throw new IllegalArgumentException(SshdText.get().signKrlEmptyRange);
            }
        }
    }

    private static interface SerialRange {
        public long from();

        public long to();
    }

    private record Singleton(long from) implements SerialRange
    {
        @Override
        public long to() {
            return this.from;
        }
    }
}

