/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.signing.ssh;

import java.security.PublicKey;
import java.text.MessageFormat;
import java.time.Instant;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.OpenSshCertificate;
import org.apache.sshd.common.signature.BuiltinSignatures;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.internal.transport.sshd.SshdText;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SshCertificateUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SshCertificateUtils.class);

    SshCertificateUtils() {
    }

    static String verify(OpenSshCertificate certificate, Instant signatureTime) {
        if (!OpenSshCertificate.Type.USER.equals((Object)certificate.getType())) {
            return MessageFormat.format(SshdText.get().signNotUserCertificate, KeyUtils.getFingerPrint(certificate.getCaPubKey()));
        }
        String message = SshCertificateUtils.verifySignature(certificate);
        if (message == null && signatureTime != null) {
            message = SshCertificateUtils.checkExpiration(certificate, signatureTime);
        }
        return message;
    }

    static String verifySignature(OpenSshCertificate certificate) {
        PublicKey caKey = certificate.getCaPubKey();
        PublicKey certifiedKey = certificate.getCertPubKey();
        if (caKey == null || caKey instanceof OpenSshCertificate || certifiedKey == null || certifiedKey instanceof OpenSshCertificate) {
            return SshdText.get().signCertificateInvalid;
        }
        String keyType = KeyUtils.getKeyType(caKey);
        String certAlgorithm = certificate.getSignatureAlgorithm();
        if (!KeyUtils.getCanonicalKeyType(keyType).equals(KeyUtils.getCanonicalKeyType(certAlgorithm))) {
            return MessageFormat.format(SshdText.get().signCertAlgorithmMismatch, keyType, KeyUtils.getFingerPrint(certificate.getCaPubKey()), certAlgorithm);
        }
        BuiltinSignatures factory2 = BuiltinSignatures.fromFactoryName(certAlgorithm);
        if (factory2 == null || !factory2.isSupported()) {
            return MessageFormat.format(SshdText.get().signCertAlgorithmUnknown, KeyUtils.getFingerPrint(certificate.getCaPubKey()), certAlgorithm);
        }
        Signature signer = (Signature)factory2.create();
        try {
            signer.initVerifier(null, caKey);
            signer.update(null, SshCertificateUtils.getBlob(certificate));
            if (signer.verify(null, certificate.getRawSignature())) {
                return null;
            }
        }
        catch (Exception e2) {
            LOG.warn("{}", (Object)SshdText.get().signLogFailure, (Object)e2);
            return SshdText.get().signSeeLog;
        }
        return MessageFormat.format(SshdText.get().signCertificateInvalid, KeyUtils.getFingerPrint(certificate.getCaPubKey()));
    }

    private static byte[] getBlob(OpenSshCertificate certificate) {
        ByteArrayBuffer tmp = new ByteArrayBuffer();
        tmp.putString(certificate.getKeyType());
        tmp.putBytes(certificate.getNonce());
        tmp.putRawPublicKeyBytes(certificate.getCertPubKey());
        tmp.putLong(certificate.getSerial());
        ((Buffer)tmp).putInt(certificate.getType().getCode());
        tmp.putString(certificate.getId());
        ByteArrayBuffer list = new ByteArrayBuffer();
        list.putStringList(certificate.getPrincipals(), false);
        tmp.putBytes(list.getCompactData());
        tmp.putLong(certificate.getValidAfter());
        tmp.putLong(certificate.getValidBefore());
        tmp.putCertificateOptions(certificate.getCriticalOptions());
        tmp.putCertificateOptions(certificate.getExtensions());
        tmp.putString(certificate.getReserved());
        ByteArrayBuffer inner = new ByteArrayBuffer();
        inner.putRawPublicKey(certificate.getCaPubKey());
        tmp.putBytes(inner.getCompactData());
        return tmp.getCompactData();
    }

    static String checkExpiration(OpenSshCertificate certificate, @NonNull Instant signatureTime) {
        long instant = signatureTime.getEpochSecond();
        if (Long.compareUnsigned(instant, certificate.getValidAfter()) < 0) {
            return MessageFormat.format(SshdText.get().signCertificateTooEarly, KeyUtils.getFingerPrint(certificate.getCaPubKey()));
        }
        if (Long.compareUnsigned(instant, certificate.getValidBefore()) > 0) {
            return MessageFormat.format(SshdText.get().signCertificateExpired, KeyUtils.getFingerPrint(certificate.getCaPubKey()));
        }
        return null;
    }
}

