/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.signing.ssh;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.Date;
import java.util.Locale;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.OpenSshCertificate;
import org.apache.sshd.common.signature.BuiltinSignatures;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.eclipse.jgit.internal.signing.ssh.SshCertificateUtils;
import org.eclipse.jgit.internal.signing.ssh.SshSignatureConstants;
import org.eclipse.jgit.internal.transport.sshd.SshdText;
import org.eclipse.jgit.lib.GpgConfig;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.SignatureVerifier;
import org.eclipse.jgit.signing.ssh.CachingSigningKeyDatabase;
import org.eclipse.jgit.signing.ssh.SigningKeyDatabase;
import org.eclipse.jgit.signing.ssh.VerificationException;
import org.eclipse.jgit.util.Base64;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.jgit.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshSignatureVerifier
implements SignatureVerifier {
    private static final Logger LOG = LoggerFactory.getLogger(SshSignatureVerifier.class);
    private static final byte[] OBJECT = new byte[]{111, 98, 106, 101, 99, 116, 32};
    private static final byte[] TREE = new byte[]{116, 114, 101, 101, 32};
    private static final byte[] TYPE = new byte[]{116, 121, 112, 101, 32};

    @Override
    public String getName() {
        return "ssh";
    }

    @Override
    public SignatureVerifier.SignatureVerification verify(Repository repository, GpgConfig config2, byte[] data2, byte[] signatureData) throws IOException {
        boolean valid;
        String signatureAlgorithm;
        byte[] hash;
        String namespace;
        String fingerprint;
        byte[] decodedSignature;
        PersonIdent gitIdentity = SshSignatureVerifier.getGitIdentity(data2);
        Date signatureDate = null;
        Instant signatureInstant = null;
        if (gitIdentity != null) {
            signatureDate = gitIdentity.getWhen();
            signatureInstant = gitIdentity.getWhenAsInstant();
        }
        SignatureVerifier.TrustLevel trust = SignatureVerifier.TrustLevel.NEVER;
        try {
            decodedSignature = SshSignatureVerifier.dearmor(signatureData);
        }
        catch (IllegalArgumentException e2) {
            return new SignatureVerifier.SignatureVerification(this.getName(), signatureDate, null, null, null, false, false, trust, MessageFormat.format(SshdText.get().signInvalidSignature, e2.getLocalizedMessage()));
        }
        int start2 = RawParseUtils.match(decodedSignature, 0, SshSignatureConstants.MAGIC);
        if (start2 < 0) {
            return new SignatureVerifier.SignatureVerification(this.getName(), signatureDate, null, null, null, false, false, trust, SshdText.get().signInvalidMagic);
        }
        ByteArrayBuffer signature = new ByteArrayBuffer(decodedSignature, start2, decodedSignature.length - start2);
        long version2 = signature.getUInt();
        if (version2 != 1L) {
            return new SignatureVerifier.SignatureVerification(this.getName(), signatureDate, null, null, null, false, false, trust, MessageFormat.format(SshdText.get().signInvalidVersion, Long.toString(version2)));
        }
        PublicKey key2 = signature.getPublicKey();
        if (key2 instanceof OpenSshCertificate) {
            OpenSshCertificate cert = (OpenSshCertificate)key2;
            fingerprint = KeyUtils.getFingerPrint(cert.getCertPubKey());
            String message = SshCertificateUtils.verify(cert, signatureInstant);
            if (message != null) {
                return new SignatureVerifier.SignatureVerification(this.getName(), signatureDate, null, fingerprint, null, false, false, trust, message);
            }
        } else {
            fingerprint = KeyUtils.getFingerPrint(key2);
        }
        if (!"git".equals(namespace = signature.getString())) {
            return new SignatureVerifier.SignatureVerification(this.getName(), signatureDate, null, fingerprint, null, false, false, trust, MessageFormat.format(SshdText.get().signInvalidNamespace, namespace));
        }
        signature.getString();
        String hashAlgorithm = signature.getString();
        try {
            hash = MessageDigest.getInstance(hashAlgorithm.toUpperCase(Locale.ROOT)).digest(data2);
        }
        catch (NoSuchAlgorithmException e3) {
            return new SignatureVerifier.SignatureVerification(this.getName(), signatureDate, null, fingerprint, null, false, false, trust, MessageFormat.format(SshdText.get().signUnknownHashAlgorithm, hashAlgorithm));
        }
        ByteArrayBuffer rawSignature = new ByteArrayBuffer(signature.getBytes());
        if (signature.available() > 0) {
            return new SignatureVerifier.SignatureVerification(this.getName(), signatureDate, null, fingerprint, null, false, false, trust, SshdText.get().signGarbageAtEnd);
        }
        switch (signatureAlgorithm = rawSignature.getString()) {
            case "ssh-dss": 
            case "ssh-rsa": 
            case "ssh-rsa-cert-v01@openssh.com": 
            case "ssh-dss-cert-v01@openssh.com": {
                return new SignatureVerifier.SignatureVerification(this.getName(), signatureDate, null, fingerprint, null, false, false, trust, MessageFormat.format(SshdText.get().signInvalidAlgorithm, signatureAlgorithm));
            }
        }
        String keyType = KeyUtils.getSignatureAlgorithm(KeyUtils.getKeyType(key2), key2);
        if (!KeyUtils.getCanonicalKeyType(keyType).equals(KeyUtils.getCanonicalKeyType(signatureAlgorithm))) {
            return new SignatureVerifier.SignatureVerification(this.getName(), signatureDate, null, fingerprint, null, false, false, trust, MessageFormat.format(SshdText.get().signMismatchedSignatureAlgorithm, keyType, signatureAlgorithm));
        }
        BuiltinSignatures factory2 = BuiltinSignatures.fromFactoryName(signatureAlgorithm);
        if (factory2 == null || !factory2.isSupported()) {
            return new SignatureVerifier.SignatureVerification(this.getName(), signatureDate, null, fingerprint, null, false, false, trust, MessageFormat.format(SshdText.get().signUnknownSignatureAlgorithm, signatureAlgorithm));
        }
        String message = null;
        try {
            PublicKey publicKey;
            Signature verifier = (Signature)factory2.create();
            if (key2 instanceof OpenSshCertificate) {
                OpenSshCertificate cert = (OpenSshCertificate)key2;
                publicKey = cert.getCertPubKey();
            } else {
                publicKey = key2;
            }
            verifier.initVerifier(null, publicKey);
            ByteArrayBuffer toSign = new ByteArrayBuffer();
            toSign.putRawBytes(SshSignatureConstants.MAGIC);
            toSign.putString("git");
            ((Buffer)toSign).putUInt(0L);
            toSign.putString(hashAlgorithm);
            toSign.putBytes(hash);
            verifier.update(null, toSign.getCompactData());
            valid = verifier.verify(null, rawSignature.getBytes());
        }
        catch (Exception e4) {
            LOG.warn("{}", (Object)SshdText.get().signLogFailure, (Object)e4);
            valid = false;
            message = SshdText.get().signSeeLog;
        }
        boolean expired = false;
        String principal = null;
        if (valid) {
            if (rawSignature.available() > 0) {
                valid = false;
                message = SshdText.get().signGarbageAtEnd;
            } else {
                SigningKeyDatabase database = SigningKeyDatabase.getInstance();
                if (database.isRevoked(repository, config2, key2)) {
                    valid = false;
                    if (key2 instanceof OpenSshCertificate) {
                        OpenSshCertificate certificate = (OpenSshCertificate)key2;
                        message = MessageFormat.format(SshdText.get().signCertificateRevoked, KeyUtils.getFingerPrint(certificate.getCaPubKey()));
                    } else {
                        message = SshdText.get().signKeyRevoked;
                    }
                } else {
                    try {
                        principal = database.isAllowed(repository, config2, key2, "git", gitIdentity);
                        if (!StringUtils.isEmptyOrNull(principal)) {
                            trust = SignatureVerifier.TrustLevel.FULL;
                        } else {
                            valid = false;
                            message = SshdText.get().signNoPrincipalMatched;
                            trust = SignatureVerifier.TrustLevel.UNKNOWN;
                        }
                    }
                    catch (VerificationException e5) {
                        valid = false;
                        message = e5.getMessage();
                        expired = e5.isExpired();
                    }
                    catch (IOException e6) {
                        LOG.warn("{}", (Object)SshdText.get().signLogFailure, (Object)e6);
                        valid = false;
                        message = SshdText.get().signSeeLog;
                    }
                }
            }
        }
        return new SignatureVerifier.SignatureVerification(this.getName(), signatureDate, null, fingerprint, principal, valid, expired, trust, message);
    }

    private static PersonIdent getGitIdentity(byte[] rawObject) {
        int i2 = RawParseUtils.match(rawObject, 0, TREE);
        if (i2 > 0) {
            i2 = RawParseUtils.committer(rawObject, 0);
            if (i2 < 0) {
                return null;
            }
            return RawParseUtils.parsePersonIdent(rawObject, i2);
        }
        i2 = RawParseUtils.match(rawObject, 0, OBJECT);
        if (i2 > 0) {
            i2 = RawParseUtils.nextLF(rawObject, i2);
            if ((i2 = RawParseUtils.match(rawObject, i2, TYPE)) > 0) {
                i2 = RawParseUtils.tagger(rawObject, 0);
                if (i2 < 0) {
                    return null;
                }
                return RawParseUtils.parsePersonIdent(rawObject, i2);
            }
        }
        return null;
    }

    private static byte[] dearmor(byte[] data2) {
        int end2;
        int start2 = RawParseUtils.match(data2, 0, SshSignatureConstants.ARMOR_HEAD);
        if (start2 > 0) {
            if (data2[start2] == 13) {
                ++start2;
            }
            if (data2[start2] == 10) {
                ++start2;
            }
        }
        if ((end2 = data2.length) > start2 + 1 && data2[end2 - 1] == 10 && --end2 > start2 + 1 && data2[end2 - 1] == 13) {
            --end2;
        }
        if ((end2 -= SshSignatureConstants.ARMOR_END.length) < 0 || end2 < start2 || RawParseUtils.match(data2, end2, SshSignatureConstants.ARMOR_END) < 0) {
            end2 = data2.length;
        }
        if (start2 < 0) {
            start2 = 0;
        }
        return Base64.decode(data2, start2, end2 - start2);
    }

    @Override
    public void clear() {
        SigningKeyDatabase database = SigningKeyDatabase.getInstance();
        if (database instanceof CachingSigningKeyDatabase) {
            CachingSigningKeyDatabase caching = (CachingSigningKeyDatabase)database;
            caching.clearCache();
        }
    }
}

