/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.commitgraph;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.commitgraph.CommitGraph;
import org.eclipse.jgit.internal.storage.commitgraph.CommitGraphBuilder;
import org.eclipse.jgit.internal.storage.commitgraph.CommitGraphFormatException;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.NB;
import org.eclipse.jgit.util.SystemReader;
import org.eclipse.jgit.util.io.SilentFileInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitGraphLoader {
    private static final Logger LOG = LoggerFactory.getLogger(CommitGraphLoader.class);

    public static CommitGraph open(File graphFile) throws FileNotFoundException, CommitGraphFormatException, IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (SilentFileInputStream fd = new SilentFileInputStream(graphFile);){
            return CommitGraphLoader.read(fd);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static CommitGraph read(InputStream fd) throws CommitGraphFormatException, IOException {
        boolean readChangedPathFilters;
        try {
            readChangedPathFilters = SystemReader.getInstance().getJGitConfig().getBoolean("commitGraph", "readChangedPaths", false);
        }
        catch (ConfigInvalidException e2) {
            readChangedPathFilters = false;
        }
        return CommitGraphLoader.read(fd, readChangedPathFilters);
    }

    public static CommitGraph read(InputStream fd, boolean readChangedPathFilters) throws CommitGraphFormatException, IOException {
        byte[] hdr = new byte[8];
        IO.readFully(fd, hdr, 0, hdr.length);
        int magic = NB.decodeInt32(hdr, 0);
        if (magic != 1128747080) {
            throw new CommitGraphFormatException(JGitText.get().notACommitGraph);
        }
        byte hashVersion = hdr[5];
        if (hashVersion != 1) {
            throw new CommitGraphFormatException(JGitText.get().incorrectOBJECT_ID_LENGTH);
        }
        byte v = hdr[4];
        if (v != 1) {
            throw new CommitGraphFormatException(MessageFormat.format(JGitText.get().unsupportedCommitGraphVersion, v));
        }
        int numberOfChunks = hdr[6];
        byte[] lookupBuffer = new byte[12 * (numberOfChunks + 1)];
        IO.readFully(fd, lookupBuffer, 0, lookupBuffer.length);
        ArrayList<ChunkSegment> chunks = new ArrayList<ChunkSegment>(numberOfChunks + 1);
        int i2 = 0;
        while (i2 <= numberOfChunks) {
            int id = NB.decodeInt32(lookupBuffer, i2 * 12);
            long offset = NB.decodeInt64(lookupBuffer, i2 * 12 + 4);
            chunks.add(new ChunkSegment(id, offset));
            ++i2;
        }
        CommitGraphBuilder builder = CommitGraphBuilder.builder();
        int i3 = 0;
        while (i3 < numberOfChunks) {
            long chunkOffset = ((ChunkSegment)chunks.get((int)i3)).offset;
            int chunkId = ((ChunkSegment)chunks.get((int)i3)).id;
            long len2 = ((ChunkSegment)chunks.get((int)(i3 + 1))).offset - chunkOffset;
            if (len2 > 0x7FFFFFF7L) {
                throw new CommitGraphFormatException(JGitText.get().commitGraphFileIsTooLargeForJgit);
            }
            byte[] buffer = new byte[(int)len2];
            IO.readFully(fd, buffer, 0, buffer.length);
            switch (chunkId) {
                case 1330201670: {
                    builder.addOidFanout(buffer);
                    break;
                }
                case 1330201676: {
                    builder.addOidLookUp(buffer);
                    break;
                }
                case 1128546644: {
                    builder.addCommitData(buffer);
                    break;
                }
                case 0x45444745: {
                    builder.addExtraList(buffer);
                    break;
                }
                case 1112097880: {
                    if (!readChangedPathFilters) break;
                    builder.addBloomFilterIndex(buffer);
                    break;
                }
                case 1111769428: {
                    if (!readChangedPathFilters) break;
                    builder.addBloomFilterData(buffer);
                    break;
                }
                default: {
                    LOG.warn(MessageFormat.format(JGitText.get().commitGraphChunkUnknown, Integer.toHexString(chunkId)));
                }
            }
            ++i3;
        }
        return builder.build();
    }

    private static class ChunkSegment {
        final int id;
        final long offset;

        private ChunkSegment(int id, long offset) {
            this.id = id;
            this.offset = offset;
        }
    }
}

