/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.commitgraph;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdOwnerMap;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.util.BlockList;

public class GraphCommits
implements Iterable<RevCommit> {
    private final List<RevCommit> sortedCommits;
    private final ObjectIdOwnerMap<CommitWithPosition> commitPosMap;
    private final int extraEdgeCnt;
    private final ObjectReader objectReader;

    /*
     * WARNING - void declaration
     */
    public static GraphCommits fromWalk(ProgressMonitor pm, @NonNull Set<? extends ObjectId> wants, @NonNull RevWalk walk) throws IOException {
        RevCommit c2;
        walk.reset();
        walk.sort(RevSort.NONE);
        walk.setRetainBody(false);
        for (ObjectId objectId : wants) {
            RevObject o = walk.parseAny(objectId);
            if (!(o instanceof RevCommit)) continue;
            walk.markStart((RevCommit)o);
        }
        BlockList<RevCommit> blockList = new BlockList<RevCommit>();
        pm.beginTask(JGitText.get().findingCommitsForCommitGraph, 0);
        while ((c2 = walk.next()) != null) {
            void c3;
            pm.update(1);
            blockList.add(c3);
        }
        pm.endTask();
        return new GraphCommits(blockList, walk.getObjectReader());
    }

    private GraphCommits(List<RevCommit> commits, ObjectReader objectReader) {
        Collections.sort(commits);
        this.sortedCommits = commits;
        this.commitPosMap = new ObjectIdOwnerMap();
        int cnt = 0;
        int i2 = 0;
        while (i2 < commits.size()) {
            RevCommit c2 = this.sortedCommits.get(i2);
            if (c2.getParentCount() > 2) {
                cnt += c2.getParentCount() - 1;
            }
            this.commitPosMap.add(new CommitWithPosition(c2, i2));
            ++i2;
        }
        this.extraEdgeCnt = cnt;
        this.objectReader = objectReader;
    }

    int getOidPosition(RevCommit c2) throws MissingObjectException {
        CommitWithPosition commitWithPosition = this.commitPosMap.get(c2);
        if (commitWithPosition == null) {
            throw new MissingObjectException((ObjectId)c2, 1);
        }
        return commitWithPosition.position;
    }

    int getExtraEdgeCnt() {
        return this.extraEdgeCnt;
    }

    int size() {
        return this.sortedCommits.size();
    }

    ObjectReader getObjectReader() {
        return this.objectReader;
    }

    @Override
    public Iterator<RevCommit> iterator() {
        return this.sortedCommits.iterator();
    }

    private static class CommitWithPosition
    extends ObjectIdOwnerMap.Entry {
        final int position;

        CommitWithPosition(AnyObjectId id, int position) {
            super(id);
            this.position = position;
        }
    }
}

