/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import org.eclipse.jgit.errors.PackInvalidException;
import org.eclipse.jgit.internal.storage.dfs.DfsBlock;
import org.eclipse.jgit.internal.storage.dfs.DfsBlockCache;
import org.eclipse.jgit.internal.storage.dfs.DfsPackDescription;
import org.eclipse.jgit.internal.storage.dfs.DfsReader;
import org.eclipse.jgit.internal.storage.dfs.DfsStreamKey;
import org.eclipse.jgit.internal.storage.dfs.DfsText;
import org.eclipse.jgit.internal.storage.dfs.ReadableChannel;
import org.eclipse.jgit.internal.storage.pack.PackExt;

abstract class BlockBasedFile {
    final DfsBlockCache cache;
    final DfsStreamKey key;
    final DfsPackDescription desc;
    final PackExt ext;
    volatile int blockSize;
    volatile long length;
    volatile boolean invalid;
    protected volatile Exception invalidatingCause;

    BlockBasedFile(DfsBlockCache cache2, DfsPackDescription desc, PackExt ext) {
        this.cache = cache2;
        this.key = desc.getStreamKey(ext);
        this.desc = desc;
        this.ext = ext;
    }

    String getFileName() {
        return this.desc.getFileName(this.ext);
    }

    boolean invalid() {
        return this.invalid;
    }

    void setInvalid() {
        this.invalid = true;
    }

    void setBlockSize(int newSize) {
        this.blockSize = newSize;
    }

    long alignToBlock(long pos) {
        int size2 = this.blockSize;
        if (size2 == 0) {
            size2 = this.cache.getBlockSize();
        }
        return pos / (long)size2 * (long)size2;
    }

    int blockSize(ReadableChannel rc2) {
        int size2 = this.blockSize;
        if (size2 == 0) {
            size2 = rc2.blockSize();
            if (size2 <= 0) {
                size2 = this.cache.getBlockSize();
            } else if (size2 < this.cache.getBlockSize()) {
                size2 = this.cache.getBlockSize() / size2 * size2;
            }
            this.blockSize = size2;
        }
        return size2;
    }

    DfsBlock getOrLoadBlock(long pos, DfsReader ctx) throws IOException {
        Throwable throwable = null;
        Object var5_5 = null;
        try (LazyChannel c2 = new LazyChannel(ctx, this.desc, this.ext);){
            DfsBlock block2 = this.cache.getOrLoad(this, pos, ctx, c2);
            ctx.emitBlockLoad(this, pos, block2);
            return block2;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    DfsBlock readOneBlock(long pos, DfsReader ctx, ReadableChannel rc2) throws IOException {
        if (this.invalid) {
            throw new PackInvalidException(this.getFileName(), (Throwable)this.invalidatingCause);
        }
        ++ctx.stats.readBlock;
        long start2 = System.nanoTime();
        try {
            int size2 = this.blockSize(rc2);
            pos = pos / (long)size2 * (long)size2;
            long len2 = this.length;
            if (len2 < 0L && 0L <= (len2 = rc2.size())) {
                this.length = len2;
            }
            if (0L <= len2 && len2 < pos + (long)size2) {
                size2 = (int)(len2 - pos);
            }
            if (size2 <= 0) {
                throw new EOFException(MessageFormat.format(DfsText.get().shortReadOfBlock, pos, this.getFileName(), 0L, 0L));
            }
            byte[] buf = new byte[size2];
            rc2.position(pos);
            int cnt = BlockBasedFile.read(rc2, ByteBuffer.wrap(buf, 0, size2));
            ctx.stats.readBlockBytes += (long)cnt;
            if (cnt != size2) {
                if (0L <= len2) {
                    throw new EOFException(MessageFormat.format(DfsText.get().shortReadOfBlock, pos, this.getFileName(), size2, cnt));
                }
                byte[] n = new byte[cnt];
                System.arraycopy(buf, 0, n, 0, n.length);
                buf = n;
            } else if (len2 < 0L) {
                this.length = len2 = rc2.size();
            }
            DfsBlock dfsBlock = new DfsBlock(this.key, pos, buf);
            return dfsBlock;
        }
        finally {
            ctx.stats.readBlockMicros += BlockBasedFile.elapsedMicros(start2);
        }
    }

    static int read(ReadableChannel rc2, ByteBuffer buf) throws IOException {
        int n;
        while ((n = rc2.read(buf)) > 0 && buf.hasRemaining()) {
        }
        return buf.position();
    }

    static long elapsedMicros(long start2) {
        return (System.nanoTime() - start2) / 1000L;
    }

    private static class LazyChannel
    implements AutoCloseable,
    DfsBlockCache.ReadableChannelSupplier {
        private final DfsReader ctx;
        private final DfsPackDescription desc;
        private final PackExt ext;
        private ReadableChannel rc;

        LazyChannel(DfsReader ctx, DfsPackDescription desc, PackExt ext) {
            this.ctx = ctx;
            this.desc = desc;
            this.ext = ext;
        }

        @Override
        public ReadableChannel get() throws IOException {
            if (this.rc == null) {
                this.rc = this.ctx.db.openFile(this.desc, this.ext);
            }
            return this.rc;
        }

        @Override
        public void close() throws IOException {
            if (this.rc != null) {
                this.rc.close();
            }
        }
    }
}

