/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import org.eclipse.jgit.internal.storage.dfs.DfsReader;
import org.eclipse.jgit.internal.storage.dfs.DfsStreamKey;

final class DeltaBaseCache {
    private static final int TABLE_BITS = 10;
    private static final int MASK_BITS = 22;
    private int maxByteCount;
    private int curByteCount;
    private final Entry[] table;
    private Entry lruHead;
    private Entry lruTail;

    private static int hash(long position) {
        return (int)position << 22 >>> 22;
    }

    DeltaBaseCache(DfsReader reader2) {
        this(reader2.getOptions().getDeltaBaseCacheLimit());
    }

    DeltaBaseCache(int maxBytes) {
        this.maxByteCount = maxBytes;
        this.table = new Entry[1024];
    }

    Entry get(DfsStreamKey key2, long position) {
        Entry e2 = this.table[DeltaBaseCache.hash(position)];
        while (e2 != null) {
            if (e2.offset == position && key2.equals(e2.pack)) {
                this.moveToHead(e2);
                return e2;
            }
            e2 = e2.tableNext;
        }
        return null;
    }

    void put(DfsStreamKey key2, long offset, int objectType, byte[] data2) {
        if (data2.length > this.maxByteCount) {
            return;
        }
        this.curByteCount += data2.length;
        this.releaseMemory();
        int tableIdx = DeltaBaseCache.hash(offset);
        Entry e2 = new Entry(key2, offset, objectType, data2);
        e2.tableNext = this.table[tableIdx];
        this.table[tableIdx] = e2;
        this.lruPushHead(e2);
    }

    private void releaseMemory() {
        while (this.curByteCount > this.maxByteCount && this.lruTail != null) {
            Entry e2 = this.lruTail;
            this.curByteCount -= e2.data.length;
            this.lruRemove(e2);
            this.removeFromTable(e2);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void removeFromTable(Entry e) {
        tableIdx = DeltaBaseCache.hash(e.offset);
        p = this.table[tableIdx];
        if (p != e) ** GOTO lbl10
        this.table[tableIdx] = e.tableNext;
        return;
lbl-1000:
        // 1 sources

        {
            if (p.tableNext == e) {
                p.tableNext = e.tableNext;
                return;
            }
            p = p.tableNext;
lbl10:
            // 2 sources

            ** while (p != null)
        }
lbl11:
        // 1 sources

        throw new IllegalStateException(String.format("entry for %s:%d not in table", new Object[]{e.pack, e.offset}));
    }

    private void moveToHead(Entry e2) {
        if (e2 != this.lruHead) {
            this.lruRemove(e2);
            this.lruPushHead(e2);
        }
    }

    private void lruRemove(Entry e2) {
        Entry p = e2.lruPrev;
        Entry n = e2.lruNext;
        if (p != null) {
            p.lruNext = n;
        } else {
            this.lruHead = n;
        }
        if (n != null) {
            n.lruPrev = p;
        } else {
            this.lruTail = p;
        }
    }

    private void lruPushHead(Entry e2) {
        Entry n;
        e2.lruNext = n = this.lruHead;
        if (n != null) {
            n.lruPrev = e2;
        } else {
            this.lruTail = e2;
        }
        e2.lruPrev = null;
        this.lruHead = e2;
    }

    int getMemoryUsed() {
        return this.curByteCount;
    }

    int getMemoryUsedByLruChainForTest() {
        int r = 0;
        Entry e2 = this.lruHead;
        while (e2 != null) {
            r += e2.data.length;
            e2 = e2.lruNext;
        }
        return r;
    }

    int getMemoryUsedByTableForTest() {
        int r = 0;
        Entry[] entryArray = this.table;
        int n = this.table.length;
        int n2 = 0;
        while (n2 < n) {
            Entry t2;
            Entry e2 = t2 = entryArray[n2];
            while (e2 != null) {
                r += e2.data.length;
                e2 = e2.tableNext;
            }
            ++n2;
        }
        return r;
    }

    static class Entry {
        final DfsStreamKey pack;
        final long offset;
        final int type;
        final byte[] data;
        Entry tableNext;
        Entry lruPrev;
        Entry lruNext;

        Entry(DfsStreamKey key2, long offset, int type2, byte[] data2) {
            this.pack = key2;
            this.offset = offset;
            this.type = type2;
            this.data = data2;
        }
    }
}

