/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.PrintWriter;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.lib.Config;

public class DfsBlockCacheConfig {
    public static final int KB = 1024;
    public static final int MB = 0x100000;
    public static final int DEFAULT_CACHE_HOT_MAX = 1;
    static final String DEFAULT_NAME = "<default>";
    private String name = "<default>";
    private long blockLimit;
    private int blockSize;
    private double streamRatio;
    private int concurrencyLevel;
    private Consumer<Long> refLock;
    private Map<PackExt, Integer> cacheHotMap;
    private IndexEventConsumer indexEventConsumer;
    private List<DfsBlockCachePackExtConfig> packExtCacheConfigurations;

    public DfsBlockCacheConfig() {
        this.setBlockLimit(0x2000000L);
        this.setBlockSize(65536);
        this.setStreamRatio(0.3);
        this.setConcurrencyLevel(32);
        this.cacheHotMap = Collections.emptyMap();
        this.packExtCacheConfigurations = Collections.emptyList();
    }

    public void print(PrintWriter writer) {
        this.print("", "  ", writer);
    }

    private void print(String linePrefix, String pad, PrintWriter writer) {
        Object currentPrefixLevel = linePrefix;
        if (!this.name.isEmpty() || !this.packExtCacheConfigurations.isEmpty()) {
            writer.println(linePrefix + "Name: " + (this.name.isEmpty() ? DEFAULT_NAME : this.name));
            currentPrefixLevel = (String)currentPrefixLevel + pad;
        }
        writer.println((String)currentPrefixLevel + "BlockLimit: " + this.blockLimit);
        writer.println((String)currentPrefixLevel + "BlockSize: " + this.blockSize);
        writer.println((String)currentPrefixLevel + "StreamRatio: " + this.streamRatio);
        writer.println((String)currentPrefixLevel + "ConcurrencyLevel: " + this.concurrencyLevel);
        for (Map.Entry<PackExt, Integer> entry : this.cacheHotMap.entrySet()) {
            writer.println((String)currentPrefixLevel + "CacheHotMapEntry: " + String.valueOf((Object)entry.getKey()) + " : " + String.valueOf(entry.getValue()));
        }
        for (DfsBlockCachePackExtConfig extConfig : this.packExtCacheConfigurations) {
            extConfig.print((String)currentPrefixLevel, pad, writer);
        }
    }

    public String getName() {
        return this.name;
    }

    DfsBlockCacheConfig setName(String name) {
        this.name = name;
        return this;
    }

    public long getBlockLimit() {
        return this.blockLimit;
    }

    public DfsBlockCacheConfig setBlockLimit(long newLimit) {
        if (newLimit <= 0L) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().blockLimitNotPositive, newLimit));
        }
        this.blockLimit = newLimit;
        return this;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public DfsBlockCacheConfig setBlockSize(int newSize) {
        int size2 = Math.max(512, newSize);
        if ((size2 & size2 - 1) != 0) {
            throw new IllegalArgumentException(JGitText.get().blockSizeNotPowerOf2);
        }
        this.blockSize = size2;
        return this;
    }

    public int getConcurrencyLevel() {
        return this.concurrencyLevel;
    }

    public DfsBlockCacheConfig setConcurrencyLevel(int newConcurrencyLevel) {
        this.concurrencyLevel = newConcurrencyLevel;
        return this;
    }

    public double getStreamRatio() {
        return this.streamRatio;
    }

    public DfsBlockCacheConfig setStreamRatio(double ratio) {
        this.streamRatio = Math.max(0.0, Math.min(ratio, 1.0));
        return this;
    }

    public Consumer<Long> getRefLockWaitTimeConsumer() {
        return this.refLock;
    }

    public DfsBlockCacheConfig setRefLockWaitTimeConsumer(Consumer<Long> c2) {
        this.refLock = c2;
        return this;
    }

    public Map<PackExt, Integer> getCacheHotMap() {
        return this.cacheHotMap;
    }

    public DfsBlockCacheConfig setCacheHotMap(Map<PackExt, Integer> cacheHotMap) {
        this.cacheHotMap = Collections.unmodifiableMap(cacheHotMap);
        this.setCacheHotMapToPackExtConfigs(this.cacheHotMap);
        return this;
    }

    private void setCacheHotMapToPackExtConfigs(Map<PackExt, Integer> cacheHotMap) {
        for (DfsBlockCachePackExtConfig packExtConfig : this.packExtCacheConfigurations) {
            packExtConfig.setCacheHotMap(cacheHotMap);
        }
    }

    public IndexEventConsumer getIndexEventConsumer() {
        return this.indexEventConsumer;
    }

    public DfsBlockCacheConfig setIndexEventConsumer(IndexEventConsumer indexEventConsumer) {
        this.indexEventConsumer = indexEventConsumer;
        return this;
    }

    List<DfsBlockCachePackExtConfig> getPackExtCacheConfigurations() {
        return this.packExtCacheConfigurations;
    }

    DfsBlockCacheConfig setPackExtCacheConfigurations(List<DfsBlockCachePackExtConfig> packExtCacheConfigurations) {
        this.packExtCacheConfigurations = packExtCacheConfigurations;
        return this;
    }

    public DfsBlockCacheConfig fromConfig(Config rc2) {
        this.fromConfig("core", "dfs", rc2);
        this.loadPackExtConfigs(rc2);
        return this;
    }

    private void fromConfig(String section, String subSection, Config rc2) {
        int cfgBlockSize;
        long cfgBlockLimit = rc2.getLong(section, subSection, "blockLimit", this.getBlockLimit());
        if (cfgBlockLimit % (long)(cfgBlockSize = rc2.getInt(section, subSection, "blockSize", this.getBlockSize())) != 0L) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().blockLimitNotMultipleOfBlockSize, cfgBlockLimit, cfgBlockSize));
        }
        if (rc2.getSubsections(section).contains(subSection)) {
            this.name = subSection;
        }
        this.setBlockLimit(cfgBlockLimit);
        this.setBlockSize(cfgBlockSize);
        this.setConcurrencyLevel(rc2.getInt(section, subSection, "concurrencyLevel", this.getConcurrencyLevel()));
        String v = rc2.getString(section, subSection, "streamRatio");
        if (v != null) {
            try {
                this.setStreamRatio(Double.parseDouble(v));
            }
            catch (NumberFormatException e2) {
                throw new IllegalArgumentException(MessageFormat.format(JGitText.get().enumValueNotSupported3, section, subSection, "streamRatio", v), e2);
            }
        }
    }

    private void loadPackExtConfigs(Config config2) {
        List subSections = config2.getSubsections("core").stream().filter(section -> section.startsWith("dfs.")).collect(Collectors.toList());
        if (subSections.size() == 0) {
            return;
        }
        ArrayList<DfsBlockCachePackExtConfig> cacheConfigs = new ArrayList<DfsBlockCachePackExtConfig>();
        HashSet<PackExt> extensionsSeen = new HashSet<PackExt>();
        for (String subSection : subSections) {
            DfsBlockCachePackExtConfig cacheConfig = DfsBlockCachePackExtConfig.fromConfig(config2, "core", subSection);
            Set<PackExt> packExtsDuplicates = DfsBlockCacheConfig.intersection(extensionsSeen, cacheConfig.packExts);
            if (packExtsDuplicates.size() > 0) {
                String duplicatePackExts = packExtsDuplicates.stream().map(PackExt::toString).collect(Collectors.joining(","));
                throw new IllegalArgumentException(MessageFormat.format(JGitText.get().duplicatePackExtensionsSet, "core", subSection, "packExtensions", duplicatePackExts));
            }
            extensionsSeen.addAll(cacheConfig.packExts);
            cacheConfigs.add(cacheConfig);
        }
        this.packExtCacheConfigurations = cacheConfigs;
        this.setCacheHotMapToPackExtConfigs(this.cacheHotMap);
    }

    private static <T> Set<T> intersection(Set<T> first2, Set<T> second2) {
        HashSet<T> ret = new HashSet<T>();
        for (T entry : second2) {
            if (!first2.contains(entry)) continue;
            ret.add(entry);
        }
        return ret;
    }

    static class DfsBlockCachePackExtConfig {
        private final EnumSet<PackExt> packExts;
        private final DfsBlockCacheConfig packExtCacheConfiguration;

        DfsBlockCachePackExtConfig(EnumSet<PackExt> packExts, DfsBlockCacheConfig packExtCacheConfiguration) {
            this.packExts = packExts;
            this.packExtCacheConfiguration = packExtCacheConfiguration;
        }

        Set<PackExt> getPackExts() {
            return this.packExts;
        }

        DfsBlockCacheConfig getPackExtCacheConfiguration() {
            return this.packExtCacheConfiguration;
        }

        void setCacheHotMap(Map<PackExt, Integer> cacheHotMap) {
            Map<PackExt, Integer> packExtHotMap = this.packExts.stream().filter(cacheHotMap::containsKey).collect(Collectors.toUnmodifiableMap(Function.identity(), cacheHotMap::get));
            this.packExtCacheConfiguration.setCacheHotMap(packExtHotMap);
        }

        private static DfsBlockCachePackExtConfig fromConfig(Config config2, String section, String subSection) {
            String packExtensions = config2.getString(section, subSection, "packExtensions");
            if (packExtensions == null) {
                throw new IllegalArgumentException(JGitText.get().noPackExtGivenForConfiguration);
            }
            String[] extensions = packExtensions.split(" ", -1);
            HashSet<PackExt> packExts = new HashSet<PackExt>(extensions.length);
            String[] stringArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                String extension = stringArray[n2];
                try {
                    packExts.add(PackExt.valueOf(extension));
                }
                catch (IllegalArgumentException e2) {
                    throw new IllegalArgumentException(MessageFormat.format(JGitText.get().unknownPackExtension, section, subSection, "packExtensions", extension), e2);
                }
                ++n2;
            }
            DfsBlockCacheConfig dfsBlockCacheConfig = new DfsBlockCacheConfig();
            dfsBlockCacheConfig.fromConfig(section, subSection, config2);
            return new DfsBlockCachePackExtConfig(EnumSet.copyOf(packExts), dfsBlockCacheConfig);
        }

        void print(String linePrefix, String pad, PrintWriter writer) {
            this.packExtCacheConfiguration.print(linePrefix, pad, writer);
            writer.println(linePrefix + pad + "PackExts: " + String.valueOf(this.packExts.stream().sorted().collect(Collectors.toList())));
        }
    }

    public static interface IndexEventConsumer {
        public void acceptRequestedEvent(int var1, boolean var2, long var3, long var5, Duration var7);

        default public void acceptEvictedEvent(int packExtPos, long bytes, int totalCacheHitCount, Duration lastEvictionDuration) {
        }

        default public boolean shouldReportEvictedEvent() {
            return false;
        }
    }
}

