/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jgit.internal.storage.dfs.DfsBlockCacheTable;
import org.eclipse.jgit.internal.storage.dfs.DfsStreamKey;
import org.eclipse.jgit.internal.storage.pack.PackExt;

class DfsBlockCacheStats
implements DfsBlockCacheTable.BlockCacheStats {
    private final String name;
    private final AtomicReference<AtomicLong[]> statHit;
    private final AtomicReference<AtomicLong[]> statMiss;
    private final AtomicReference<AtomicLong[]> statEvict;
    private final AtomicReference<AtomicLong[]> liveBytes;

    DfsBlockCacheStats() {
        this("");
    }

    DfsBlockCacheStats(String name) {
        this.name = name;
        this.statHit = new AtomicReference<AtomicLong[]>(DfsBlockCacheStats.newCounters());
        this.statMiss = new AtomicReference<AtomicLong[]>(DfsBlockCacheStats.newCounters());
        this.statEvict = new AtomicReference<AtomicLong[]>(DfsBlockCacheStats.newCounters());
        this.liveBytes = new AtomicReference<AtomicLong[]>(DfsBlockCacheStats.newCounters());
    }

    @Override
    public String getName() {
        return this.name;
    }

    void incrementHit(DfsStreamKey key2) {
        DfsBlockCacheStats.getStat(this.statHit, key2).incrementAndGet();
    }

    void incrementMiss(DfsStreamKey key2) {
        DfsBlockCacheStats.getStat(this.statMiss, key2).incrementAndGet();
    }

    void incrementEvict(DfsStreamKey key2) {
        DfsBlockCacheStats.getStat(this.statEvict, key2).incrementAndGet();
    }

    void addToLiveBytes(DfsStreamKey key2, long size2) {
        DfsBlockCacheStats.getStat(this.liveBytes, key2).addAndGet(size2);
    }

    @Override
    public long[] getCurrentSize() {
        return DfsBlockCacheStats.getStatVals(this.liveBytes);
    }

    @Override
    public long[] getHitCount() {
        return DfsBlockCacheStats.getStatVals(this.statHit);
    }

    @Override
    public long[] getMissCount() {
        return DfsBlockCacheStats.getStatVals(this.statMiss);
    }

    @Override
    public long[] getTotalRequestCount() {
        AtomicLong[] hit = this.statHit.get();
        AtomicLong[] miss = this.statMiss.get();
        long[] cnt = new long[Math.max(hit.length, miss.length)];
        int i2 = 0;
        while (i2 < hit.length) {
            int n = i2;
            cnt[n] = cnt[n] + hit[i2].get();
            ++i2;
        }
        i2 = 0;
        while (i2 < miss.length) {
            int n = i2;
            cnt[n] = cnt[n] + miss[i2].get();
            ++i2;
        }
        return cnt;
    }

    @Override
    public long[] getHitRatio() {
        AtomicLong[] hit = this.statHit.get();
        AtomicLong[] miss = this.statMiss.get();
        long[] ratio = new long[Math.max(hit.length, miss.length)];
        int i2 = 0;
        while (i2 < ratio.length) {
            long missVal;
            long hitVal;
            long total;
            ratio[i2] = i2 >= hit.length ? 0L : (i2 >= miss.length ? 100L : ((total = (hitVal = hit[i2].get()) + (missVal = miss[i2].get())) == 0L ? 0L : hitVal * 100L / total));
            ++i2;
        }
        return ratio;
    }

    @Override
    public long[] getEvictions() {
        return DfsBlockCacheStats.getStatVals(this.statEvict);
    }

    private static AtomicLong[] newCounters() {
        AtomicLong[] ret = new AtomicLong[PackExt.values().length];
        int i2 = 0;
        while (i2 < ret.length) {
            ret[i2] = new AtomicLong();
            ++i2;
        }
        return ret;
    }

    private static long[] getStatVals(AtomicReference<AtomicLong[]> stat) {
        AtomicLong[] stats = stat.get();
        long[] cnt = new long[stats.length];
        int i2 = 0;
        while (i2 < stats.length) {
            cnt[i2] = stats[i2].get();
            ++i2;
        }
        return cnt;
    }

    private static AtomicLong getStat(AtomicReference<AtomicLong[]> stats, DfsStreamKey key2) {
        AtomicLong[] vals;
        AtomicLong[] expect;
        int pos = key2.packExtPos;
        do {
            if (pos < (vals = stats.get()).length) {
                return vals[pos];
            }
            expect = vals;
            vals = new AtomicLong[Math.max(pos + 1, PackExt.values().length)];
            System.arraycopy(expect, 0, vals, 0, expect.length);
            int i2 = expect.length;
            while (i2 < vals.length) {
                vals[i2] = new AtomicLong();
                ++i2;
            }
        } while (!stats.compareAndSet(expect, vals));
        return vals[pos];
    }
}

