/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.eclipse.jgit.errors.CorruptPackIndexException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.fsck.FsckError;
import org.eclipse.jgit.internal.fsck.FsckPackParser;
import org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase;
import org.eclipse.jgit.internal.storage.dfs.DfsPackDescription;
import org.eclipse.jgit.internal.storage.dfs.DfsPackFile;
import org.eclipse.jgit.internal.storage.dfs.DfsReader;
import org.eclipse.jgit.internal.storage.dfs.DfsRepository;
import org.eclipse.jgit.internal.storage.dfs.ReadableChannel;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.internal.submodule.SubmoduleValidator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.GitmoduleEntry;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectChecker;
import org.eclipse.jgit.lib.ObjectDatabase;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.RevObject;

public class DfsFsck {
    private final DfsRepository repo;
    private final DfsObjDatabase objdb;
    private ObjectChecker objChecker = new ObjectChecker();
    private boolean connectivityOnly;

    public DfsFsck(DfsRepository repository) {
        this.repo = repository;
        this.objdb = this.repo.getObjectDatabase();
    }

    public FsckError check(ProgressMonitor pm) throws IOException {
        if (pm == null) {
            pm = NullProgressMonitor.INSTANCE;
        }
        FsckError errors2 = new FsckError();
        if (!this.connectivityOnly) {
            this.objChecker.reset();
            this.checkPacks(pm, errors2);
        }
        this.checkConnectivity(pm, errors2);
        return errors2;
    }

    private void checkPacks(ProgressMonitor pm, FsckError errors2) throws IOException, FileNotFoundException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (DfsReader ctx = this.objdb.newReader();){
            DfsPackFile[] dfsPackFileArray = this.objdb.getPacks();
            int n = dfsPackFileArray.length;
            int n2 = 0;
            while (n2 < n) {
                DfsPackFile pack2 = dfsPackFileArray[n2];
                DfsPackDescription packDesc = pack2.getPackDescription();
                if (packDesc.getPackSource() != DfsObjDatabase.PackSource.UNREACHABLE_GARBAGE) {
                    try {
                        Throwable throwable2 = null;
                        Object var12_17 = null;
                        try (ReadableChannel rc2 = this.objdb.openFile(packDesc, PackExt.PACK);){
                            this.verifyPack(pm, errors2, ctx, pack2, rc2);
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    catch (MissingObjectException e2) {
                        errors2.getMissingObjects().add(e2.getObjectId());
                    }
                    catch (CorruptPackIndexException e3) {
                        errors2.getCorruptIndices().add(new FsckError.CorruptIndex(pack2.getPackDescription().getFileName(PackExt.INDEX), e3.getErrorType()));
                    }
                }
                ++n2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        this.checkGitModules(pm, errors2);
    }

    private void verifyPack(ProgressMonitor pm, FsckError errors2, DfsReader ctx, DfsPackFile pack2, ReadableChannel ch) throws IOException, CorruptPackIndexException {
        FsckPackParser fpp = new FsckPackParser((ObjectDatabase)this.objdb, ch);
        fpp.setObjectChecker(this.objChecker);
        fpp.overwriteObjectCount(pack2.getPackDescription().getObjectCount());
        fpp.parse(pm);
        errors2.getCorruptObjects().addAll(fpp.getCorruptObjects());
        fpp.verifyIndex(pack2.getPackIndex(ctx));
    }

    private void checkGitModules(ProgressMonitor pm, FsckError errors2) throws IOException {
        pm.beginTask(JGitText.get().validatingGitModules, this.objChecker.getGitsubmodules().size());
        for (GitmoduleEntry entry : this.objChecker.getGitsubmodules()) {
            AnyObjectId blobId = entry.getBlobId();
            ObjectLoader blob = this.objdb.open(blobId, 3);
            try {
                SubmoduleValidator.assertValidGitModulesFile(new String(blob.getBytes(), StandardCharsets.UTF_8));
            }
            catch (SubmoduleValidator.SubmoduleValidationException e2) {
                FsckError.CorruptObject co = new FsckError.CorruptObject(blobId.toObjectId(), 3, e2.getFsckMessageId());
                errors2.getCorruptObjects().add(co);
            }
            pm.update(1);
        }
        pm.endTask();
    }

    private void checkConnectivity(ProgressMonitor pm, FsckError errors2) throws IOException {
        pm.beginTask(JGitText.get().countingObjects, 0);
        Throwable throwable = null;
        Object var4_5 = null;
        try (ObjectWalk ow = new ObjectWalk(this.repo);){
            for (Ref r : this.repo.getRefDatabase().getRefs()) {
                ObjectId objectId = r.getObjectId();
                if (objectId == null) continue;
                try {
                    RevObject tip = ow.parseAny(objectId);
                    if (r.getLeaf().getName().startsWith("refs/heads/") && tip.getType() != 1) {
                        errors2.getNonCommitHeads().add(r.getLeaf().getName());
                    }
                    ow.markStart(tip);
                }
                catch (MissingObjectException e2) {
                    errors2.getMissingObjects().add(e2.getObjectId());
                }
            }
            try {
                ow.checkConnectivity();
            }
            catch (MissingObjectException e3) {
                errors2.getMissingObjects().add(e3.getObjectId());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        pm.endTask();
    }

    public void setObjectChecker(ObjectChecker objChecker) {
        this.objChecker = objChecker;
    }

    public void setConnectivityOnly(boolean connectivityOnly) {
        this.connectivityOnly = connectivityOnly;
    }
}

