/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.dfs.BlockBasedFile;
import org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase;
import org.eclipse.jgit.internal.storage.dfs.DfsObjectRepresentation;
import org.eclipse.jgit.internal.storage.dfs.DfsOutputStream;
import org.eclipse.jgit.internal.storage.dfs.DfsPackDescription;
import org.eclipse.jgit.internal.storage.dfs.DfsPackFile;
import org.eclipse.jgit.internal.storage.dfs.DfsReader;
import org.eclipse.jgit.internal.storage.dfs.DfsReftable;
import org.eclipse.jgit.internal.storage.dfs.DfsReftableStack;
import org.eclipse.jgit.internal.storage.dfs.DfsRepository;
import org.eclipse.jgit.internal.storage.file.PackIndex;
import org.eclipse.jgit.internal.storage.file.PackReverseIndex;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.internal.storage.pack.PackWriter;
import org.eclipse.jgit.internal.storage.reftable.ReftableCompactor;
import org.eclipse.jgit.internal.storage.reftable.ReftableConfig;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdSet;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.pack.PackConfig;
import org.eclipse.jgit.storage.pack.PackStatistics;
import org.eclipse.jgit.util.BlockList;
import org.eclipse.jgit.util.io.CountingOutputStream;

public class DfsPackCompactor {
    private final DfsRepository repo;
    private final List<DfsPackFile> srcPacks;
    private final List<DfsReftable> srcReftables;
    private final List<ObjectIdSet> exclude;
    private PackStatistics newStats;
    private DfsPackDescription outDesc;
    private int autoAddSize;
    private ReftableConfig reftableConfig;
    private RevWalk rw;
    private RevFlag added;
    private RevFlag isBase;

    public DfsPackCompactor(DfsRepository repository) {
        this.repo = repository;
        this.autoAddSize = 0x500000;
        this.srcPacks = new ArrayList<DfsPackFile>();
        this.srcReftables = new ArrayList<DfsReftable>();
        this.exclude = new ArrayList<ObjectIdSet>(4);
    }

    public DfsPackCompactor setReftableConfig(ReftableConfig cfg) {
        this.reftableConfig = cfg;
        return this;
    }

    public DfsPackCompactor add(DfsPackFile pack2) {
        this.srcPacks.add(pack2);
        return this;
    }

    public DfsPackCompactor add(DfsReftable table) {
        this.srcReftables.add(table);
        return this;
    }

    public DfsPackCompactor autoAdd() throws IOException {
        DfsPackDescription d2;
        DfsObjDatabase objdb = this.repo.getObjectDatabase();
        BlockBasedFile[] blockBasedFileArray = objdb.getPacks();
        int n = blockBasedFileArray.length;
        int n2 = 0;
        while (n2 < n) {
            DfsPackFile pack2 = blockBasedFileArray[n2];
            d2 = pack2.getPackDescription();
            if (d2.getFileSize(PackExt.PACK) < (long)this.autoAddSize) {
                this.add(pack2);
            } else {
                this.exclude(pack2);
            }
            ++n2;
        }
        if (this.reftableConfig != null) {
            blockBasedFileArray = objdb.getReftables();
            n = blockBasedFileArray.length;
            n2 = 0;
            while (n2 < n) {
                BlockBasedFile table = blockBasedFileArray[n2];
                d2 = ((DfsReftable)table).getPackDescription();
                if (d2.getPackSource() != DfsObjDatabase.PackSource.GC && d2.getFileSize(PackExt.REFTABLE) < (long)this.autoAddSize) {
                    this.add((DfsReftable)table);
                }
                ++n2;
            }
        }
        return this;
    }

    public DfsPackCompactor exclude(ObjectIdSet set2) {
        this.exclude.add(set2);
        return this;
    }

    public DfsPackCompactor exclude(DfsPackFile pack2) throws IOException {
        PackIndex idx;
        Throwable throwable = null;
        Object var4_4 = null;
        try (DfsReader ctx = (DfsReader)this.repo.newObjectReader();){
            idx = pack2.getPackIndex(ctx);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return this.exclude(idx);
    }

    public void compact(ProgressMonitor pm) throws IOException {
        if (pm == null) {
            pm = NullProgressMonitor.INSTANCE;
        }
        DfsObjDatabase objdb = this.repo.getObjectDatabase();
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (DfsReader ctx = objdb.newReader();){
                if (this.reftableConfig != null && !this.srcReftables.isEmpty()) {
                    this.compactReftables(ctx);
                }
                this.compactPacks(ctx, pm);
                List<DfsPackDescription> commit = this.getNewPacks();
                Collection<DfsPackDescription> remove2 = this.toPrune();
                if (!commit.isEmpty() || !remove2.isEmpty()) {
                    objdb.commitPack(commit, remove2);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            this.rw = null;
        }
    }

    private void compactPacks(DfsReader ctx, ProgressMonitor pm) throws IOException, IncorrectObjectTypeException {
        DfsObjDatabase objdb = this.repo.getObjectDatabase();
        PackConfig pc = new PackConfig(this.repo);
        pc.setIndexVersion(2);
        pc.setDeltaCompress(false);
        pc.setReuseDeltas(true);
        pc.setReuseObjects(true);
        Throwable throwable = null;
        Object var6_7 = null;
        try (PackWriter pw = new PackWriter(pc, (ObjectReader)ctx);){
            pw.setDeltaBaseAsOffset(true);
            pw.setReuseDeltaCommits(false);
            this.addObjectsToPack(pw, ctx, pm);
            if (pw.getObjectCount() == 0L) {
                return;
            }
            boolean rollback = true;
            this.initOutDesc(objdb);
            try {
                DfsPackCompactor.writePack(objdb, this.outDesc, pw, pm);
                DfsPackCompactor.writeIndex(objdb, this.outDesc, pw);
                DfsPackCompactor.writeObjectSizeIndex(objdb, this.outDesc, pw);
                PackStatistics stats = pw.getStatistics();
                this.outDesc.setPackStats(stats);
                this.newStats = stats;
                rollback = false;
            }
            finally {
                if (rollback) {
                    objdb.rollbackPack(Collections.singletonList(this.outDesc));
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private long estimatePackSize() {
        long size2 = 32L;
        for (DfsPackFile pack2 : this.srcPacks) {
            size2 += pack2.getPackDescription().getFileSize(PackExt.PACK) - 32L;
        }
        return size2;
    }

    private void compactReftables(DfsReader ctx) throws IOException {
        DfsObjDatabase objdb = this.repo.getObjectDatabase();
        Collections.sort(this.srcReftables, objdb.reftableComparator());
        this.initOutDesc(objdb);
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            DfsReftableStack stack = DfsReftableStack.open(ctx, this.srcReftables);
            try {
                try (DfsOutputStream out2 = objdb.writeFile(this.outDesc, PackExt.REFTABLE);){
                    ReftableCompactor compact = new ReftableCompactor(out2);
                    compact.addAll(stack.readers());
                    compact.setIncludeDeletes(true);
                    compact.setConfig(DfsPackCompactor.configureReftable(this.reftableConfig, out2));
                    compact.compact();
                    this.outDesc.addFileExt(PackExt.REFTABLE);
                    this.outDesc.setReftableStats(compact.getStats());
                }
                if (stack != null) {
                    stack.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (stack != null) {
                    stack.close();
                }
                throw throwable;
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private void initOutDesc(DfsObjDatabase objdb) throws IOException {
        if (this.outDesc == null) {
            this.outDesc = objdb.newPack(DfsObjDatabase.PackSource.COMPACT, this.estimatePackSize());
        }
    }

    public Collection<DfsPackDescription> getSourcePacks() {
        HashSet<DfsPackDescription> src = new HashSet<DfsPackDescription>();
        for (DfsPackFile pack2 : this.srcPacks) {
            src.add(pack2.getPackDescription());
        }
        for (DfsReftable table : this.srcReftables) {
            src.add(table.getPackDescription());
        }
        return src;
    }

    public List<DfsPackDescription> getNewPacks() {
        return this.outDesc != null ? Collections.singletonList(this.outDesc) : Collections.emptyList();
    }

    public List<PackStatistics> getNewPackStatistics() {
        return this.outDesc != null ? Collections.singletonList(this.newStats) : Collections.emptyList();
    }

    private Collection<DfsPackDescription> toPrune() {
        DfsPackDescription d2;
        HashSet<DfsPackDescription> packs = new HashSet<DfsPackDescription>();
        for (DfsPackFile pack2 : this.srcPacks) {
            packs.add(pack2.getPackDescription());
        }
        HashSet<DfsPackDescription> reftables = new HashSet<DfsPackDescription>();
        for (DfsReftable table : this.srcReftables) {
            reftables.add(table.getPackDescription());
        }
        Iterator i2 = packs.iterator();
        while (i2.hasNext()) {
            d2 = (DfsPackDescription)i2.next();
            if (!d2.hasFileExt(PackExt.REFTABLE) || reftables.contains(d2)) continue;
            i2.remove();
        }
        i2 = reftables.iterator();
        while (i2.hasNext()) {
            d2 = (DfsPackDescription)i2.next();
            if (!d2.hasFileExt(PackExt.PACK) || packs.contains(d2)) continue;
            i2.remove();
        }
        HashSet<DfsPackDescription> toPrune = new HashSet<DfsPackDescription>();
        toPrune.addAll(packs);
        toPrune.addAll(reftables);
        return toPrune;
    }

    private void addObjectsToPack(PackWriter pw, DfsReader ctx, ProgressMonitor pm) throws IOException, IncorrectObjectTypeException {
        Collections.sort(this.srcPacks, Comparator.comparing(DfsPackFile::getPackDescription, DfsPackDescription.objectLookupComparator()));
        this.rw = new RevWalk(ctx);
        this.added = this.rw.newFlag("ADDED");
        this.isBase = this.rw.newFlag("IS_BASE");
        BlockList baseObjects = new BlockList();
        pm.beginTask(JGitText.get().countingObjects, 0);
        for (DfsPackFile src : this.srcPacks) {
            List<ObjectIdWithOffset> want = this.toInclude(src, ctx);
            if (want.isEmpty()) continue;
            PackReverseIndex rev = src.getReverseIdx(ctx);
            DfsObjectRepresentation rep2 = new DfsObjectRepresentation(src);
            for (ObjectIdWithOffset id : want) {
                RevObject base;
                int type2;
                RevObject obj = this.rw.lookupAny(id, type2 = src.getObjectType(ctx, id.offset));
                if (obj.has(this.added)) continue;
                pm.update(1);
                pw.addObject(obj);
                obj.add(this.added);
                src.fillRepresentation(rep2, id.offset, ctx, rev);
                if (rep2.getFormat() != 0 || (base = this.rw.lookupAny(rep2.getDeltaBase(), type2)).has(this.added) || base.has(this.isBase)) continue;
                baseObjects.add(base);
                base.add(this.isBase);
            }
        }
        for (RevObject obj : baseObjects) {
            if (obj.has(this.added)) continue;
            pm.update(1);
            pw.addObject(obj);
            obj.add(this.added);
        }
        pm.endTask();
    }

    private List<ObjectIdWithOffset> toInclude(DfsPackFile src, DfsReader ctx) throws IOException {
        PackIndex srcIdx = src.getPackIndex(ctx);
        BlockList<ObjectIdWithOffset> want = new BlockList<ObjectIdWithOffset>((int)srcIdx.getObjectCount());
        block0: for (PackIndex.MutableEntry ent : srcIdx) {
            ObjectId id = ent.toObjectId();
            RevObject obj = this.rw.lookupOrNull(id);
            if (obj != null && (obj.has(this.added) || obj.has(this.isBase))) continue;
            for (ObjectIdSet e2 : this.exclude) {
                if (e2.contains(id)) continue block0;
            }
            want.add(new ObjectIdWithOffset(id, ent.getOffset()));
        }
        Collections.sort(want, (a2, b2) -> Long.signum(a2.offset - b2.offset));
        return want;
    }

    private static void writePack(DfsObjDatabase objdb, DfsPackDescription pack2, PackWriter pw, ProgressMonitor pm) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (DfsOutputStream out2 = objdb.writeFile(pack2, PackExt.PACK);){
            pw.writePack(pm, pm, out2);
            pack2.addFileExt(PackExt.PACK);
            pack2.setBlockSize(PackExt.PACK, out2.blockSize());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void writeIndex(DfsObjDatabase objdb, DfsPackDescription pack2, PackWriter pw) throws IOException {
        pw.writeIndex(objdb.getPackIndexWriter(pack2, pw.getIndexVersion()));
    }

    private static void writeObjectSizeIndex(DfsObjDatabase objdb, DfsPackDescription pack2, PackWriter pw) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (DfsOutputStream out2 = objdb.writeFile(pack2, PackExt.OBJECT_SIZE_INDEX);){
            CountingOutputStream cnt = new CountingOutputStream(out2);
            pw.writeObjectSizeIndex(cnt);
            if (cnt.getCount() > 0L) {
                pack2.addFileExt(PackExt.OBJECT_SIZE_INDEX);
                pack2.setFileSize(PackExt.OBJECT_SIZE_INDEX, cnt.getCount());
                pack2.setBlockSize(PackExt.OBJECT_SIZE_INDEX, out2.blockSize());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    static ReftableConfig configureReftable(ReftableConfig cfg, DfsOutputStream out2) {
        int bs = out2.blockSize();
        if (bs > 0) {
            cfg = new ReftableConfig(cfg);
            cfg.setRefBlockSize(bs);
            cfg.setAlignBlocks(true);
        }
        return cfg;
    }

    private static class ObjectIdWithOffset
    extends ObjectId {
        final long offset;

        ObjectIdWithOffset(AnyObjectId id, long ofs) {
            super(id);
            this.offset = ofs;
        }
    }
}

