/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.StoredObjectRepresentationNotAvailableException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.commitgraph.CommitGraph;
import org.eclipse.jgit.internal.storage.dfs.BlockBasedFile;
import org.eclipse.jgit.internal.storage.dfs.DeltaBaseCache;
import org.eclipse.jgit.internal.storage.dfs.DfsBlock;
import org.eclipse.jgit.internal.storage.dfs.DfsCachedPack;
import org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase;
import org.eclipse.jgit.internal.storage.dfs.DfsObjectRepresentation;
import org.eclipse.jgit.internal.storage.dfs.DfsObjectToPack;
import org.eclipse.jgit.internal.storage.dfs.DfsPackDescription;
import org.eclipse.jgit.internal.storage.dfs.DfsPackFile;
import org.eclipse.jgit.internal.storage.dfs.DfsReaderIoStats;
import org.eclipse.jgit.internal.storage.dfs.DfsReaderOptions;
import org.eclipse.jgit.internal.storage.file.BitmapIndexImpl;
import org.eclipse.jgit.internal.storage.file.PackBitmapIndex;
import org.eclipse.jgit.internal.storage.pack.CachedPack;
import org.eclipse.jgit.internal.storage.pack.ObjectReuseAsIs;
import org.eclipse.jgit.internal.storage.pack.ObjectToPack;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.internal.storage.pack.PackOutputStream;
import org.eclipse.jgit.internal.storage.pack.PackWriter;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.AsyncObjectLoaderQueue;
import org.eclipse.jgit.lib.AsyncObjectSizeQueue;
import org.eclipse.jgit.lib.BitmapIndex;
import org.eclipse.jgit.lib.InflaterCache;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;

public class DfsReader
extends ObjectReader
implements ObjectReuseAsIs {
    private static final int MAX_RESOLVE_MATCHES = 256;
    final byte[] tempId = new byte[20];
    final DfsObjDatabase db;
    final DfsReaderIoStats.Accumulator stats = new DfsReaderIoStats.Accumulator();
    private Inflater inf;
    private DfsBlock block;
    private DeltaBaseCache baseCache;
    private DfsPackFile last;
    private boolean avoidUnreachable;
    private List<PackLoadListener> packLoadListeners = new ArrayList<PackLoadListener>();
    private static final Comparator<FoundObject<?>> FOUND_OBJECT_SORT = (a2, b2) -> {
        int cmp = a2.packIndex - b2.packIndex;
        if (cmp == 0) {
            cmp = Long.signum(a2.offset - b2.offset);
        }
        return cmp;
    };
    private static final Comparator<DfsPackFile> PACK_SORT_FOR_REUSE = Comparator.comparing(DfsPackFile::getPackDescription, DfsPackDescription.reuseComparator());

    protected DfsReader(DfsObjDatabase db) {
        this.db = db;
        this.streamFileThreshold = db.getReaderOptions().getStreamFileThreshold();
    }

    DfsReaderOptions getOptions() {
        return this.db.getReaderOptions();
    }

    DeltaBaseCache getDeltaBaseCache() {
        if (this.baseCache == null) {
            this.baseCache = new DeltaBaseCache(this);
        }
        return this.baseCache;
    }

    @Override
    public ObjectReader newReader() {
        return this.db.newReader();
    }

    @Override
    public void setAvoidUnreachableObjects(boolean avoid) {
        this.avoidUnreachable = avoid;
    }

    @Override
    public BitmapIndex getBitmapIndex() throws IOException {
        DfsPackFile[] dfsPackFileArray = this.db.getPacks();
        int n = dfsPackFileArray.length;
        int n2 = 0;
        while (n2 < n) {
            DfsPackFile pack2 = dfsPackFileArray[n2];
            PackBitmapIndex bitmapIndex = pack2.getBitmapIndex(this);
            if (bitmapIndex != null) {
                return this.createBitmapIndex(bitmapIndex);
            }
            ++n2;
        }
        return null;
    }

    protected BitmapIndex createBitmapIndex(@NonNull PackBitmapIndex packBitmapIndex) {
        return new BitmapIndexImpl(packBitmapIndex);
    }

    @Override
    public Optional<CommitGraph> getCommitGraph() throws IOException {
        DfsPackFile[] dfsPackFileArray = this.db.getPacks();
        int n = dfsPackFileArray.length;
        int n2 = 0;
        while (n2 < n) {
            DfsPackFile pack2 = dfsPackFileArray[n2];
            CommitGraph cg = pack2.getCommitGraph(this);
            if (cg != null) {
                return Optional.of(cg);
            }
            ++n2;
        }
        return Optional.empty();
    }

    @Override
    public Collection<CachedPack> getCachedPacksAndUpdate(BitmapIndex.BitmapBuilder needBitmap) throws IOException {
        DfsPackFile[] dfsPackFileArray = this.db.getPacks();
        int n = dfsPackFileArray.length;
        int n2 = 0;
        while (n2 < n) {
            DfsPackFile pack2 = dfsPackFileArray[n2];
            PackBitmapIndex bitmapIndex = pack2.getBitmapIndex(this);
            if (needBitmap.removeAllOrNone(bitmapIndex)) {
                return Collections.singletonList(new DfsCachedPack(pack2));
            }
            ++n2;
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<ObjectId> resolve(AbbreviatedObjectId id) throws IOException {
        if (id.isComplete()) {
            return Collections.singleton(id.toObjectId());
        }
        HashSet<ObjectId> matches2 = new HashSet<ObjectId>(4);
        DfsObjDatabase.PackList packList = this.db.getPackList();
        this.resolveImpl(packList, id, matches2);
        if (matches2.size() < 256 && packList.dirty()) {
            ++this.stats.scanPacks;
            this.resolveImpl(this.db.scanPacks(packList), id, matches2);
        }
        return matches2;
    }

    private void resolveImpl(DfsObjDatabase.PackList packList, AbbreviatedObjectId id, HashSet<ObjectId> matches2) throws IOException {
        DfsPackFile[] dfsPackFileArray = packList.packs;
        int n = packList.packs.length;
        int n2 = 0;
        while (n2 < n) {
            DfsPackFile pack2 = dfsPackFileArray[n2];
            if (!this.skipGarbagePack(pack2)) {
                pack2.resolve(this, matches2, id, 256);
                if (matches2.size() >= 256) break;
            }
            ++n2;
        }
    }

    @Override
    public boolean has(AnyObjectId objectId) throws IOException {
        if (this.last != null && !this.skipGarbagePack(this.last) && this.last.hasObject(this, objectId)) {
            return true;
        }
        DfsObjDatabase.PackList packList = this.db.getPackList();
        if (this.hasImpl(packList, objectId)) {
            return true;
        }
        if (packList.dirty()) {
            ++this.stats.scanPacks;
            return this.hasImpl(this.db.scanPacks(packList), objectId);
        }
        return false;
    }

    private boolean hasImpl(DfsObjDatabase.PackList packList, AnyObjectId objectId) throws IOException {
        DfsPackFile[] dfsPackFileArray = packList.packs;
        int n = packList.packs.length;
        int n2 = 0;
        while (n2 < n) {
            DfsPackFile pack2 = dfsPackFileArray[n2];
            if (pack2 != this.last && !this.skipGarbagePack(pack2) && pack2.hasObject(this, objectId)) {
                this.last = pack2;
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public ObjectLoader open(AnyObjectId objectId, int typeHint) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        ObjectLoader ldr;
        if (this.last != null && !this.skipGarbagePack(this.last) && (ldr = this.last.get(this, objectId)) != null) {
            return DfsReader.checkType(ldr, objectId, typeHint);
        }
        DfsObjDatabase.PackList packList = this.db.getPackList();
        ldr = this.openImpl(packList, objectId);
        if (ldr != null) {
            return DfsReader.checkType(ldr, objectId, typeHint);
        }
        if (packList.dirty()) {
            ++this.stats.scanPacks;
            ldr = this.openImpl(this.db.scanPacks(packList), objectId);
            if (ldr != null) {
                return DfsReader.checkType(ldr, objectId, typeHint);
            }
        }
        if (typeHint == -1) {
            throw new MissingObjectException(objectId.copy(), JGitText.get().unknownObjectType2);
        }
        throw new MissingObjectException(objectId.copy(), typeHint);
    }

    private static ObjectLoader checkType(ObjectLoader ldr, AnyObjectId id, int typeHint) throws IncorrectObjectTypeException {
        if (typeHint != -1 && ldr.getType() != typeHint) {
            throw new IncorrectObjectTypeException(id.copy(), typeHint);
        }
        return ldr;
    }

    private ObjectLoader openImpl(DfsObjDatabase.PackList packList, AnyObjectId objectId) throws IOException {
        DfsPackFile[] dfsPackFileArray = packList.packs;
        int n = packList.packs.length;
        int n2 = 0;
        while (n2 < n) {
            ObjectLoader ldr;
            DfsPackFile pack2 = dfsPackFileArray[n2];
            if (pack2 != this.last && !this.skipGarbagePack(pack2) && (ldr = pack2.get(this, objectId)) != null) {
                this.last = pack2;
                return ldr;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public Set<ObjectId> getShallowCommits() {
        return Collections.emptySet();
    }

    private <T extends ObjectId> Iterable<FoundObject<T>> findAll(Iterable<T> objectIds) throws IOException {
        HashSet<ObjectId> pending = new HashSet<ObjectId>();
        for (ObjectId id : objectIds) {
            pending.add(id);
        }
        DfsObjDatabase.PackList packList = this.db.getPackList();
        ArrayList<FoundObject<T>> r = new ArrayList<FoundObject<T>>();
        this.findAllImpl(packList, pending, r);
        if (!pending.isEmpty() && packList.dirty()) {
            ++this.stats.scanPacks;
            this.findAllImpl(this.db.scanPacks(packList), pending, r);
        }
        for (ObjectId t2 : pending) {
            r.add(new FoundObject<ObjectId>(t2));
        }
        Collections.sort(r, FOUND_OBJECT_SORT);
        return r;
    }

    private <T extends ObjectId> void findAllImpl(DfsObjDatabase.PackList packList, HashSet<T> pending, List<FoundObject<T>> r) {
        DfsPackFile[] packs = packList.packs;
        if (packs.length == 0) {
            return;
        }
        int lastIdx = 0;
        DfsPackFile lastPack = packs[lastIdx];
        HashSet<ObjectId> toRemove = new HashSet<ObjectId>();
        block4: for (ObjectId t2 : pending) {
            if (!this.skipGarbagePack(lastPack)) {
                try {
                    long p = lastPack.findOffset(this, t2);
                    if (0L < p) {
                        r.add(new FoundObject<ObjectId>(t2, lastIdx, lastPack, p));
                        toRemove.add(t2);
                        continue;
                    }
                }
                catch (IOException p) {
                    // empty catch block
                }
            }
            int i2 = 0;
            while (i2 < packs.length) {
                DfsPackFile pack2;
                if (i2 != lastIdx && !this.skipGarbagePack(pack2 = packs[i2])) {
                    try {
                        long p = pack2.findOffset(this, t2);
                        if (0L < p) {
                            r.add(new FoundObject<ObjectId>(t2, i2, pack2, p));
                            toRemove.add(t2);
                            lastIdx = i2;
                            lastPack = pack2;
                            continue block4;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                ++i2;
            }
        }
        pending.removeAll(toRemove);
        this.last = lastPack;
    }

    private boolean skipGarbagePack(DfsPackFile pack2) {
        return this.avoidUnreachable && pack2.isGarbage();
    }

    @Override
    public <T extends ObjectId> AsyncObjectLoaderQueue<T> open(Iterable<T> objectIds, boolean reportMissing) {
        Iterable<FoundObject<T>> order;
        IOException error2 = null;
        try {
            order = this.findAll(objectIds);
        }
        catch (IOException e2) {
            order = Collections.emptyList();
            error2 = e2;
        }
        final Iterator<FoundObject<T>> idItr = order.iterator();
        final IOException findAllError = error2;
        return new AsyncObjectLoaderQueue<T>(){
            private FoundObject<T> cur;

            @Override
            public boolean next() throws MissingObjectException, IOException {
                if (idItr.hasNext()) {
                    this.cur = (FoundObject)idItr.next();
                    return true;
                }
                if (findAllError != null) {
                    throw findAllError;
                }
                return false;
            }

            @Override
            public T getCurrent() {
                return this.cur.id;
            }

            @Override
            public ObjectId getObjectId() {
                return this.cur.id;
            }

            @Override
            public ObjectLoader open() throws IOException {
                if (this.cur.pack == null) {
                    throw new MissingObjectException((ObjectId)this.cur.id, JGitText.get().unknownObjectType2);
                }
                return this.cur.pack.load(DfsReader.this, this.cur.offset);
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return true;
            }

            @Override
            public void release() {
            }
        };
    }

    @Override
    public <T extends ObjectId> AsyncObjectSizeQueue<T> getObjectSize(Iterable<T> objectIds, boolean reportMissing) {
        Iterable<FoundObject<T>> order;
        IOException error2 = null;
        try {
            order = this.findAll(objectIds);
        }
        catch (IOException e2) {
            order = Collections.emptyList();
            error2 = e2;
        }
        final Iterator<FoundObject<T>> idItr = order.iterator();
        final IOException findAllError = error2;
        return new AsyncObjectSizeQueue<T>(){
            private FoundObject<T> cur;
            private long sz;

            @Override
            public boolean next() throws MissingObjectException, IOException {
                if (idItr.hasNext()) {
                    this.cur = (FoundObject)idItr.next();
                    if (this.cur.pack == null) {
                        throw new MissingObjectException((ObjectId)this.cur.id, JGitText.get().unknownObjectType2);
                    }
                    this.sz = this.cur.pack.getObjectSize(DfsReader.this, this.cur.offset);
                    return true;
                }
                if (findAllError != null) {
                    throw findAllError;
                }
                return false;
            }

            @Override
            public T getCurrent() {
                return this.cur.id;
            }

            @Override
            public ObjectId getObjectId() {
                return this.cur.id;
            }

            @Override
            public long getSize() {
                return this.sz;
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return true;
            }

            @Override
            public void release() {
            }
        };
    }

    @Override
    public long getObjectSize(AnyObjectId objectId, int typeHint) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        DfsPackFile pack2 = this.findPackWithObject(objectId);
        if (pack2 == null) {
            if (typeHint == -1) {
                throw new MissingObjectException(objectId.copy(), JGitText.get().unknownObjectType2);
            }
            throw new MissingObjectException(objectId.copy(), typeHint);
        }
        if (typeHint != 3 || !this.safeHasObjectSizeIndex(pack2)) {
            return pack2.getObjectSize(this, objectId);
        }
        Optional<Long> maybeSz = this.safeGetIndexedObjectSize(pack2, objectId);
        long sz = maybeSz.orElse(-1L);
        if (sz >= 0L) {
            return sz;
        }
        return pack2.getObjectSize(this, objectId);
    }

    @Override
    public boolean isNotLargerThan(AnyObjectId objectId, int typeHint, long limit) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        DfsPackFile pack2 = this.findPackWithObject(objectId);
        if (pack2 == null) {
            if (typeHint == -1) {
                throw new MissingObjectException(objectId.copy(), JGitText.get().unknownObjectType2);
            }
            throw new MissingObjectException(objectId.copy(), typeHint);
        }
        ++this.stats.isNotLargerThanCallCount;
        if (typeHint != 3 || !this.safeHasObjectSizeIndex(pack2)) {
            return pack2.getObjectSize(this, objectId) <= limit;
        }
        Optional<Long> maybeSz = this.safeGetIndexedObjectSize(pack2, objectId);
        if (maybeSz.isEmpty()) {
            return pack2.getObjectSize(this, objectId) <= limit;
        }
        long sz = maybeSz.get();
        if (sz >= 0L) {
            return sz <= limit;
        }
        if (this.isLimitInsideIndexThreshold(pack2, limit)) {
            return true;
        }
        return pack2.getObjectSize(this, objectId) <= limit;
    }

    private boolean safeHasObjectSizeIndex(DfsPackFile pack2) {
        try {
            return pack2.hasObjectSizeIndex(this);
        }
        catch (IOException e2) {
            return false;
        }
    }

    private Optional<Long> safeGetIndexedObjectSize(DfsPackFile pack2, AnyObjectId objectId) {
        long sz;
        try {
            sz = pack2.getIndexedObjectSize(this, objectId);
        }
        catch (IOException e2) {
            return Optional.empty();
        }
        if (sz < 0L) {
            ++this.stats.objectSizeIndexMiss;
        } else {
            ++this.stats.objectSizeIndexHit;
        }
        return Optional.of(sz);
    }

    private boolean isLimitInsideIndexThreshold(DfsPackFile pack2, long limit) {
        try {
            return (long)pack2.getObjectSizeIndexThreshold(this) <= limit;
        }
        catch (IOException e2) {
            return false;
        }
    }

    private DfsPackFile findPackWithObject(AnyObjectId objectId) throws IOException {
        if (this.last != null && !this.skipGarbagePack(this.last) && this.last.hasObject(this, objectId)) {
            return this.last;
        }
        DfsObjDatabase.PackList packList = this.db.getPackList();
        if (this.hasImpl(packList, objectId)) {
            return this.last;
        }
        if (packList.dirty() && this.hasImpl(this.db.getPackList(), objectId)) {
            return this.last;
        }
        return null;
    }

    @Override
    public DfsObjectToPack newObjectToPack(AnyObjectId objectId, int type2) {
        return new DfsObjectToPack(objectId, type2);
    }

    @Override
    public void selectObjectRepresentation(PackWriter packer, ProgressMonitor monitor, Iterable<ObjectToPack> objects) throws IOException, MissingObjectException {
        List<DfsPackFile> packs = this.sortPacksForSelectRepresentation();
        this.trySelectRepresentation(packer, monitor, objects, packs, false);
        List<DfsPackFile> garbage = this.garbagePacksForSelectRepresentation();
        if (!garbage.isEmpty() && DfsReader.checkGarbagePacks(objects)) {
            this.trySelectRepresentation(packer, monitor, objects, garbage, true);
        }
    }

    private void trySelectRepresentation(PackWriter packer, ProgressMonitor monitor, Iterable<ObjectToPack> objects, List<DfsPackFile> packs, boolean skipFound) throws IOException {
        for (DfsPackFile pack2 : packs) {
            List<DfsObjectToPack> inPack = pack2.findAllFromPack(this, objects, skipFound);
            if (inPack.isEmpty()) continue;
            DfsObjectRepresentation rep2 = new DfsObjectRepresentation(pack2);
            for (DfsObjectToPack otp : inPack) {
                pack2.fillRepresentation(rep2, otp.getOffset(), this);
                otp.setOffset(0L);
                packer.select(otp, rep2);
                if (otp.isFound()) continue;
                otp.setFound();
                monitor.update(1);
            }
        }
    }

    private List<DfsPackFile> sortPacksForSelectRepresentation() throws IOException {
        DfsPackFile[] packs = this.db.getPacks();
        ArrayList<DfsPackFile> sorted2 = new ArrayList<DfsPackFile>(packs.length);
        DfsPackFile[] dfsPackFileArray = packs;
        int n = packs.length;
        int n2 = 0;
        while (n2 < n) {
            DfsPackFile p = dfsPackFileArray[n2];
            if (p.getPackDescription().getPackSource() != DfsObjDatabase.PackSource.UNREACHABLE_GARBAGE) {
                sorted2.add(p);
            }
            ++n2;
        }
        Collections.sort(sorted2, PACK_SORT_FOR_REUSE);
        return sorted2;
    }

    private List<DfsPackFile> garbagePacksForSelectRepresentation() throws IOException {
        DfsPackFile[] packs = this.db.getPacks();
        ArrayList<DfsPackFile> garbage = new ArrayList<DfsPackFile>(packs.length);
        DfsPackFile[] dfsPackFileArray = packs;
        int n = packs.length;
        int n2 = 0;
        while (n2 < n) {
            DfsPackFile p = dfsPackFileArray[n2];
            if (p.getPackDescription().getPackSource() == DfsObjDatabase.PackSource.UNREACHABLE_GARBAGE) {
                garbage.add(p);
            }
            ++n2;
        }
        return garbage;
    }

    private static boolean checkGarbagePacks(Iterable<ObjectToPack> objects) {
        for (ObjectToPack otp : objects) {
            if (((DfsObjectToPack)otp).isFound()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void copyObjectAsIs(PackOutputStream out2, ObjectToPack otp, boolean validate) throws IOException, StoredObjectRepresentationNotAvailableException {
        DfsObjectToPack src = (DfsObjectToPack)otp;
        src.pack.copyAsIs(out2, src, validate, this);
    }

    @Override
    public void writeObjects(PackOutputStream out2, List<ObjectToPack> list) throws IOException {
        for (ObjectToPack otp : list) {
            out2.writeObject(otp);
        }
    }

    @Override
    public void copyPackAsIs(PackOutputStream out2, CachedPack pack2) throws IOException {
        ((DfsCachedPack)pack2).copyAsIs(out2, this);
    }

    int copy(BlockBasedFile file2, long position, byte[] dstbuf, int dstoff, int cnt) throws IOException {
        if (cnt == 0) {
            return 0;
        }
        long length = file2.length;
        if (0L <= length && length <= position) {
            return 0;
        }
        int need = cnt;
        do {
            this.pin(file2, position);
            int r = this.block.copy(position, dstbuf, dstoff, need);
            position += (long)r;
            dstoff += r;
            need -= r;
            if (length >= 0L) continue;
            length = file2.length;
        } while (need > 0 && position < length);
        return cnt - need;
    }

    int inflate(DfsPackFile pack2, long position, byte[] dstbuf, boolean headerOnly) throws IOException, DataFormatException {
        long start2 = System.nanoTime();
        this.prepareInflater();
        this.pin(pack2, position);
        position += (long)this.block.setInput(position, this.inf);
        int dstoff = 0;
        while (true) {
            int n = this.inf.inflate(dstbuf, dstoff, dstbuf.length - dstoff);
            if (this.inf.finished() || headerOnly && (dstoff += n) == dstbuf.length) {
                this.stats.inflatedBytes += (long)dstoff;
                this.stats.inflationMicros += BlockBasedFile.elapsedMicros(start2);
                return dstoff;
            }
            if (this.inf.needsInput()) {
                this.pin(pack2, position);
                position += (long)this.block.setInput(position, this.inf);
                continue;
            }
            if (n == 0) break;
        }
        throw new DataFormatException();
    }

    DfsBlock quickCopy(DfsPackFile p, long pos, long cnt) throws IOException {
        this.pin(p, pos);
        if (this.block.contains(p.key, pos + (cnt - 1L))) {
            return this.block;
        }
        return null;
    }

    Inflater inflater() {
        this.prepareInflater();
        return this.inf;
    }

    private void prepareInflater() {
        if (this.inf == null) {
            this.inf = InflaterCache.get();
        } else {
            this.inf.reset();
        }
    }

    void pin(BlockBasedFile file2, long position) throws IOException {
        if (this.block == null || !this.block.contains(file2.key, position)) {
            this.block = null;
            this.block = file2.getOrLoadBlock(position, this);
        }
    }

    void unpin() {
        this.block = null;
    }

    public DfsReaderIoStats getIoStats() {
        return new DfsReaderIoStats(this.stats);
    }

    void emitIndexLoad(DfsPackDescription packDescription, PackExt ext, Object loadedIdx) {
        this.packLoadListeners.forEach(listener -> listener.onIndexLoad(packDescription.getFileName(ext), packDescription.getPackSource(), ext, packDescription.getFileSize(ext), loadedIdx));
    }

    void emitBlockLoad(BlockBasedFile file2, long position, DfsBlock dfsBlock) {
        this.packLoadListeners.forEach(listener -> listener.onBlockLoad(file2.getFileName(), blockBasedFile.desc.getPackSource(), blockBasedFile.ext, position, PackLoadListener.DfsBlockData.of(dfsBlock)));
    }

    protected void addPackLoadListener(PackLoadListener listener) {
        this.packLoadListeners.add(listener);
    }

    @Override
    public void close() {
        this.last = null;
        this.block = null;
        this.baseCache = null;
        try {
            InflaterCache.release(this.inf);
        }
        finally {
            this.inf = null;
        }
    }

    private static class FoundObject<T extends ObjectId> {
        final T id;
        final DfsPackFile pack;
        final long offset;
        final int packIndex;

        FoundObject(T objectId, int packIdx, DfsPackFile pack2, long offset) {
            this.id = objectId;
            this.pack = pack2;
            this.offset = offset;
            this.packIndex = packIdx;
        }

        FoundObject(T objectId) {
            this.id = objectId;
            this.pack = null;
            this.offset = 0L;
            this.packIndex = 0;
        }
    }

    protected static interface PackLoadListener {
        public void onIndexLoad(String var1, DfsObjDatabase.PackSource var2, PackExt var3, long var4, Object var6);

        public void onBlockLoad(String var1, DfsObjDatabase.PackSource var2, PackExt var3, long var4, DfsBlockData var6);

        public static class DfsBlockData {
            private final int identityHash;
            private final int size;

            static DfsBlockData of(DfsBlock src) {
                return new DfsBlockData(src);
            }

            private DfsBlockData(DfsBlock src) {
                this.identityHash = System.identityHashCode(src);
                this.size = src.size();
            }

            public int getIdentityHash() {
                return this.identityHash;
            }

            public int getSize() {
                return this.size;
            }
        }
    }
}

