/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.jgit.internal.storage.dfs.BlockBasedFile;
import org.eclipse.jgit.internal.storage.dfs.DfsBlock;
import org.eclipse.jgit.internal.storage.dfs.DfsBlockCache;
import org.eclipse.jgit.internal.storage.dfs.DfsPackDescription;
import org.eclipse.jgit.internal.storage.dfs.DfsReader;
import org.eclipse.jgit.internal.storage.dfs.ReadableChannel;
import org.eclipse.jgit.internal.storage.io.BlockSource;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.internal.storage.reftable.ReftableReader;

public class DfsReftable
extends BlockBasedFile {
    public DfsReftable(DfsPackDescription desc) {
        this(DfsBlockCache.getInstance(), desc);
    }

    public DfsReftable(DfsBlockCache cache2, DfsPackDescription desc) {
        super(cache2, desc, PackExt.REFTABLE);
        long sz;
        int bs = desc.getBlockSize(PackExt.REFTABLE);
        if (bs > 0) {
            this.setBlockSize(bs);
        }
        this.length = (sz = desc.getFileSize(PackExt.REFTABLE)) > 0L ? sz : -1L;
    }

    public DfsPackDescription getPackDescription() {
        return this.desc;
    }

    public ReftableReader open(DfsReader ctx) throws IOException {
        return new ReftableReader(new CacheSource(this, this.cache, ctx));
    }

    private static final class CacheSource
    extends BlockSource {
        private final DfsReftable file;
        private final DfsBlockCache cache;
        private final DfsReader ctx;
        private ReadableChannel ch;
        private int readAhead;

        CacheSource(DfsReftable file2, DfsBlockCache cache2, DfsReader ctx) {
            this.file = file2;
            this.cache = cache2;
            this.ctx = ctx;
        }

        @Override
        public ByteBuffer read(long pos, int cnt) throws IOException {
            if (this.ch == null && this.readAhead > 0 && this.notInCache(pos)) {
                this.open().setReadAheadBytes(this.readAhead);
            }
            DfsBlock block2 = this.cache.getOrLoad(this.file, pos, this.ctx, () -> this.open());
            if (block2.start == pos && block2.size() >= cnt) {
                return block2.zeroCopyByteBuffer(cnt);
            }
            byte[] dst = new byte[cnt];
            ByteBuffer buf = ByteBuffer.wrap(dst);
            buf.position(this.ctx.copy(this.file, pos, dst, 0, cnt));
            return buf;
        }

        private boolean notInCache(long pos) {
            return this.cache.get(this.file.key, this.file.alignToBlock(pos)) == null;
        }

        @Override
        public long size() throws IOException {
            long n = this.file.length;
            if (n < 0L) {
                this.file.length = n = this.open().size();
            }
            return n;
        }

        @Override
        public void adviseSequentialRead(long start2, long end2) {
            int sz = this.ctx.getOptions().getStreamPackBufferSize();
            if (sz > 0) {
                this.readAhead = (int)Math.min((long)sz, end2 - start2);
            }
        }

        private ReadableChannel open() throws IOException {
            if (this.ch == null) {
                this.ch = this.ctx.db.openFile(this.file.desc, this.file.ext);
            }
            return this.ch;
        }

        @Override
        public void close() {
            if (this.ch != null) {
                try {
                    try {
                        this.ch.close();
                    }
                    catch (IOException iOException) {
                        this.ch = null;
                    }
                }
                finally {
                    this.ch = null;
                }
            }
        }
    }
}

