/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase;
import org.eclipse.jgit.internal.storage.dfs.DfsOutputStream;
import org.eclipse.jgit.internal.storage.dfs.DfsPackCompactor;
import org.eclipse.jgit.internal.storage.dfs.DfsPackDescription;
import org.eclipse.jgit.internal.storage.dfs.DfsReftable;
import org.eclipse.jgit.internal.storage.dfs.DfsReftableDatabase;
import org.eclipse.jgit.internal.storage.dfs.DfsReftableStack;
import org.eclipse.jgit.internal.storage.io.BlockSource;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.internal.storage.reftable.ReftableBatchRefUpdate;
import org.eclipse.jgit.internal.storage.reftable.ReftableCompactor;
import org.eclipse.jgit.internal.storage.reftable.ReftableConfig;
import org.eclipse.jgit.internal.storage.reftable.ReftableReader;
import org.eclipse.jgit.internal.storage.reftable.ReftableWriter;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.ReceiveCommand;

public class DfsReftableBatchRefUpdate
extends ReftableBatchRefUpdate {
    private static final int AVG_BYTES = 36;
    private final DfsReftableDatabase refdb;
    private final DfsObjDatabase odb;

    protected DfsReftableBatchRefUpdate(DfsReftableDatabase refdb, DfsObjDatabase odb) {
        super(refdb, refdb.reftableDatabase, refdb.getLock(), refdb.getRepository());
        this.refdb = refdb;
        this.odb = odb;
    }

    @Override
    protected void applyUpdates(List<Ref> newRefs, List<ReceiveCommand> pending) throws IOException {
        Set<DfsPackDescription> prune = Collections.emptySet();
        DfsPackDescription pack2 = this.odb.newPack(DfsObjDatabase.PackSource.INSERT);
        Throwable throwable = null;
        Object var6_7 = null;
        try (DfsOutputStream out2 = this.odb.writeFile(pack2, PackExt.REFTABLE);){
            ReftableWriter.Stats stats;
            ReftableConfig cfg = DfsPackCompactor.configureReftable(this.refdb.getReftableConfig(), out2);
            if (this.refdb.compactDuringCommit() && newRefs.size() * 36 <= cfg.getRefBlockSize() && this.canCompactTopOfStack(cfg)) {
                ByteArrayOutputStream tmp = new ByteArrayOutputStream();
                ReftableWriter rw = new ReftableWriter(cfg, tmp);
                this.write(rw, newRefs, pending);
                rw.finish();
                stats = this.compactTopOfStack(out2, cfg, tmp.toByteArray());
                prune = this.toPruneTopOfStack();
            } else {
                ReftableWriter rw = new ReftableWriter(cfg, out2);
                this.write(rw, newRefs, pending);
                rw.finish();
                stats = rw.getStats();
            }
            pack2.addFileExt(PackExt.REFTABLE);
            pack2.setReftableStats(stats);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.odb.commitPack(Collections.singleton(pack2), prune);
        this.odb.addReftable(pack2, prune);
        this.refdb.clearCache();
    }

    private boolean canCompactTopOfStack(ReftableConfig cfg) throws IOException {
        this.refdb.getLock().lock();
        try {
            DfsReftableStack stack = this.refdb.stack();
            List<ReftableReader> readers = stack.readers();
            if (readers.isEmpty()) {
                return false;
            }
            int lastIdx = readers.size() - 1;
            DfsReftable last2 = stack.files().get(lastIdx);
            DfsPackDescription desc = last2.getPackDescription();
            if (desc.getPackSource() != DfsObjDatabase.PackSource.INSERT || !this.packOnlyContainsReftable(desc)) {
                return false;
            }
            ReftableReader table = readers.get(lastIdx);
            int bs = cfg.getRefBlockSize();
            boolean bl = table.size() <= (long)(3 * bs);
            return bl;
        }
        finally {
            this.refdb.getLock().unlock();
        }
    }

    private ReftableWriter.Stats compactTopOfStack(OutputStream out2, ReftableConfig cfg, byte[] newTable) throws IOException {
        this.refdb.getLock().lock();
        try {
            List<ReftableReader> stack = this.refdb.stack().readers();
            ReftableReader last2 = stack.get(stack.size() - 1);
            ArrayList<ReftableReader> tables = new ArrayList<ReftableReader>(2);
            tables.add(last2);
            tables.add(new ReftableReader(BlockSource.from(newTable)));
            ReftableCompactor compactor = new ReftableCompactor(out2);
            compactor.setConfig(cfg);
            compactor.setIncludeDeletes(true);
            compactor.addAll(tables);
            compactor.compact();
            ReftableWriter.Stats stats = compactor.getStats();
            return stats;
        }
        finally {
            this.refdb.getLock().unlock();
        }
    }

    private Set<DfsPackDescription> toPruneTopOfStack() throws IOException {
        this.refdb.getLock().lock();
        try {
            List<DfsReftable> stack = this.refdb.stack().files();
            DfsReftable last2 = stack.get(stack.size() - 1);
            Set<DfsPackDescription> set2 = Collections.singleton(last2.getPackDescription());
            return set2;
        }
        finally {
            this.refdb.getLock().unlock();
        }
    }

    private boolean packOnlyContainsReftable(DfsPackDescription desc) {
        PackExt[] packExtArray = PackExt.values();
        int n = packExtArray.length;
        int n2 = 0;
        while (n2 < n) {
            PackExt ext = packExtArray[n2];
            if (ext != PackExt.REFTABLE && desc.hasFileExt(ext)) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

