/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.internal.storage.dfs.DfsReader;
import org.eclipse.jgit.internal.storage.dfs.DfsReftable;
import org.eclipse.jgit.internal.storage.reftable.ReftableReader;

public class DfsReftableStack
implements AutoCloseable {
    private final List<DfsReftable> files;
    private final List<ReftableReader> tables;

    public static DfsReftableStack open(DfsReader ctx, List<DfsReftable> files2) throws IOException {
        DfsReftableStack stack = new DfsReftableStack(files2.size());
        boolean close2 = true;
        try {
            for (DfsReftable t2 : files2) {
                stack.files.add(t2);
                stack.tables.add(t2.open(ctx));
            }
            close2 = false;
            DfsReftableStack dfsReftableStack = stack;
            return dfsReftableStack;
        }
        finally {
            if (close2) {
                stack.close();
            }
        }
    }

    private DfsReftableStack(int tableCnt) {
        this.files = new ArrayList<DfsReftable>(tableCnt);
        this.tables = new ArrayList<ReftableReader>(tableCnt);
    }

    public List<DfsReftable> files() {
        return Collections.unmodifiableList(this.files);
    }

    public List<ReftableReader> readers() {
        return Collections.unmodifiableList(this.tables);
    }

    @Override
    public void close() {
        for (ReftableReader t2 : this.tables) {
            try {
                t2.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

