/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jgit.internal.storage.dfs.DfsPackFile;
import org.eclipse.jgit.internal.storage.dfs.DfsReader;

final class PackInputStream
extends InputStream {
    final DfsReader ctx;
    private final DfsPackFile pack;
    private long pos;

    PackInputStream(DfsPackFile pack2, long pos, DfsReader ctx) throws IOException {
        this.pack = pack2;
        this.pos = pos;
        this.ctx = ctx;
        ctx.pin(pack2, pos);
    }

    @Override
    public int read(byte[] b2, int off, int len2) throws IOException {
        int n = this.ctx.copy(this.pack, this.pos, b2, off, len2);
        this.pos += (long)n;
        return n;
    }

    @Override
    public int read() throws IOException {
        byte[] buf = new byte[1];
        int n = this.read(buf, 0, 1);
        return n == 1 ? buf[0] & 0xFF : -1;
    }

    @Override
    public void close() {
        this.ctx.close();
    }
}

