/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.PackIndexWriterV1;
import org.eclipse.jgit.internal.storage.file.PackIndexWriterV2;
import org.eclipse.jgit.internal.storage.pack.PackIndexWriter;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.transport.PackedObjectInfo;
import org.eclipse.jgit.util.NB;

public abstract class BasePackIndexWriter
implements PackIndexWriter {
    protected static final byte[] TOC = new byte[]{-1, 116, 79, 99};
    protected final DigestOutputStream out;
    protected final byte[] tmp;
    protected List<? extends PackedObjectInfo> entries;
    protected byte[] packChecksum;

    public static PackIndexWriter createOldestPossible(OutputStream dst, List<? extends PackedObjectInfo> objs) {
        return BasePackIndexWriter.createVersion(dst, BasePackIndexWriter.oldestPossibleFormat(objs));
    }

    public static int oldestPossibleFormat(List<? extends PackedObjectInfo> objs) {
        for (PackedObjectInfo packedObjectInfo : objs) {
            if (PackIndexWriterV1.canStore(packedObjectInfo)) continue;
            return 2;
        }
        return 1;
    }

    public static PackIndexWriter createVersion(OutputStream dst, int version2) {
        switch (version2) {
            case 1: {
                return new PackIndexWriterV1(dst);
            }
            case 2: {
                return new PackIndexWriterV2(dst);
            }
        }
        throw new IllegalArgumentException(MessageFormat.format(JGitText.get().unsupportedPackIndexVersion, version2));
    }

    protected BasePackIndexWriter(OutputStream dst) {
        this.out = new DigestOutputStream(dst instanceof BufferedOutputStream ? dst : new BufferedOutputStream(dst), Constants.newMessageDigest());
        this.tmp = new byte[24];
    }

    @Override
    public void write(List<? extends PackedObjectInfo> toStore, byte[] packDataChecksum) throws IOException {
        this.entries = toStore;
        this.packChecksum = packDataChecksum;
        this.writeImpl();
        this.out.flush();
    }

    protected abstract void writeImpl() throws IOException;

    protected void writeTOC(int version2) throws IOException {
        this.out.write(TOC);
        NB.encodeInt32(this.tmp, 0, version2);
        this.out.write(this.tmp, 0, 4);
    }

    /*
     * WARNING - void declaration
     */
    protected void writeFanOutTable() throws IOException {
        void var2_6;
        int[] fanout = new int[256];
        for (PackedObjectInfo packedObjectInfo : this.entries) {
            int n = packedObjectInfo.getFirstByte() & 0xFF;
            fanout[n] = fanout[n] + 1;
        }
        boolean bl = true;
        while (var2_6 < 256) {
            void v1 = var2_6;
            fanout[v1] = fanout[v1] + fanout[var2_6 - true];
            ++var2_6;
        }
        int[] nArray = fanout;
        int n = fanout.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            NB.encodeInt32(this.tmp, 0, n3);
            this.out.write(this.tmp, 0, 4);
            ++n2;
        }
    }

    protected void writeChecksumFooter() throws IOException {
        this.out.write(this.packChecksum);
        this.out.on(false);
        this.out.write(this.out.getMessageDigest().digest());
    }
}

