/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.eclipse.jgit.internal.storage.file.ByteWindow;
import org.eclipse.jgit.internal.storage.file.Pack;
import org.eclipse.jgit.internal.storage.pack.PackOutputStream;

final class ByteArrayWindow
extends ByteWindow {
    private final byte[] array;

    ByteArrayWindow(Pack pack2, long o, byte[] b2) {
        super(pack2, o, b2.length);
        this.array = b2;
    }

    @Override
    protected int copy(int p, byte[] b2, int o, int n) {
        n = Math.min(this.array.length - p, n);
        System.arraycopy(this.array, p, b2, o, n);
        return n;
    }

    @Override
    protected int setInput(int pos, Inflater inf) throws DataFormatException {
        int n = this.array.length - pos;
        inf.setInput(this.array, pos, n);
        return n;
    }

    void crc32(CRC32 out2, long pos, int cnt) {
        out2.update(this.array, (int)(pos - this.start), cnt);
    }

    @Override
    void write(PackOutputStream out2, long pos, int cnt) throws IOException {
        int ptr = (int)(pos - this.start);
        out2.write(this.array, ptr, cnt);
    }

    void check(Inflater inf, byte[] tmp, long pos, int cnt) throws DataFormatException {
        inf.setInput(this.array, (int)(pos - this.start), cnt);
        while (inf.inflate(tmp, 0, tmp.length) > 0) {
        }
    }
}

