/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.eclipse.jgit.internal.storage.file.ByteWindow;
import org.eclipse.jgit.internal.storage.file.Pack;
import org.eclipse.jgit.internal.storage.pack.PackOutputStream;

final class ByteBufferWindow
extends ByteWindow {
    private final ByteBuffer buffer;

    ByteBufferWindow(Pack pack2, long o, ByteBuffer b2) {
        super(pack2, o, b2.capacity());
        this.buffer = b2;
    }

    @Override
    protected int copy(int p, byte[] b2, int o, int n) {
        ByteBuffer s2 = this.buffer.slice();
        s2.position(p);
        n = Math.min(s2.remaining(), n);
        s2.get(b2, o, n);
        return n;
    }

    @Override
    void write(PackOutputStream out2, long pos, int cnt) throws IOException {
        ByteBuffer s2 = this.buffer.slice();
        s2.position((int)(pos - this.start));
        while (cnt > 0) {
            byte[] buf = out2.getCopyBuffer();
            int n = Math.min(cnt, buf.length);
            s2.get(buf, 0, n);
            out2.write(buf, 0, n);
            cnt -= n;
        }
    }

    @Override
    protected int setInput(int pos, Inflater inf) throws DataFormatException {
        ByteBuffer s2 = this.buffer.slice();
        s2.position(pos);
        byte[] tmp = new byte[Math.min(s2.remaining(), 512)];
        s2.get(tmp, 0, tmp.length);
        inf.setInput(tmp, 0, tmp.length);
        return tmp.length;
    }
}

